/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.axinodes;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.soa.ui.axinodes.NodeType;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class AxiomChildren
extends Children.Keys {
    private Lookup myLookup;

    public AxiomChildren(SchemaModel schemaModel, Lookup lookup) {
        this.myLookup = lookup;
        this.setKeys(new Object[]{schemaModel});
    }

    public AxiomChildren(AXIModel aXIModel, Lookup lookup) {
        this.myLookup = lookup;
        this.setKeys(new Object[]{aXIModel});
    }

    public AxiomChildren(SchemaComponent schemaComponent, Lookup lookup) {
        this.myLookup = lookup;
        this.setKeys(new Object[]{schemaComponent});
    }

    public AxiomChildren(AXIComponent aXIComponent, Lookup lookup) {
        this.myLookup = lookup;
        this.setKeys(new Object[]{aXIComponent});
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof SchemaModel) {
            return this.createGlobalElementNodes((SchemaModel)object);
        }
        if (object instanceof AXIModel) {
            return this.createGlobalAxiElementNodes((AXIModel)object);
        }
        if (object instanceof SchemaComponent) {
            return this.createNodes((SchemaComponent)object);
        }
        if (object instanceof AXIComponent) {
            return this.createNodes((AXIComponent)object);
        }
        return new Node[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Node[] createNodes(SchemaComponent schemaComponent) {
        NamedComponentReference namedComponentReference = null;
        AXIDocument aXIDocument = null;
        if (schemaComponent instanceof GlobalElement) {
            GlobalElement globalElement = (GlobalElement)schemaComponent;
            if (globalElement == null) return new Node[0];
            AXIComponent aXIComponent = AxiomUtils.findGlobalComponent(aXIDocument = this.getAxiDocument(aXIDocument, (SchemaComponent)globalElement), Element.class, (SchemaComponent)globalElement);
            if (aXIComponent != null) return AxiomUtils.processAxiComponent(aXIComponent, this.myLookup);
            namedComponentReference = globalElement.getType();
            return new Node[0];
        } else {
            GlobalType globalType;
            if (!(schemaComponent instanceof GlobalType) || (globalType = (GlobalType)schemaComponent) == null || globalType instanceof SimpleType) return new Node[0];
            aXIDocument = this.getAxiDocument(aXIDocument, (SchemaComponent)globalType);
            AXIComponent aXIComponent = AxiomUtils.findGlobalComponent(aXIDocument, ContentModel.class, (SchemaComponent)globalType);
            return AxiomUtils.processAxiComponent(aXIComponent, this.myLookup);
        }
    }

    protected Node[] createNodes(AXIComponent aXIComponent) {
        return AxiomUtils.processAxiComponent(aXIComponent, this.myLookup);
    }

    protected Node[] createGlobalElementNodes(SchemaModel schemaModel) {
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
        return this.createGlobalAxiElementNodes(aXIModel);
    }

    protected Node[] createGlobalAxiElementNodes(AXIModel aXIModel) {
        Node[] nodeArray;
        NodeFactory nodeFactory = (NodeFactory)this.myLookup.lookup(NodeFactory.class);
        assert (nodeFactory != null) : "Node factory has to be specified";
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (aXIModel != null && (nodeArray = aXIModel.getRoot()) != null) {
            List list = nodeArray.getChildren(Element.class);
            for (Element element : list) {
                Node node = nodeFactory.createNode(NodeType.ELEMENT, element, this.myLookup);
                if (node == null) continue;
                arrayList.add(node);
            }
        }
        nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        return nodeArray;
    }

    private AXIDocument getAxiDocument(AXIDocument aXIDocument, SchemaComponent schemaComponent) {
        if (aXIDocument == null) {
            SchemaModel schemaModel = schemaComponent.getModel();
            AXIModel aXIModel = AXIModelFactory.getDefault().getModel(schemaModel);
            if (aXIModel != null) {
                aXIDocument = aXIModel.getRoot();
            }
        }
        return aXIDocument;
    }
}

