/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.query.CustomizerResults;
import org.netbeans.modules.xml.schema.refactoring.query.Query;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanelContainer;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class QueryPanel
extends JPanel
implements NodeListener {
    public static final long serialVersionUID = 1L;
    private final Query query;
    private transient boolean isVisible = false;
    private WeakReference refCallerTC;
    private AnalysisViewer analysisViewer;
    private CustomizerResults results;

    public QueryPanel(Query query) {
        this(query, null);
    }

    public QueryPanel(Query query, TopComponent topComponent) {
        if (topComponent != null) {
            this.refCallerTC = new WeakReference<TopComponent>(topComponent);
        }
        this.query = query;
        this.initialize();
        this.refresh(false);
    }

    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This must happen in event thread!"));
        }
    }

    private void initialize() {
        QueryPanel.checkEventThread();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        this.setName(this.query.getShortName());
        this.analysisViewer = new AnalysisViewer();
        this.analysisViewer.getPanel().setMinimumSize(new Dimension(10, 10));
        this.analysisViewer.getPanel().setPreferredSize(new Dimension(10, 10));
        this.add((Component)this.analysisViewer, "Center");
        this.validate();
        this.addDataOjectNodeListener();
    }

    private void addDataOjectNodeListener() {
        SchemaModel schemaModel = this.query.getModel();
        assert (schemaModel != null) : "null query model";
        DataObject dataObject = (DataObject)schemaModel.getModelSource().getLookup().lookup(DataObject.class);
        assert (dataObject != null) : "model source lookup has no data object";
        Node node = dataObject.getNodeDelegate();
        node.addNodeListener((NodeListener)WeakListeners.create(NodeListener.class, (EventListener)((Object)this), (Object)node));
    }

    void close() {
        QueryPanelContainer.getUsagesComponent().removePanel(this);
        this.closeNotify();
    }

    public boolean getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(boolean bl) {
        this.isVisible = bl;
    }

    private void refresh(boolean bl) {
        QueryPanel.checkEventThread();
        this.query.runQuery(this, this.analysisViewer);
    }

    private static void disableComponents(Container container) {
        QueryPanel.checkEventThread();
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i].isEnabled()) {
                componentArray[i].setEnabled(false);
            }
            if (!(componentArray[i] instanceof Container)) continue;
            QueryPanel.disableComponents((Container)componentArray[i]);
        }
    }

    protected void closeNotify() {
        TopComponent topComponent;
        if (this.refCallerTC != null && (topComponent = (TopComponent)this.refCallerTC.get()) != null && topComponent.isShowing()) {
            topComponent.requestActive();
        }
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                QueryPanel.this.close();
            }
        });
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }
}

