/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.ui;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.modules.xml.schema.model.ComplexContent;
import org.netbeans.modules.xml.schema.model.ComplexContentRestriction;
import org.netbeans.modules.xml.schema.model.ComplexExtension;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalComplexType;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.LocalSimpleType;
import org.netbeans.modules.xml.schema.model.Redefine;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.Sequence;
import org.netbeans.modules.xml.schema.model.SimpleContent;
import org.netbeans.modules.xml.schema.model.SimpleContentRestriction;
import org.netbeans.modules.xml.schema.model.SimpleExtension;
import org.netbeans.modules.xml.schema.model.SimpleTypeRestriction;
import org.netbeans.modules.xml.schema.model.Union;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class DisplayInfoVisitor
extends DefaultSchemaVisitor {
    private DisplayInfo info;
    private static final String EMPTY_STRING = "";

    public DisplayInfo getDisplayInfo(Component component) {
        this.info = new DisplayInfo();
        if (component instanceof Named) {
            this.info.setName(((Named)component).getName());
        }
        if (component instanceof GlobalSimpleType) {
            this.visit((GlobalSimpleType)component);
        } else if (component instanceof GlobalComplexType) {
            this.visit((GlobalComplexType)component);
        } else if (component instanceof LocalComplexType) {
            this.visit((LocalComplexType)component);
        } else if (component instanceof GlobalElement) {
            this.visit((GlobalElement)component);
        } else if (component instanceof LocalElement) {
            this.visit((LocalElement)component);
        } else if (component instanceof Sequence) {
            this.visit((Sequence)component);
        } else if (component instanceof ComplexContent) {
            this.visit((ComplexContent)component);
        } else if (component instanceof SimpleContentRestriction) {
            this.visit((SimpleContentRestriction)component);
        } else if (component instanceof ComplexContentRestriction) {
            this.visit((ComplexContentRestriction)component);
        } else if (component instanceof SimpleContent) {
            this.visit((SimpleContent)component);
        } else if (component instanceof ComplexExtension) {
            this.visit((ComplexExtension)component);
        } else if (component instanceof SimpleExtension) {
            this.visit((SimpleExtension)component);
        } else if (component instanceof SimpleTypeRestriction) {
            this.visit((SimpleTypeRestriction)component);
        } else if (component instanceof LocalSimpleType) {
            this.visit((LocalSimpleType)component);
        } else if (component instanceof GlobalAttribute) {
            this.visit((GlobalAttribute)component);
        } else if (component instanceof GlobalAttributeGroup) {
            this.visit((GlobalAttributeGroup)component);
        } else if (component instanceof GlobalGroup) {
            this.visit((GlobalGroup)component);
        } else if (component instanceof LocalAttribute) {
            this.visit((LocalAttribute)component);
        } else if (component instanceof ElementReference) {
            this.visit((ElementReference)component);
        } else if (component instanceof Union) {
            this.visit((Union)component);
        } else if (component instanceof Schema) {
            this.visit((Schema)component);
        } else if (component instanceof Redefine) {
            this.visit((Redefine)component);
        } else {
            ErrorManager.getDefault().log(16, "DisplayInfoVisitor unrecognized type  " + component == null ? EMPTY_STRING : component.getClass().toString());
        }
        return this.info;
    }

    public void visit(GlobalSimpleType globalSimpleType) {
        super.visit(globalSimpleType);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Global_Simple_Type"));
    }

    public void visit(GlobalElement globalElement) {
        super.visit(globalElement);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Global_Element"));
        NamedComponentReference namedComponentReference = globalElement.getType();
        if (namedComponentReference != null) {
            GlobalType globalType = (GlobalType)globalElement.getType().get();
            this.info.setElementType(globalType == null ? NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Undetermined_Type") : globalType.getName());
        }
    }

    public void visit(GlobalComplexType globalComplexType) {
        super.visit(globalComplexType);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Global_Complex_Type"));
    }

    public void visit(LocalElement localElement) {
        super.visit(localElement);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Local_Element"));
        NamedComponentReference namedComponentReference = localElement.getType();
        if (namedComponentReference != null) {
            GlobalType globalType = (GlobalType)localElement.getType().get();
            this.info.setElementType(globalType == null ? NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Undetermined_Type") : globalType.getName());
        }
    }

    public void visit(Sequence sequence) {
        super.visit(sequence);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Sequence"));
    }

    public void visit(LocalComplexType localComplexType) {
        super.visit(localComplexType);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Local_Complex_Type"));
    }

    public void visit(ComplexContent complexContent) {
        super.visit(complexContent);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_ComplexContent"));
    }

    public void visit(SimpleContentRestriction simpleContentRestriction) {
        super.visit(simpleContentRestriction);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_SimpleContentRestriction"));
    }

    public void visit(ComplexContentRestriction complexContentRestriction) {
        super.visit(complexContentRestriction);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_ComplexContentRestriction"));
    }

    public void visit(SimpleContent simpleContent) {
        super.visit(simpleContent);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_SimpleContent"));
    }

    public void visit(ComplexExtension complexExtension) {
        super.visit(complexExtension);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_ComplexExtension"));
    }

    public void visit(SimpleExtension simpleExtension) {
        super.visit(simpleExtension);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_SimpleExtension"));
    }

    public void visit(SimpleTypeRestriction simpleTypeRestriction) {
        super.visit(simpleTypeRestriction);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_SimpleTypeRestriction"));
    }

    public void visit(LocalSimpleType localSimpleType) {
        super.visit(localSimpleType);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_LocalSimpleType"));
    }

    public void visit(GlobalAttribute globalAttribute) {
        super.visit(globalAttribute);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_GlobalAttribute"));
        NamedComponentReference namedComponentReference = globalAttribute.getType();
        if (namedComponentReference != null) {
            GlobalType globalType = (GlobalType)globalAttribute.getType().get();
            this.info.setElementType(globalType == null ? NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Undetermined_Type") : globalType.getName());
        }
    }

    public void visit(GlobalAttributeGroup globalAttributeGroup) {
        super.visit(globalAttributeGroup);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_GlobalAttributeGroup"));
    }

    public void visit(GlobalGroup globalGroup) {
        super.visit(globalGroup);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_GlobalGroup"));
    }

    public void visit(LocalAttribute localAttribute) {
        super.visit(localAttribute);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_LocalAttribute"));
        NamedComponentReference namedComponentReference = localAttribute.getType();
        if (namedComponentReference != null) {
            GlobalType globalType = (GlobalType)localAttribute.getType().get();
            this.info.setElementType(globalType == null ? NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Undetermined_Type") : globalType.getName());
        }
    }

    public void visit(ElementReference elementReference) {
        super.visit(elementReference);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Local_Element"));
        this.info.setElementType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Global_Element"));
        NamedComponentReference namedComponentReference = elementReference.getRef();
        if (namedComponentReference != null) {
            this.info.setName(MessageFormat.format(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_References_Ref"), namedComponentReference.getQName().getLocalPart()));
        }
    }

    public void visit(Schema schema) {
        super.visit(schema);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Schema"));
        this.info.setName(schema.getTargetNamespace());
    }

    public void visit(Union union) {
        super.visit(union);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Union"));
        List list = union.getMemberTypes();
        StringBuffer stringBuffer = new StringBuffer(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Union_Members"));
        stringBuffer.append(" ");
        if (list.size() < 1) {
            stringBuffer.append(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Union_Members_None"));
        } else {
            for (NamedComponentReference namedComponentReference : list) {
                stringBuffer.append(namedComponentReference.getQName().toString());
                stringBuffer.append(" ");
            }
        }
        this.info.setName(stringBuffer.toString());
    }

    public void visit(Redefine redefine) {
        super.visit(redefine);
        this.info.setCompType(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Redefine"));
        this.info.setName(NbBundle.getMessage(DisplayInfoVisitor.class, (String)"LBL_Redefinition"));
    }

    public static class DisplayInfo {
        private String name = "";
        private String compType = "";
        private String elementType = "";

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            if (string == null) {
                string = DisplayInfoVisitor.EMPTY_STRING;
            }
            this.name = string;
        }

        public String getCompType() {
            return this.compType;
        }

        public void setCompType(String string) {
            if (string == null) {
                string = DisplayInfoVisitor.EMPTY_STRING;
            }
            this.compType = string;
        }

        public String getElementType() {
            return this.elementType;
        }

        public void setElementType(String string) {
            if (string == null) {
                string = DisplayInfoVisitor.EMPTY_STRING;
            }
            this.elementType = string;
        }
    }
}

