/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.refactoring.ui.DisplayInfoVisitor;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryUtilities;
import org.netbeans.modules.xml.xam.Named;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereUsedExplorer
extends JPanel
implements ExplorerManager.Provider {
    static final long serialVersionUID = 1L;
    protected SchemaModel model;
    protected ExplorerManager explorerManager;
    protected CustomizerTreeView treeView;
    protected int count;
    protected Action nodePreferredAction;
    public static final String ICON_BASE = "org/netbeans/modules/xml/schema/ui/nodes/resources/";
    public static final String COMPLEX_TYPE_IMAGE = "complextype.png";
    public static final String ELEMENT_IMAGE = "element.png";
    public static final String SIMPLE_TYPE_IMAGE = "simpletype.png";
    public static final String PRIMITIVE_TYPE_IMAGE = "simpletype.png";
    public static final String GROUP_IMAGE = "complextype.png";
    public static final String ATTRIBUTE_IMAGE = "attribute.png";
    public static final String ATTRIBUTE_GROUP_IMAGE = "attribute.png";
    public static final String SELECTION_CHANGED = "selection-changed";

    public WhereUsedExplorer(SchemaModel schemaModel) {
        this.model = schemaModel;
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.explorerManager = new ExplorerManager();
        Node node = this.createTree();
        this.treeView = new CustomizerTreeView();
        this.treeView.setSelectionMode(1);
        this.treeView.setRootVisible(node.getChildren().getNodesCount() <= 0);
        this.treeView.setDefaultActionAllowed(true);
        String string = "org.openide.actions.PopupAction";
        KeyStroke keyStroke = KeyStroke.getKeyStroke("shift F10");
        this.treeView.getInputMap(1).put(keyStroke, string);
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager.setRootContext(node);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                WhereUsedExplorer.this.removeComponentListener(this);
                Dimension dimension = WhereUsedExplorer.this.getSize();
                int n = WhereUsedExplorer.this.treeView.getRowHeight();
                int n2 = n * WhereUsedExplorer.this.count;
                if (dimension.height > n2) {
                    Node[] nodeArray = WhereUsedExplorer.this.explorerManager.getRootContext().getChildren().getNodes();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (nodeArray[i].getName().equals(NbBundle.getMessage(WhereUsedExplorer.class, (String)"LBL_Primitives"))) continue;
                        WhereUsedExplorer.this.treeView.expandNode(nodeArray[i]);
                    }
                }
            }
        });
    }

    public void setNodePreferredAction(Action action) {
        this.nodePreferredAction = action;
    }

    public SchemaComponent getSelectedSchemaComponent() {
        QueryCustomizerNode queryCustomizerNode = null;
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            if (!(nodeArray[0] instanceof QueryCustomizerNode)) {
                return null;
            }
            queryCustomizerNode = (QueryCustomizerNode)nodeArray[0];
            return queryCustomizerNode.getSchemaComponent();
        }
        return null;
    }

    protected Node findNodeForRef(SchemaComponentReference schemaComponentReference) {
        Node node = null;
        Node node2 = this.explorerManager.getRootContext();
        SchemaComponent schemaComponent = schemaComponentReference.get();
        Named named = null;
        if (!(schemaComponent instanceof Named)) {
            return null;
        }
        named = (Named)schemaComponent;
        if (node2 == null) {
            return null;
        }
        Node[] nodeArray = node2.getChildren().getNodes();
        if (nodeArray != null) {
            for (Node node3 : nodeArray) {
                Children children = node3.getChildren();
                node = children.findChild(named.getName());
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    protected Node createTree() {
        ArrayList<QueryCustomizerNode> arrayList;
        this.count = 0;
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        abstractNode.setName(NbBundle.getMessage(WhereUsedExplorer.class, (String)"LBL_Global_Comps"));
        ArrayList<AbstractNode> arrayList2 = new ArrayList<AbstractNode>();
        Schema schema = this.model.getSchema();
        AbstractNode abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.COMPLEX_TYPE);
        ++this.count;
        String string = "org/netbeans/modules/xml/schema/ui/nodes/resources/complextype.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getComplexTypes()) {
            arrayList = new ArrayList<QueryCustomizerNode>();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ELEMENT);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/element.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getElements()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.SIMPLE_TYPE);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/simpletype.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getSimpleTypes()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.PRIMITIVE);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/simpletype.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : SchemaModelFactory.getDefault().getPrimitiveTypesModel().getSchema().getSimpleTypes()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string, true);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.GROUP);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/complextype.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getGroups()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ATTRIBUTE);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/attribute.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getAttributes()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        abstractNode2 = QueryUtilities.createCategoryNode(AnalysisConstants.GlobalTypes.ATTRIBUTE_GROUP);
        ++this.count;
        string = "org/netbeans/modules/xml/schema/ui/nodes/resources/attribute.png";
        arrayList2.add(abstractNode2);
        for (GlobalComplexType globalComplexType : schema.getAttributeGroups()) {
            arrayList = new ArrayList();
            this.createCustomizerNode(arrayList, (Named)globalComplexType, string);
            abstractNode2.getChildren().add((Node[])arrayList.toArray(new QueryCustomizerNode[arrayList.size()]));
        }
        array.add((Node[])arrayList2.toArray(new AbstractNode[arrayList2.size()]));
        return abstractNode;
    }

    protected void createCustomizerNode(List<QueryCustomizerNode> list, Named named, String string, boolean bl) {
        QueryCustomizerNode queryCustomizerNode = null;
        queryCustomizerNode = bl ? new QueryCustomizerNode(Children.LEAF, named, bl, this.model) : new QueryCustomizerNode(Children.LEAF, named, bl);
        queryCustomizerNode.setIconBaseWithExtension(string);
        queryCustomizerNode.setName(named.getName());
        list.add(queryCustomizerNode);
        if (!bl) {
            ++this.count;
        }
    }

    protected void createCustomizerNode(List<QueryCustomizerNode> list, Named named, String string) {
        this.createCustomizerNode(list, named, string, false);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.treeView != null) {
            this.treeView.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.treeView != null) {
            this.treeView.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public String getTitle() {
        return NbBundle.getMessage(WhereUsedExplorer.class, (String)"LBL_Schema_Queries");
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public class QueryCustomizerNode
    extends AbstractNode {
        protected String type;
        protected SchemaComponent sc;
        protected boolean isPrimitive;
        protected SchemaModel userModel;

        public QueryCustomizerNode(Children children, Named named, boolean bl) {
            this(children, named, bl, null);
        }

        public QueryCustomizerNode(Children children, Named named, boolean bl, SchemaModel schemaModel) {
            super(children);
            this.sc = (SchemaComponent)SchemaComponent.class.cast(named);
            this.isPrimitive = bl;
            this.userModel = schemaModel;
        }

        public SchemaModel getUserSchemaModel() {
            return this.userModel;
        }

        protected Sheet createSheet() {
            Sheet sheet = Sheet.createDefault();
            Sheet.Set set = sheet.get("properties");
            set.put((Node.Property)new PropertySupport("type", String.class, NbBundle.getMessage(WhereUsedExplorer.class, (String)"PROP_SchemaComponentNode_Type"), "", true, false){

                public Object getValue() {
                    if (QueryCustomizerNode.this.isPrimitive) {
                        return NbBundle.getMessage(WhereUsedExplorer.class, (String)"LBL_Primitives");
                    }
                    DisplayInfoVisitor displayInfoVisitor = new DisplayInfoVisitor();
                    DisplayInfoVisitor.DisplayInfo displayInfo = displayInfoVisitor.getDisplayInfo((org.netbeans.modules.xml.xam.Component)QueryCustomizerNode.this.sc);
                    return displayInfo.getCompType();
                }

                public void setValue(Object object) {
                }
            });
            return sheet;
        }

        public SchemaComponent getSchemaComponent() {
            return this.sc;
        }

        public Action getPreferredAction() {
            if (WhereUsedExplorer.this.nodePreferredAction != null) {
                return WhereUsedExplorer.this.nodePreferredAction;
            }
            return super.getPreferredAction();
        }

        public boolean isPrimitive() {
            return this.isPrimitive;
        }
    }

    protected class CustomizerTreeView
    extends BeanTreeView {
        static final long serialVersionUID = 1L;

        public CustomizerTreeView() {
            this.setVerticalScrollBarPolicy(22);
            this.setSelectionMode(0);
        }

        public int getRowHeight() {
            return this.tree.getRowHeight();
        }

        public void setSelectedNode(Node node) {
            try {
                this.selectionChanged(new Node[]{node}, WhereUsedExplorer.this.explorerManager);
            }
            catch (PropertyVetoException propertyVetoException) {
                ErrorManager.getDefault().notify((Throwable)propertyVetoException);
            }
        }

        protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
            super.selectionChanged(nodeArray, explorerManager);
            if (nodeArray != null && nodeArray.length > 0 && nodeArray[0] instanceof QueryCustomizerNode) {
                this.firePropertyChange(WhereUsedExplorer.SELECTION_CHANGED, null, Boolean.TRUE);
                return;
            }
            this.firePropertyChange(WhereUsedExplorer.SELECTION_CHANGED, null, Boolean.FALSE);
        }
    }
}

