/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring.query;

import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.refactoring.query.Query;
import org.netbeans.modules.xml.schema.refactoring.query.views.QuerySubstitutionGroupsView;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanel;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryPanelContainer;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class QuerySubstitutionGroups
implements Query {
    protected String displayName;
    private String shortName;
    private SchemaModel model;

    public QuerySubstitutionGroups(SchemaModel schemaModel) {
        this.model = schemaModel;
        this.shortName = NbBundle.getMessage(QuerySubstitutionGroups.class, (String)"LBL_Query_SubstitutionGroups_ShortName");
        this.initialize();
    }

    private void initialize() {
        this.displayName = NbBundle.getMessage(QuerySubstitutionGroups.class, (String)"LBL_QuerySubstitutionGroupsCustomizerPanel_desc");
    }

    public String toString() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void runQuery(final QueryPanel queryPanel, final AnalysisViewer analysisViewer) {
        final QuerySubstitutionGroupsView querySubstitutionGroupsView = new QuerySubstitutionGroupsView(this.model);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QuerySubstitutionGroups.class, (String)"LBL_Finding_Substitution_Groups"));
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                querySubstitutionGroupsView.createModels();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                progressHandle.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (querySubstitutionGroupsView != null) {
                            if (!queryPanel.getIsVisible()) {
                                QueryPanelContainer queryPanelContainer = QueryPanelContainer.getUsagesComponent();
                                if (queryPanelContainer == null) {
                                    ErrorManager.getDefault().log(65536, "XML Schema Query Failed to open QueryPanelContainer. The problem could be that the XML settings and wstcref files in userdir Windows2Local are obsolete.  Try removing xml-schema-query.* and restart the IDE.");
                                    return;
                                }
                                queryPanelContainer.open();
                                queryPanelContainer.requestActive();
                                queryPanelContainer.addPanel(queryPanel);
                                queryPanel.setIsVisible(true);
                            }
                            queryPanel.requestFocus();
                            if (querySubstitutionGroupsView != null) {
                                querySubstitutionGroupsView.showView(analysisViewer);
                                analysisViewer.validate();
                                analysisViewer.repaint();
                            }
                        }
                    }
                });
            }
        });
    }

    public SchemaModel getModel() {
        return this.model;
    }
}

