/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.refactoring;

import javax.swing.Action;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.refactoring.ui.DisplayInfoVisitor;
import org.netbeans.modules.xml.schema.refactoring.ui.QueryUtilities;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ui.actions.GoToAction;
import org.netbeans.modules.xml.xam.ui.actions.ShowSourceAction;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class SchemaUIHelper {
    private static final SystemAction[] ACTIONS = new SystemAction[]{SystemAction.get(GoToAction.class)};

    public Node getDisplayNode(Component component) {
        assert (component instanceof SchemaComponent) : "This UIHelper handles SchemaComponents only";
        SchemaComponent schemaComponent = (SchemaComponent)SchemaComponent.class.cast(component);
        return this.createNode(schemaComponent);
    }

    private Node createNode(SchemaComponent schemaComponent) {
        CategorizedSchemaNodeFactory categorizedSchemaNodeFactory = new CategorizedSchemaNodeFactory(schemaComponent.getModel(), Lookups.singleton((Object)schemaComponent));
        return new FilteredSchemaNode(categorizedSchemaNodeFactory.createNode(schemaComponent), schemaComponent);
    }

    public class FilteredSchemaNode
    extends FilterNode {
        private final SchemaComponent sc;

        FilteredSchemaNode(Node node, SchemaComponent schemaComponent) {
            super(node, FilterNode.Children.LEAF);
            this.disableDelegation(504);
            this.sc = schemaComponent;
            DisplayInfoVisitor displayInfoVisitor = new DisplayInfoVisitor();
            DisplayInfoVisitor.DisplayInfo displayInfo = displayInfoVisitor.getDisplayInfo((Component)schemaComponent);
            this.setShortDescription(displayInfo.getCompType());
            this.setDisplayName(displayInfo.getElementType());
        }

        public String getHtmlDisplayName() {
            return QueryUtilities.getTextForSchemaComponent((Component)this.sc);
        }

        public Action[] getActions(boolean bl) {
            return ACTIONS;
        }

        public Action getPreferredAction() {
            return SystemAction.get(ShowSourceAction.class);
        }
    }
}

