/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.api.WhereUsedQueryConstants;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query;
    private WhereUsedPanel panel;
    private final CsmObject origObject;
    private final String name;

    public WhereUsedQueryUI(CsmObject csmObject) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)csmObject));
        this.origObject = csmObject;
        this.name = this.getSearchElementName(this.origObject);
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.origObject, changeListener);
        }
        return this.panel;
    }

    public Problem setParameters() {
        assert (this.panel != null);
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        boolean bl = this.panel.getScope() == WhereUsedPanel.Scope.ALL;
        Collection<CsmProject> collection = CsmRefactoringUtils.getRelatedCsmProjects(this.origObject, bl);
        CsmProject[] csmProjectArray = collection.toArray(new CsmProject[collection.size()]);
        this.query.getContext().add((Object)csmProjectArray);
        CsmObject csmObject = this.panel.getReferencedObject();
        if (csmObject == null) {
            this.query.setRefactoringSource(Lookup.EMPTY);
        } else {
            this.query.setRefactoringSource(Lookups.singleton(CsmRefactoringUtils.getHandler(csmObject)));
        }
        if (this.panel.isVirtualMethod()) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.panel.isClass()) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        assert (this.panel != null);
        if (this.panel.isMethodFromBaseClass()) {
            CsmMethod csmMethod = this.panel.getBaseMethod();
            if (csmMethod == null) {
                this.query.setRefactoringSource(Lookup.EMPTY);
            } else {
                this.query.setRefactoringSource(Lookups.singleton(CsmRefactoringUtils.getHandler(csmMethod)));
            }
        } else {
            CsmObject csmObject = this.panel.getReferencedObject();
            if (csmObject == null) {
                this.query.setRefactoringSource(Lookup.EMPTY);
            } else {
                this.query.setRefactoringSource(Lookups.singleton(CsmRefactoringUtils.getHandler(csmObject)));
            }
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, (Object)this.panel.isMethodFromBaseClass());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        assert (this.panel != null);
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        assert (this.panel != null);
        if (this.panel.isVirtualMethod()) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.panel.isClass()) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query;
    }

    public String getDescription() {
        if (this.panel != null) {
            String string = this.panel.getDescription();
            String string2 = "DSC_WhereUsed";
            if (this.panel.isClass()) {
                if (!this.panel.isClassFindUsages()) {
                    string2 = this.panel.isClassSubTypesDirectOnly() ? "DSC_WhereUsedFindDirectSubTypes" : "DSC_WhereUsedFindAllSubTypes";
                }
            } else if (this.panel.isVirtualMethod()) {
                if (this.panel.isMethodFromBaseClass()) {
                    string = this.panel.getBaseMethodDescription();
                }
                if (this.panel.isMethodOverriders()) {
                    string2 = this.panel.isMethodFindUsages() ? "DSC_WhereUsedUsagesAndMethodOverriders" : "DSC_WhereUsedMethodOverriders";
                }
            }
            string = string.replace("<html>", "").replace("</html>", "");
            return this.getString(string2, string);
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String string, String string2) {
        return NbBundle.getMessage(WhereUsedQueryUI.class, (String)string, (Object)string2);
    }

    public String getName() {
        return this.getString("LBL_UsagesOf", this.name);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }

    private String getSearchElementName(CsmObject csmObject) {
        assert (csmObject != null);
        String string = csmObject instanceof CsmReference ? ((Object)((CsmReference)csmObject).getText()).toString() : (CsmKindUtilities.isNamedElement((CsmObject)csmObject) ? ((Object)((CsmNamedElement)csmObject).getName()).toString() : (csmObject != null ? "<UNNAMED ELEMENT>" : "<UNRESOLVED ELEMENT>"));
        return string;
    }
}

