/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkBasedNodeVisitor;

public class TimeCollector
extends MarkBasedNodeVisitor {
    private Map timing = new HashMap();

    public synchronized long getNetTime0(Mark mark) {
        if (this.isReset()) {
            return 0L;
        }
        TimingData timingData = (TimingData)this.timing.get(mark);
        long l = timingData != null ? (long)TimingAdjusterOld.getDefault().adjustTime(timingData.netTime0, timingData.inCalls, timingData.outCalls, false) : 0L;
        return l > 0L ? l : 0L;
    }

    public synchronized long getNetTime1(Mark mark) {
        if (this.isReset()) {
            return 0L;
        }
        TimingData timingData = (TimingData)this.timing.get(mark);
        long l = timingData != null ? (long)TimingAdjusterOld.getDefault().adjustTime(timingData.netTime1, timingData.inCalls, timingData.outCalls, true) : 0L;
        return l > 0L ? l : 0L;
    }

    public void beforeWalk() {
        super.beforeWalk();
        this.timing.clear();
    }

    public void endTrans() {
        if (this.isReset()) {
            this.timing = new HashMap();
        }
        super.endTrans();
    }

    public void visit(MethodCPUCCTNode methodCPUCCTNode) {
        TimingData timingData;
        if (this.isReset()) {
            return;
        }
        Mark mark = this.getCurrentMark();
        Mark mark2 = this.getParentMark();
        if (mark != null) {
            timingData = (TimingData)this.timing.get(mark);
            if (timingData == null) {
                timingData = new TimingData();
                this.timing.put(mark, timingData);
            }
            timingData.inCalls += methodCPUCCTNode.getNCalls();
            timingData.netTime0 += methodCPUCCTNode.getNetTime0();
            timingData.netTime1 += methodCPUCCTNode.getNetTime1();
        }
        if (mark2 != null) {
            timingData = (TimingData)this.timing.get(mark2);
            if (timingData == null) {
                timingData = new TimingData();
                this.timing.put(mark2, timingData);
            }
            timingData.outCalls += methodCPUCCTNode.getNCalls();
        }
    }

    private static class TimingData {
        int inCalls;
        int outCalls;
        long netTime0;
        long netTime1;

        private TimingData() {
        }
    }
}

