/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import org.netbeans.lib.profiler.utils.IntSorter;
import org.netbeans.lib.profiler.utils.LongSorter;
import org.netbeans.lib.profiler.utils.StringSorter;

public abstract class FlatProfileContainer {
    public static final int SORT_BY_NAME = 1;
    public static final int SORT_BY_TIME = 2;
    public static final int SORT_BY_SECONDARY_TIME = 3;
    public static final int SORT_BY_INV_NUMBER = 4;
    protected static boolean staticUsePrimaryTime;
    protected int[] methodIds;
    protected final char[] methodMarks;
    protected int[] nInvocations;
    protected float[] percent;
    protected long[] timeInMcs0;
    protected long[] timeInMcs1;
    protected boolean collectingTwoTimeStamps;
    protected long nTotalInvocations;
    private int nRows;
    private int totalMethods;

    public FlatProfileContainer(long[] lArray, long[] lArray2, int[] nArray, char[] cArray, int n) {
        this.timeInMcs0 = lArray;
        this.timeInMcs1 = lArray2;
        this.nInvocations = nArray;
        this.methodMarks = cArray;
        this.totalMethods = n;
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public int getMethodIdAtRow(int n) {
        return this.methodIds[n];
    }

    public abstract String getMethodNameAtRow(int var1);

    public int getNInvocationsAtRow(int n) {
        return this.nInvocations[n];
    }

    public int getNRows() {
        return this.nRows;
    }

    public long getNTotalInvocations() {
        return this.nTotalInvocations;
    }

    public float getPercentAtRow(int n) {
        return this.percent[n];
    }

    public long getTimeInMcs0AtRow(int n) {
        return this.timeInMcs0[n];
    }

    public long getTimeInMcs1AtRow(int n) {
        return this.timeInMcs1[n];
    }

    public abstract double getWholeGraphNetTime0();

    public abstract double getWholeGraphNetTime1();

    public void filterOriginalData(String[] stringArray, int n, double d) {
        if ((n == 0 || stringArray == null || stringArray[0].equals("")) && d == 0.0) {
            this.nRows = this.totalMethods;
            return;
        }
        this.nRows = this.totalMethods;
        for (int i = 0; i < this.nRows; ++i) {
            int n2;
            if (this.passedFilters(this.getMethodNameAtRow(i), stringArray, n) || i >= (n2 = --this.nRows)) continue;
            int n3 = this.methodIds[i];
            this.methodIds[i] = this.methodIds[n2];
            this.methodIds[n2] = n3;
            long l = this.timeInMcs0[i];
            this.timeInMcs0[i] = this.timeInMcs0[n2];
            this.timeInMcs0[n2] = l;
            if (this.collectingTwoTimeStamps) {
                l = this.timeInMcs1[i];
                this.timeInMcs1[i] = this.timeInMcs1[n2];
                this.timeInMcs1[n2] = l;
            }
            n3 = this.nInvocations[i];
            this.nInvocations[i] = this.nInvocations[n2];
            this.nInvocations[n2] = n3;
            --i;
        }
    }

    public void sortBy(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.sortDataByMethodName(bl);
                break;
            }
            case 2: {
                this.sortDataByTime(true, bl);
                break;
            }
            case 3: {
                this.sortDataByTime(false, bl);
                break;
            }
            case 4: {
                this.sortDataByInvNumber(bl);
            }
        }
    }

    protected void removeZeroInvocationEntries() {
        this.nRows = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (this.nInvocations[i] <= 0) continue;
            ++this.nRows;
        }
        long[] lArray = this.timeInMcs0;
        long[] lArray2 = this.timeInMcs1;
        int[] nArray = this.nInvocations;
        this.timeInMcs0 = new long[this.nRows];
        if (this.collectingTwoTimeStamps) {
            this.timeInMcs1 = new long[this.nRows];
        }
        this.nInvocations = new int[this.nRows];
        this.methodIds = new int[this.nRows];
        int n = 0;
        for (int i = 1; i < this.totalMethods; ++i) {
            if (nArray[i] <= 0) continue;
            long l = lArray[i];
            if (l < 0L) {
                l = 0L;
            }
            this.timeInMcs0[n] = l;
            if (this.collectingTwoTimeStamps) {
                l = lArray2[i];
                if (l < 0L) {
                    l = 0L;
                }
                this.timeInMcs1[n] = l;
            }
            this.nInvocations[n] = nArray[i];
            this.nTotalInvocations += (long)nArray[i];
            this.methodIds[n] = i;
            ++n;
        }
        this.totalMethods = this.nRows;
    }

    private void calculatePercent(boolean bl) {
        this.percent = new float[this.nRows];
        double d = this.getWholeGraphNetTime0();
        long[] lArray = this.timeInMcs0;
        if (this.collectingTwoTimeStamps && !bl) {
            d = this.getWholeGraphNetTime1();
            lArray = this.timeInMcs1;
        }
        for (int i = 0; i < this.nRows; ++i) {
            this.percent[i] = (float)(d > 0.0 ? (double)lArray[i] / d * 100.0 : 0.0);
        }
        staticUsePrimaryTime = bl;
    }

    private boolean passedFilter(String string, String string2, int n) {
        switch (n) {
            case 10: {
                return string.regionMatches(true, 0, string2, 0, string2.length());
            }
            case 20: {
                return string.toLowerCase().indexOf(string2.toLowerCase()) != -1;
            }
            case 30: {
                return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
            }
            case 40: {
                return string.equalsIgnoreCase(string2);
            }
            case 50: {
                return string.matches(string2);
            }
        }
        return false;
    }

    private boolean passedFilters(String string, String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.passedFilter(string, stringArray[i], n)) continue;
            return true;
        }
        return false;
    }

    private void sortDataByInvNumber(boolean bl) {
        if (this.percent == null || this.percent.length != this.nRows) {
            this.calculatePercent(staticUsePrimaryTime);
        }
        new IntSorter(this.nInvocations, 0, this.nRows){

            protected void swap(int n, int n2) {
                super.swap(n, n2);
                long l = FlatProfileContainer.this.timeInMcs0[n];
                FlatProfileContainer.this.timeInMcs0[n] = FlatProfileContainer.this.timeInMcs0[n2];
                FlatProfileContainer.this.timeInMcs0[n2] = l;
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    l = FlatProfileContainer.this.timeInMcs1[n];
                    FlatProfileContainer.this.timeInMcs1[n] = FlatProfileContainer.this.timeInMcs1[n2];
                    FlatProfileContainer.this.timeInMcs1[n2] = l;
                }
                int n3 = FlatProfileContainer.this.methodIds[n];
                FlatProfileContainer.this.methodIds[n] = FlatProfileContainer.this.methodIds[n2];
                FlatProfileContainer.this.methodIds[n2] = n3;
                if (FlatProfileContainer.this.percent != null) {
                    float f = FlatProfileContainer.this.percent[n];
                    FlatProfileContainer.this.percent[n] = FlatProfileContainer.this.percent[n2];
                    FlatProfileContainer.this.percent[n2] = f;
                }
            }
        }.sort(bl);
    }

    private void sortDataByMethodName(boolean bl) {
        String[] stringArray = new String[this.nRows];
        if (this.percent == null || this.percent.length != this.nRows) {
            this.calculatePercent(staticUsePrimaryTime);
        }
        for (int i = 0; i < this.nRows; ++i) {
            stringArray[i] = this.getMethodNameAtRow(i);
        }
        new StringSorter(stringArray, 0, this.nRows){

            protected void swap(int n, int n2) {
                super.swap(n, n2);
                long l = FlatProfileContainer.this.timeInMcs0[n];
                FlatProfileContainer.this.timeInMcs0[n] = FlatProfileContainer.this.timeInMcs0[n2];
                FlatProfileContainer.this.timeInMcs0[n2] = l;
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    l = FlatProfileContainer.this.timeInMcs1[n];
                    FlatProfileContainer.this.timeInMcs1[n] = FlatProfileContainer.this.timeInMcs1[n2];
                    FlatProfileContainer.this.timeInMcs1[n2] = l;
                }
                int n3 = FlatProfileContainer.this.methodIds[n];
                FlatProfileContainer.this.methodIds[n] = FlatProfileContainer.this.methodIds[n2];
                FlatProfileContainer.this.methodIds[n2] = n3;
                n3 = FlatProfileContainer.this.nInvocations[n];
                FlatProfileContainer.this.nInvocations[n] = FlatProfileContainer.this.nInvocations[n2];
                FlatProfileContainer.this.nInvocations[n2] = n3;
                if (FlatProfileContainer.this.percent != null) {
                    float f = FlatProfileContainer.this.percent[n];
                    FlatProfileContainer.this.percent[n] = FlatProfileContainer.this.percent[n2];
                    FlatProfileContainer.this.percent[n2] = f;
                }
            }
        }.sort(bl);
    }

    private void sortDataByTime(boolean bl, boolean bl2) {
        int n;
        long[] lArray = null;
        long[] lArray2 = null;
        if (this.percent == null || bl != staticUsePrimaryTime || this.percent.length != this.nRows) {
            this.calculatePercent(bl);
        }
        if (this.collectingTwoTimeStamps) {
            if (bl) {
                lArray = this.timeInMcs0;
                lArray2 = this.timeInMcs1;
            } else {
                lArray = this.timeInMcs1;
                lArray2 = this.timeInMcs0;
            }
        } else {
            lArray = this.timeInMcs0;
        }
        final long[] lArray3 = lArray2;
        new LongSorter(lArray, 0, this.nRows){

            protected void swap(int n, int n2) {
                super.swap(n, n2);
                if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                    long l = lArray3[n];
                    lArray3[n] = lArray3[n2];
                    lArray3[n2] = l;
                }
                int n3 = FlatProfileContainer.this.methodIds[n];
                FlatProfileContainer.this.methodIds[n] = FlatProfileContainer.this.methodIds[n2];
                FlatProfileContainer.this.methodIds[n2] = n3;
                n3 = FlatProfileContainer.this.nInvocations[n];
                FlatProfileContainer.this.nInvocations[n] = FlatProfileContainer.this.nInvocations[n2];
                FlatProfileContainer.this.nInvocations[n2] = n3;
                if (FlatProfileContainer.this.percent != null) {
                    float f = FlatProfileContainer.this.percent[n];
                    FlatProfileContainer.this.percent[n] = FlatProfileContainer.this.percent[n2];
                    FlatProfileContainer.this.percent[n2] = f;
                }
            }
        }.sort(bl2);
        for (n = this.nRows - 1; n >= 0 && lArray[n] == 0L; --n) {
        }
        if (n < this.nRows - 1) {
            new IntSorter(this.nInvocations, n + 1, this.nRows - n - 1){

                protected void swap(int n, int n2) {
                    super.swap(n, n2);
                    if (FlatProfileContainer.this.collectingTwoTimeStamps) {
                        long l = lArray3[n];
                        lArray3[n] = lArray3[n2];
                        lArray3[n2] = l;
                    }
                    int n3 = FlatProfileContainer.this.methodIds[n];
                    FlatProfileContainer.this.methodIds[n] = FlatProfileContainer.this.methodIds[n2];
                    FlatProfileContainer.this.methodIds[n2] = n3;
                }
            }.sort(bl2);
        }
    }
}

