/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.List;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayLazyList;

class PrimitiveArrayDump
extends ArrayDump
implements PrimitiveArrayInstance {
    private static final int charSize = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    PrimitiveArrayDump(ClassDump classDump, long l) {
        super(classDump, l);
    }

    public int getSize() {
        int n = this.dumpClass.getHprof().getValueSize(this.getType());
        return this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD + n * this.getLength();
    }

    public List getValues() {
        HprofByteBuffer hprofByteBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap hprofHeap = this.dumpClass.getHprof();
        byte by = this.getType();
        long l = this.getArrayStartOffset();
        return new PrimitiveArrayLazyList(hprofByteBuffer, this.getLength(), l, hprofHeap.getValueSize(by), by);
    }

    char[] getChars(int n, int n2) {
        if (!$assertionsDisabled && this.getType() != 5) {
            throw new AssertionError();
        }
        char[] cArray = new char[n2];
        long l = this.getArrayStartOffset() + (long)(n * 2);
        HprofByteBuffer hprofByteBuffer = this.dumpClass.getHprofBuffer();
        for (int i = 0; i < n2; ++i) {
            cArray[i] = hprofByteBuffer.getChar(l + (long)(i * 2));
        }
        return cArray;
    }

    private long getArrayStartOffset() {
        int n = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)n + 4L + 4L + 1L;
    }

    private byte getType() {
        HprofByteBuffer hprofByteBuffer = this.dumpClass.getHprofBuffer();
        int n = hprofByteBuffer.getIDSize();
        return hprofByteBuffer.get(this.fileOffset + 1L + (long)n + 4L + 4L);
    }

    static {
        $assertionsDisabled = !PrimitiveArrayDump.class.desiredAssertionStatus();
    }
}

