/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.heap.HprofFileBuffer;
import org.netbeans.lib.profiler.heap.HprofLongMappedByteBuffer;
import org.netbeans.lib.profiler.heap.HprofMappedByteBuffer;

abstract class HprofByteBuffer {
    static final String magic1 = "JAVA PROFILE 1.0.1";
    static final String magic2 = "JAVA PROFILE 1.0.2";
    static final int JAVA_PROFILE_1_0_1 = 1;
    static final int JAVA_PROFILE_1_0_2 = 2;
    static final int MINIMAL_SIZE = 30;
    static final boolean DEBUG = false;
    int idSize;
    int version;
    long headerSize;
    long length;
    long time;
    static final /* synthetic */ boolean $assertionsDisabled;

    HprofByteBuffer() {
    }

    static HprofByteBuffer createHprofByteBuffer(File file) throws IOException {
        long l = file.length();
        if (l < 30L) {
            String string = ResourceBundle.getBundle("org/netbeans/lib/profiler/heap/Bundle").getString("HprofByteBuffer_ShortFile");
            throw new IOException(string);
        }
        try {
            if (l < Integer.MAX_VALUE) {
                return new HprofMappedByteBuffer(file);
            }
            return new HprofLongMappedByteBuffer(file);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof OutOfMemoryError) {
                return new HprofFileBuffer(file);
            }
            throw iOException;
        }
    }

    abstract char getChar(long var1);

    abstract double getDouble(long var1);

    abstract float getFloat(long var1);

    long getHeaderSize() {
        return this.headerSize;
    }

    long getID(long l) {
        if (this.idSize == 4) {
            return this.getInt(l);
        }
        if (this.idSize == 8) {
            return this.getLong(l);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return -1L;
    }

    int getIDSize() {
        return this.idSize;
    }

    int getFoffsetSize() {
        return this.length < Integer.MAX_VALUE ? 4 : 8;
    }

    abstract int getInt(long var1);

    abstract long getLong(long var1);

    abstract short getShort(long var1);

    long getTime() {
        return this.time;
    }

    long capacity() {
        return this.length;
    }

    abstract byte get(long var1);

    abstract void get(long var1, byte[] var3);

    void readHeader() throws IOException {
        long[] lArray = new long[1];
        String string = this.readStringNull(lArray, 30);
        if (magic1.equals(string)) {
            this.version = 1;
        } else if (magic2.equals(string)) {
            this.version = 2;
        } else {
            String string2 = ResourceBundle.getBundle("org/netbeans/lib/profiler/heap/Bundle").getString("HprofByteBuffer_InvalidFormat");
            throw new IOException(string2);
        }
        this.idSize = this.getInt(lArray[0]);
        lArray[0] = lArray[0] + 4L;
        this.time = this.getLong(lArray[0]);
        lArray[0] = lArray[0] + 8L;
        this.headerSize = lArray[0];
    }

    private String readStringNull(long[] lArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        long l = lArray[0];
        lArray[0] = l + 1L;
        byte by = this.get(l);
        while (by > 0 && stringBuffer.length() < n) {
            stringBuffer.append((char)by);
            long l2 = lArray[0];
            lArray[0] = l2 + 1L;
            by = this.get(l2);
        }
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !HprofByteBuffer.class.desiredAssertionStatus();
    }
}

