/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.global;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;

public class CalibrationDataFileIO {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.global.Bundle");
    private static final String CALIBRATION_FILE_NOT_EXIST_MSG = messages.getString("CalibrationDataFileIO_CalibrationFileNotExistMsg");
    private static final String CALIBRATION_FILE_NOT_READABLE_MSG = messages.getString("CalibrationDataFileIO_CalibrationFileNotReadableMsg");
    private static final String CALIBRATION_DATA_CORRUPTED_PREFIX = messages.getString("CalibrationDataFileIO_CalibrationDataCorruptedPrefix");
    private static final String SHORTER_THAN_EXPECTED_STRING = messages.getString("CalibrationDataFileIO_ShorterThanExpectedString");
    private static final String ORIGINAL_MESSAGE_STRING = messages.getString("CalibrationDataFileIO_OriginalMessageString");
    private static final String RERUN_CALIBRATION_MSG = messages.getString("CalibrationDataFileIO_ReRunCalibrationMsg");
    private static final String ERROR_WRITING_CALIBRATION_FILE_PREFIX = messages.getString("CalibrationDataFileIO_ErrorWritingCalibrationFilePrefix");
    private static final String REEXECUTE_CALIBRATION_MSG = messages.getString("CalibrationDataFileIO_ReExecuteCalibrationMsg");
    private static String errorMessage;

    public static String getErrorMessage() {
        String string = errorMessage;
        errorMessage = null;
        return string;
    }

    public static int readSavedCalibrationData(ProfilingSessionStatus profilingSessionStatus) {
        String string = null;
        try {
            string = CalibrationDataFileIO.getCalibrationDataFileName(profilingSessionStatus.targetJDKVersionString);
        }
        catch (IOException iOException) {
            errorMessage = iOException.getMessage();
            return -1;
        }
        File file = new File(string);
        if (!file.exists()) {
            errorMessage = CALIBRATION_FILE_NOT_EXIST_MSG;
            return 1;
        }
        if (!file.canRead()) {
            errorMessage = MessageFormat.format(CALIBRATION_FILE_NOT_READABLE_MSG, file.toString());
            return -1;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            profilingSessionStatus.methodEntryExitCallTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.methodEntryExitInnerTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.methodEntryExitOuterTime = (double[])objectInputStream.readObject();
            profilingSessionStatus.timerCountsInSecond = (long[])objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            String string3 = CALIBRATION_DATA_CORRUPTED_PREFIX;
            if (string2 == null) {
                if (exception instanceof EOFException) {
                    string2 = string3 + " " + SHORTER_THAN_EXPECTED_STRING;
                }
            } else {
                string2 = string3 + "\n" + ORIGINAL_MESSAGE_STRING + " " + string2;
            }
            string2 = string2 + "\n" + RERUN_CALIBRATION_MSG + "\n";
            return -2;
        }
        return 0;
    }

    public static boolean saveCalibrationData(ProfilingSessionStatus profilingSessionStatus) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(CalibrationDataFileIO.getCalibrationDataFileName(profilingSessionStatus.targetJDKVersionString));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitCallTime);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitInnerTime);
            objectOutputStream.writeObject(profilingSessionStatus.methodEntryExitOuterTime);
            objectOutputStream.writeObject(profilingSessionStatus.timerCountsInSecond);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            String string2 = ERROR_WRITING_CALIBRATION_FILE_PREFIX;
            string = string2 + "\n" + ORIGINAL_MESSAGE_STRING + "\n" + string;
            if (!profilingSessionStatus.remoteProfiling) {
                string = string + "\n" + REEXECUTE_CALIBRATION_MSG + "\n";
            }
            return false;
        }
        return true;
    }

    public static boolean validateCalibrationInput(String string, String string2) {
        return string != null && string2 != null && ("jdk15".equals(string) || "jdk16".equals(string) || "jdk17".equals(string)) && new File(string2).exists();
    }

    private static String getCalibrationDataFileName(String string) throws IOException {
        String string2 = "machinedata." + string;
        return Platform.getProfilerUserDir() + File.separator + string2;
    }
}

