/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.client;

import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassRepository;

public class RuntimeProfilingPoint {
    private final String className;
    private final String methodName;
    private final String methodSignature;
    private final String serverHandlerClass;
    private final String serverInfo;
    private final int id;
    private final int line;
    private final int offset;
    private int bci;
    private int methodIdx = -1;

    public RuntimeProfilingPoint(int n, String string, int n2, int n3, String string2, String string3) {
        this(n, string, n2, n3, null, null, string2, string3);
    }

    public RuntimeProfilingPoint(int n, String string, String string2, String string3, String string4, String string5) {
        this(n, string, -1, -1, string2, string3, string4, string5);
    }

    private RuntimeProfilingPoint(int n, String string, int n2, int n3, String string2, String string3, String string4, String string5) {
        this.id = n;
        this.className = string;
        this.line = n2;
        this.offset = n3;
        this.methodName = string2;
        this.methodSignature = string3;
        this.serverHandlerClass = string4;
        this.serverInfo = string5;
    }

    public int getBci() {
        return this.bci;
    }

    public String getClassName() {
        return this.className;
    }

    public int getId() {
        return this.id;
    }

    public int getMethodIdx() {
        return this.methodIdx;
    }

    public String getServerHandlerClass() {
        return this.serverHandlerClass;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public boolean resolve(ClassInfo classInfo) {
        if (this.methodIdx != -1) {
            return true;
        }
        return this.methodName != null ? this.resolveMethodName(classInfo) : this.resolveLineNumber(classInfo);
    }

    public String toString() {
        return "RuntimeProfilingPoint [id=" + this.id + ", classname=" + this.className + ", line=" + this.line + ", offset=" + this.offset + ", server handler=" + this.serverHandlerClass + "]";
    }

    private boolean resolveLineNumber(ClassInfo classInfo) {
        try {
            ClassRepository.CodeRegionBCI codeRegionBCI = ClassRepository.getMethodForSourceRegion(classInfo, this.line, this.line);
            this.methodIdx = classInfo.getMethodIndex(codeRegionBCI.methodName, codeRegionBCI.methodSignature);
            this.bci = this.offset == Integer.MAX_VALUE ? codeRegionBCI.bci1 : codeRegionBCI.bci0;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean resolveMethodName(ClassInfo classInfo) {
        if (this.methodSignature != null) {
            this.methodIdx = classInfo.getMethodIndex(this.methodName, this.methodSignature);
        } else {
            String[] stringArray = classInfo.getMethodNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.methodName.equals(stringArray[i])) continue;
                this.methodIdx = i;
                break;
            }
        }
        if (this.methodIdx == -1) {
            return false;
        }
        this.bci = classInfo.getLineNumberTables().getStartPCs()[this.methodIdx][0];
        return true;
    }

    public static class HitEvent {
        private final int id;
        private final int threadId;
        private final long timestamp;

        public HitEvent(int n, long l, int n2) {
            this.id = n;
            this.timestamp = l;
            this.threadId = n2;
        }

        public int getId() {
            return this.id;
        }

        public int getThreadId() {
            return this.threadId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            return "HitEvent [id=" + this.getId() + ", thread id=" + this.getThreadId() + ", timestamp=" + this.getTimestamp() + "]";
        }
    }
}

