/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.InstrumentationException;
import org.netbeans.lib.profiler.instrumentation.Instrumentor;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.EventBufferResultsProvider;
import org.netbeans.lib.profiler.results.ProfilingResultsDispatcher;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.TimeCollector;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.JMethodIdTable;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.wireprotocol.CalibrationDataResponse;
import org.netbeans.lib.profiler.wireprotocol.CodeRegionCPUResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.DefiningLoaderResponse;
import org.netbeans.lib.profiler.wireprotocol.DumpResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.EventBufferDumpedCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdCommand;
import org.netbeans.lib.profiler.wireprotocol.GetClassIdResponse;
import org.netbeans.lib.profiler.wireprotocol.GetDefiningClassLoaderCommand;
import org.netbeans.lib.profiler.wireprotocol.GetMethodNamesForJMethodIdsCommand;
import org.netbeans.lib.profiler.wireprotocol.InitiateInstrumentationCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodNamesResponse;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;
import org.netbeans.lib.profiler.wireprotocol.ObjectAllocationResultsResponse;
import org.netbeans.lib.profiler.wireprotocol.Response;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.SetChangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.SetUnchangeableInstrParamsCommand;
import org.netbeans.lib.profiler.wireprotocol.TakeHeapDumpCommand;
import org.netbeans.lib.profiler.wireprotocol.ThreadLivenessStatusResponse;
import org.netbeans.lib.profiler.wireprotocol.VMPropertiesResponse;
import org.netbeans.lib.profiler.wireprotocol.WireIO;

public class ProfilerClient
implements CommonConstants {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.Bundle");
    private static final String CANNOT_OPEN_SERVER_TEMPFILE_MSG = messages.getString("ProfilerClient_CannotOpenServerTempFileMsg");
    private static final String PERFORMING_INSTRUMENTATION_STRING = messages.getString("ProfilerClient_PerformingInstrumentationString");
    private static final String INVALID_CODE_REGION_MSG = messages.getString("ProfilerClient_InvalidCodeRegionMsg");
    private static final String CLASS_NOT_FOUND_MSG = messages.getString("ProfilerClient_ClassNotFoundMsg");
    private static final String OUT_OF_MEMORY_MSG = messages.getString("ProfilerClient_OutOfMemoryMsg");
    private static final String INCORRECT_AGENT_VERSION_MSG = messages.getString("ProfilerClient_IncorrectAgentVersionMsg");
    private static final String ERROR_GETTING_CALIBRATION_DATA_MSG = messages.getString("ProfilerClient_ErrorGettingCalibrationDataMsg");
    private static final String MUST_CALIBRATE_FIRST_MSG = messages.getString("ProfilerClient_MustCalibrateFirstMsg");
    private static final String MUST_CALIBRATE_FIRST_SHORT_MSG = messages.getString("ProfilerClient_MustCalibrateFirstShortMsg");
    private static final String INSTRUMENTATION_LIMIT_REACHED_MSG = messages.getString("ProfilerClient_InstrumentationLimitReachedMsg");
    private static final String CORRUPTED_TARGET_CALIBRATION_DATA_MSG = messages.getString("ProfilerClient_CorruptedTargetCalibrationDataMsg");
    private static final String CONNECT_VM_MSG = messages.getString("ProfilerClient_ConnectVmMsg");
    private static final String TARGET_JVM_ERROR_MSG = messages.getString("ProfilerClient_TargetJvmErrorMsg");
    private static final String UNSUPPORTED_JVM_MSG = messages.getString("ProfilerClient_UnsupportedJvmMsg");
    private static final String a = "AAQ";
    private AppStatusHandler.ServerCommandHandler serverCommandHandler;
    private AppStatusHandler appStatusHandler;
    private CCTResultsFilter markFilter;
    private CPUCCTProvider cpuCctProvider;
    private Command execInSeparateThreadCmd;
    private FlatProfileProvider flatProvider;
    private InitiateInstrumentationCommand commandOnStartup = null;
    private Instrumentor instrumentor;
    private MemoryCCTProvider memCctProvider;
    private Object execInSeparateThreadLock = new Object();
    private Object forceObtainedResultsDumpLock = new Object();
    private Object instrumentationLock = new Object();
    private Object responseLock = new Object();
    private Object wdLock = new Object();
    private ObjectInputStream socketIn;
    private ObjectOutputStream socketOut;
    private ProfilerEngineSettings settings;
    private ProfilingSessionStatus status;
    private Response lastResponse;
    private SeparateCmdExecutionThread separateCmdExecThread;
    private ServerListener serverListener;
    private Socket clientSocket;
    private TimeCollector timeCollector;
    private WireIO wireIO;
    private int[] savedAllocatedObjectsCountResults;
    private volatile boolean connectionWithServerOpen;
    private volatile boolean forceObtainedResultsDumpCalled;
    private volatile boolean handlingEventBufferDump;
    private volatile boolean instrMethodsLimitReported;
    private boolean serverClassesInitialized;
    private boolean shouldDisplayDialog = true;
    private volatile boolean targetVMAlive;
    private volatile boolean terminateOrDetachCommandIssued;
    private int currentAgentId = -1;
    private long instrProcessingTime;
    private long resultsStart;

    public ProfilerClient(ProfilerEngineSettings profilerEngineSettings, ProfilingSessionStatus profilingSessionStatus, AppStatusHandler appStatusHandler, AppStatusHandler.ServerCommandHandler serverCommandHandler) {
        this.settings = profilerEngineSettings;
        this.status = profilingSessionStatus;
        this.appStatusHandler = appStatusHandler;
        this.serverCommandHandler = serverCommandHandler;
        this.instrumentor = new Instrumentor(profilingSessionStatus, profilerEngineSettings);
        if (this.separateCmdExecThread == null) {
            this.separateCmdExecThread = new SeparateCmdExecutionThread();
            this.separateCmdExecThread.setDaemon(true);
            this.separateCmdExecThread.start();
        }
        EventBufferProcessor.initialize(this);
        EventBufferResultsProvider.getDefault().addDispatcher(ProfilingResultsDispatcher.getDefault());
    }

    public synchronized int[] getAllocatedObjectsCountResults() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            if (this.savedAllocatedObjectsCountResults != null) {
                return this.savedAllocatedObjectsCountResults;
            }
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.savedAllocatedObjectsCountResults = null;
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(30);
        ObjectAllocationResultsResponse objectAllocationResultsResponse = (ObjectAllocationResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get allocated object count results.");
        return objectAllocationResultsResponse.getResults();
    }

    public synchronized CPUResultsSnapshot getCPUProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        return this.getCPUProfilingResultsSnapshot(true);
    }

    public synchronized CPUResultsSnapshot getCPUProfilingResultsSnapshot(boolean bl) throws ClientUtils.TargetAppOrVMTerminated, CPUResultsSnapshot.NoDataAvailableException {
        this.checkForTargetVMAlive();
        if (bl && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        return new CPUResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.cpuCctProvider, this.status);
    }

    public synchronized CodeRegionResultsSnapshot getCodeRegionProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(8);
        CodeRegionCPUResultsResponse codeRegionCPUResultsResponse = (CodeRegionCPUResultsResponse)this.getAndCheckLastResponse("Unknown problem when trying to get code region CPU results.");
        return new CodeRegionResultsSnapshot(this.resultsStart, System.currentTimeMillis(), codeRegionCPUResultsResponse.getResults(), this.status.timerCountsInSecond[0]);
    }

    public int getCurrentAgentId() {
        return this.currentAgentId;
    }

    public void setCurrentInstrType(int n) {
        this.status.currentInstrType = n;
    }

    public int getCurrentInstrType() {
        return this.status.currentInstrType;
    }

    public synchronized byte[] getCurrentThreadsLivenessStatus() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(16);
            ThreadLivenessStatusResponse threadLivenessStatusResponse = (ThreadLivenessStatusResponse)this.getAndCheckLastResponse("Unknown problem when trying to get thread liveness information.");
            return threadLivenessStatusResponse.getStatus();
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            if (this.serverListener.isRunning()) {
                MiscUtils.printErrorMessage("in getCurrentThreadLivenessStatus(), caught exception: " + targetAppOrVMTerminated);
            }
            return null;
        }
    }

    public synchronized int getDefiningClassLoaderId(String string, int n) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetDefiningClassLoaderCommand getDefiningClassLoaderCommand = new GetDefiningClassLoaderCommand(string, n);
        this.sendComplexCmdToServer(getDefiningClassLoaderCommand);
        DefiningLoaderResponse definingLoaderResponse = (DefiningLoaderResponse)this.getAndCheckLastResponse("Unknown problem when trying to get a defining loader for class");
        return definingLoaderResponse.getLoaderId();
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.flatProvider;
    }

    public long getInstrProcessingTime() {
        return this.instrProcessingTime;
    }

    public synchronized InternalStatsResponse getInternalStats() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(24);
        InternalStatsResponse internalStatsResponse = (InternalStatsResponse)this.getLastResponse();
        return internalStatsResponse;
    }

    public CCTResultsFilter getMarkFilter() {
        return this.markFilter;
    }

    public MemoryCCTProvider getMemoryCCTProvider() {
        return this.memCctProvider;
    }

    public synchronized MemoryResultsSnapshot getMemoryProfilingResultsSnapshot() throws ClientUtils.TargetAppOrVMTerminated {
        return this.getMemoryProfilingResultsSnapshot(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MemoryResultsSnapshot getMemoryProfilingResultsSnapshot(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        if (bl && !this.forceObtainedResultsDump(false, 5)) {
            return null;
        }
        this.memCctProvider.beginTrans(false);
        try {
            this.memCctProvider.updateInternals();
            if (this.getCurrentInstrType() == 4) {
                AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = new AllocMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
                return allocMemoryResultsSnapshot;
            }
            LivenessMemoryResultsSnapshot livenessMemoryResultsSnapshot = new LivenessMemoryResultsSnapshot(this.resultsStart, System.currentTimeMillis(), this.memCctProvider, this);
            return livenessMemoryResultsSnapshot;
        }
        finally {
            this.memCctProvider.endTrans();
        }
    }

    public Marker getMethodMarker() {
        return this.settings.getMethodMarker();
    }

    public synchronized String[][] getMethodNamesForJMethodIds(int[] nArray) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        GetMethodNamesForJMethodIdsCommand getMethodNamesForJMethodIdsCommand = new GetMethodNamesForJMethodIdsCommand(nArray);
        this.sendComplexCmdToServer(getMethodNamesForJMethodIdsCommand);
        MethodNamesResponse methodNamesResponse = (MethodNamesResponse)this.getAndCheckLastResponse("Unknown problem when trying to get method names for jmethodIds");
        return StringUtils.convertPackedStringsIntoStringArrays(methodNamesResponse.getPackedData(), methodNamesResponse.getPackedArrayOffsets(), 3);
    }

    public synchronized MonitoredData getMonitoredData() {
        try {
            this.checkForTargetVMAlive();
            this.sendSimpleCmdToServer(32);
            Response response = this.getAndCheckLastResponse("Unknown problem when trying to get memory numbers.");
            try {
                MonitoredNumbersResponse monitoredNumbersResponse = (MonitoredNumbersResponse)response;
                return MonitoredData.getMonitoredData(monitoredNumbersResponse);
            }
            catch (ClassCastException classCastException) {
                MiscUtils.printErrorMessage("caught ClassCastException in getMonitoredNumbers. The real class of resp is " + response.getClass().getName() + ", resp = " + response);
                throw classCastException;
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            if (this.serverListener.isRunning()) {
                MiscUtils.printErrorMessage("in getMonitoredData(), caught exception: " + targetAppOrVMTerminated);
            }
            return null;
        }
    }

    public ProfilerEngineSettings getSettings() {
        return this.settings;
    }

    public ObjectInputStream getSocketInputStream() {
        return this.socketIn;
    }

    public ProfilingSessionStatus getStatus() {
        return this.status;
    }

    public TimeCollector getTimeCollector() {
        return this.timeCollector;
    }

    public synchronized boolean cpuResultsExist() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(6);
        Response response = this.getAndCheckLastResponse("Unknown problem when trying to check for CPU profiling results.");
        return response.yes();
    }

    public boolean currentInstrTypeIsMemoryProfiling() {
        return this.status.currentInstrType == 4 || this.status.currentInstrType == 5;
    }

    public boolean currentInstrTypeIsRecursiveCPUProfiling() {
        return this.status.currentInstrType == 2 || this.status.currentInstrType == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstrumentMemoryProfiledClasses(boolean[] blArray) throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            if (this.getCurrentInstrType() == 0) {
                return;
            }
            Response response = null;
            this.checkForTargetAppRunning();
            long l = System.currentTimeMillis();
            InstrumentMethodGroupCommand instrumentMethodGroupCommand = this.instrumentor.getCommandToUnprofileClasses(blArray);
            if (!instrumentMethodGroupCommand.isEmpty()) {
                ProfilerClient profilerClient = this;
                synchronized (profilerClient) {
                    this.sendComplexCmdToServer(instrumentMethodGroupCommand);
                    this.instrProcessingTime += System.currentTimeMillis() - l;
                    response = this.getLastResponse();
                }
                if (!response.isOK()) {
                    throw new InstrumentationException(response.getErrorMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void detachFromTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(25);
        try {
            this.getLastResponse();
        }
        finally {
            this.closeConnection();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    public boolean establishConnectionWithServer(int n, boolean bl) {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        return this.connectToServer(n, bl);
    }

    public boolean forceObtainedResultsDump() throws ClientUtils.TargetAppOrVMTerminated {
        return this.forceObtainedResultsDump(false, 0);
    }

    public boolean forceObtainedResultsDump(boolean bl, int n) throws ClientUtils.TargetAppOrVMTerminated {
        boolean bl2 = false;
        int n2 = n;
        do {
            if (bl2 = this.forceObtainedResultsDump(bl)) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        } while (!bl2 && --n2 > 0);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceObtainedResultsDump(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            Object object = this.forceObtainedResultsDumpLock;
            synchronized (object) {
                if (this.handlingEventBufferDump) {
                    return true;
                }
                this.checkForTargetVMAlive();
                this.forceObtainedResultsDumpCalled = true;
                this.sendSimpleCmdToServer(bl ? 40 : 27);
                DumpResultsResponse dumpResultsResponse = (DumpResultsResponse)this.getLastResponse();
                if (dumpResultsResponse.yes()) {
                    this.status.dumpAbsTimeStamp = dumpResultsResponse.getDumpAbsTimeStamp();
                } else if (ProfilerLogger.isDebug()) {
                    ProfilerLogger.debug("Force Obtained Results - Received Dump Error ");
                }
                this.forceObtainedResultsDumpCalled = false;
                return dumpResultsResponse.yes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateCodeRegionInstrumentation(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            InitiateInstrumentationCommand initiateInstrumentationCommand;
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(sourceCodeSelectionArray);
            this.instrumentor.setSavedSourceCodeSelection(sourceCodeSelectionArray);
            String string = this.instrumentor.getRootClassNames()[0].replace('/', '.');
            this.commandOnStartup = initiateInstrumentationCommand = new InitiateInstrumentationCommand(1, string, false, this.status.startProfilingPointsActive);
            this.setCurrentInstrType(1);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string2 = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string2 != null) {
                    this.appStatusHandler.displayWarning(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateMemoryProfInstrumentation(int n) throws ClientUtils.TargetAppOrVMTerminated, InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            this.removeAllInstrumentation();
            String string = this.settings.getMainClassName();
            InitiateInstrumentationCommand initiateInstrumentationCommand = new InitiateInstrumentationCommand(n, string, false, this.status.startProfilingPointsActive);
            initiateInstrumentationCommand.setProfilingPoints(this.settings.getRuntimeProfilingPoints());
            this.commandOnStartup = initiateInstrumentationCommand;
            this.setCurrentInstrType(n);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string2 = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string2 != null) {
                    this.appStatusHandler.displayWarning(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateRecursiveCPUProfInstrumentation(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, BadLocationException, InstrumentationException, IOException, ClassFormatError, ClientUtils.TargetAppOrVMTerminated {
        Object object = this.instrumentationLock;
        synchronized (object) {
            this.removeAllInstrumentation();
            if (this.status.targetAppRunning && this.status.remoteProfiling && !this.getCalibrationData(true)) {
                return;
            }
            this.instrumentor.setStatusInfoFromSourceCodeSelection(sourceCodeSelectionArray);
            boolean bl = this.settings.getInstrumentSpawnedThreads();
            String[] stringArray = this.instrumentor.getRootClassNames();
            int n = this.settings.getCPUProfilingType() == 0 ? 2 : 3;
            InitiateInstrumentationCommand initiateInstrumentationCommand = new InitiateInstrumentationCommand(n, stringArray, bl, this.status.startProfilingPointsActive);
            initiateInstrumentationCommand.setProfilingPoints(this.settings.getRuntimeProfilingPoints());
            this.commandOnStartup = initiateInstrumentationCommand;
            this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
            this.setCurrentInstrType(n);
            if (this.status.targetAppRunning) {
                this.sendSetInstrumentationParamsCmd(false);
                String string = this.sendCommandAndGetResponse(this.commandOnStartup);
                if (string != null) {
                    this.appStatusHandler.displayWarning(string);
                }
            }
        }
    }

    public synchronized boolean memoryResultsExist() {
        return this.getMemoryCCTProvider() != null && this.getMemoryCCTProvider().getStacksForClasses() != null;
    }

    public void registerCPUCCTProvider(CPUCCTProvider cPUCCTProvider) {
        this.cpuCctProvider = cPUCCTProvider;
    }

    public void registerFlatProfileProvider(FlatProfileProvider flatProfileProvider) {
        this.flatProvider = flatProfileProvider;
    }

    public void registerMarkFilter(CCTResultsFilter cCTResultsFilter) {
        this.markFilter = cCTResultsFilter;
    }

    public void registerMemoryCCTProvider(MemoryCCTProvider memoryCCTProvider) {
        this.memCctProvider = memoryCCTProvider;
    }

    public void registerTimeCollector(TimeCollector timeCollector) {
        this.timeCollector = timeCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllInstrumentation(boolean bl) throws InstrumentationException {
        Object object = this.instrumentationLock;
        synchronized (object) {
            if (this.getCurrentInstrType() == 0) {
                return;
            }
            this.commandOnStartup = null;
            if (bl) {
                this.status.resetInstrClassAndMethodInfo();
            }
            try {
                this.clearPreviousInstrumentationInServer();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            this.setCurrentInstrType(0);
        }
    }

    public void removeAllInstrumentation() throws InstrumentationException {
        this.removeAllInstrumentation(true);
    }

    public void resetClientData() {
        if (this.targetJVMIsAlive()) {
            return;
        }
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
    }

    public synchronized void resetProfilerCollectors() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(29);
        this.getAndCheckLastResponse("Unknown problem when trying to reset profiler collectors.");
    }

    public synchronized void resumeTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(11);
        this.getAndCheckLastResponse("Unknown problem when trying to resume app threads.");
    }

    public synchronized void runGC() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendSimpleCmdToServer(33);
        this.getAndCheckLastResponse("Unknown problem when trying to run GC");
    }

    public void sendSetInstrumentationParamsCmd(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        SetUnchangeableInstrParamsCommand setUnchangeableInstrParamsCommand;
        SetChangeableInstrParamsCommand setChangeableInstrParamsCommand = new SetChangeableInstrParamsCommand(this.settings.getNProfiledThreadsLimit(), this.settings.getSamplingInterval(), this.settings.getAllocTrackEvery(), this.settings.getAllocStackTraceLimit(), this.settings.getRunGCOnGetResultsInMemoryProfiling(), this.settings.getExcludeWaitTime(), this.settings.getExcludeWaitTime());
        String string = this.sendCommandAndGetResponse(setChangeableInstrParamsCommand);
        if (string != null) {
            this.appStatusHandler.displayWarning(string);
        }
        if (!bl && (string = this.sendCommandAndGetResponse(setUnchangeableInstrParamsCommand = new SetUnchangeableInstrParamsCommand(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn(), this.settings.getInstrScheme(), this.settings.getCodeRegionCPUResBufSize()))) != null) {
            this.appStatusHandler.displayWarning(string);
        }
    }

    public boolean startTargetApp(boolean bl) throws ClientUtils.TargetAppOrVMTerminated, ClientUtils.TargetAppFailedToStart {
        String string;
        this.status.resetInstrClassAndMethodInfo();
        this.instrumentor.resetPerVMInstanceData();
        this.status.setTimerTypes(this.settings.getAbsoluteTimerOn(), this.settings.getThreadCPUTimerOn());
        this.serverCommandHandler.handleServerCommand(null);
        this.checkForTargetVMAlive();
        this.instrProcessingTime = 0L;
        this.instrMethodsLimitReported = false;
        if (this.currentInstrTypeIsRecursiveCPUProfiling()) {
            this.setCurrentInstrType(this.settings.getCPUProfilingType() == 0 ? 2 : 3);
            if (this.commandOnStartup != null) {
                this.commandOnStartup.setInstrType(this.getCurrentInstrType());
            }
        }
        if (this.commandOnStartup != null) {
            this.sendSetInstrumentationParamsCmd(false);
            switch (this.getCurrentInstrType()) {
                case 1: {
                    if (!this.status.remoteProfiling || this.getCalibrationData(true)) break;
                    try {
                        this.terminateTargetJVM();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                        // empty catch block
                    }
                    return false;
                }
                case 2: 
                case 3: {
                    if (this.status.remoteProfiling && !this.getCalibrationData(true)) {
                        try {
                            this.terminateTargetJVM();
                        }
                        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                            // empty catch block
                        }
                        return false;
                    }
                    if (!this.settings.getInstrumentMethodInvoke() || (string = this.sendSimpleCommandAndGetResponse(20)) == null) break;
                    throw new ClientUtils.TargetAppFailedToStart(string);
                }
            }
            string = this.sendCommandAndGetResponse(this.commandOnStartup);
            if (string != null) {
                this.appStatusHandler.displayWarning("Profiler Agent Error: " + string);
            }
            this.commandOnStartup = null;
        } else {
            this.setCurrentInstrType(0);
        }
        if (bl && (string = this.sendSimpleCommandAndGetResponse(2)) != null) {
            throw new ClientUtils.TargetAppFailedToStart(string);
        }
        this.status.targetAppRunning = true;
        this.checkForInstrMethodsLimitReached();
        EventBufferResultsProvider.getDefault().startup(this);
        return true;
    }

    public synchronized void suspendTargetAppThreads() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetAppRunning();
        this.sendSimpleCmdToServer(10);
        this.getAndCheckLastResponse("Unknown problem when trying to suspend app threads.");
    }

    public synchronized boolean takeHeapDump(String string) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.sendComplexCmdToServer(new TakeHeapDumpCommand(string));
        Response response = this.getAndCheckLastResponse("takeHeapDump.");
        return response.isOK();
    }

    public boolean targetAppIsRunning() {
        return this.status.targetAppRunning;
    }

    public boolean targetJVMIsAlive() {
        return this.targetVMAlive;
    }

    public synchronized void terminateTargetJVM() throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.terminateOrDetachCommandIssued = true;
        this.sendSimpleCmdToServer(12);
        if (!this.getLastResponse().isOK()) {
            throw new ClientUtils.TargetAppOrVMTerminated(1, "Target JVM terminated or not responding");
        }
        this.closeConnection();
    }

    private synchronized Response getAndCheckLastResponse(String string) throws ClientUtils.TargetAppOrVMTerminated {
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in getAndCheckLastResponse: for " + response + " got error message: " + response.getErrorMessage() + " and context message " + string);
        }
        return response;
    }

    private synchronized boolean getCalibrationData(boolean bl) throws ClientUtils.TargetAppOrVMTerminated {
        int n = bl ? 37 : 34;
        this.sendSimpleCmdToServer(n);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            String string = response.getErrorMessage();
            if (bl) {
                string = MessageFormat.format(CORRUPTED_TARGET_CALIBRATION_DATA_MSG, string);
            }
            this.appStatusHandler.displayError(string);
            return false;
        }
        CalibrationDataResponse calibrationDataResponse = (CalibrationDataResponse)response;
        this.status.methodEntryExitCallTime = calibrationDataResponse.getMethodEntryExitCallTime();
        this.status.methodEntryExitInnerTime = calibrationDataResponse.getMethodEntryExitInnerTime();
        this.status.methodEntryExitOuterTime = calibrationDataResponse.getMethodEntryExitOuterTime();
        this.status.timerCountsInSecond = calibrationDataResponse.getTimerCountsInSecond();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastResponse(Response response) {
        Object object = this.responseLock;
        synchronized (object) {
            this.lastResponse = response;
            try {
                this.responseLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                MiscUtils.internalError("ProfilerClient.setLastResponse()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Response getLastResponse() throws ClientUtils.TargetAppOrVMTerminated {
        Response response;
        this.checkForTargetVMAlive();
        Object object = this.responseLock;
        synchronized (object) {
            while (this.lastResponse == null) {
                long l = System.currentTimeMillis();
                try {
                    this.responseLock.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    MiscUtils.internalError("InterruptedException in ProfilerClient.getLastResponse()");
                }
                if (!this.targetVMAlive) {
                    this.status.targetAppRunning = false;
                    this.targetVMAlive = false;
                    throw new ClientUtils.TargetAppOrVMTerminated(1);
                }
                if (this.lastResponse != null || this.wireIO.wasAlive() >= l || this.appStatusHandler.confirmWaitForConnectionReply()) continue;
                this.status.targetAppRunning = false;
                this.targetVMAlive = false;
                throw new ClientUtils.TargetAppOrVMTerminated(1);
            }
            response = this.lastResponse;
            this.lastResponse = null;
        }
        return response;
    }

    private boolean setVMProperties(VMPropertiesResponse vMPropertiesResponse, boolean bl) {
        String string;
        if (vMPropertiesResponse.getAgentVersion() != 8) {
            this.appStatusHandler.displayWarning(INCORRECT_AGENT_VERSION_MSG);
        }
        if (!MiscUtils.isSupportedRunningJVMVersion(string = vMPropertiesResponse.getJDKVersionString())) {
            String string2 = MessageFormat.format(UNSUPPORTED_JVM_MSG, string);
            this.appStatusHandler.displayErrorAndWaitForConfirm(string2);
            try {
                if (bl) {
                    this.terminateTargetJVM();
                } else {
                    this.detachFromTargetJVM();
                }
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            return false;
        }
        String string3 = Platform.getJDKVersionString(string);
        this.settings.setTargetJDKVersionString(string3);
        this.status.targetJDKVersionString = string3;
        this.status.fullTargetJDKVersionString = string;
        this.currentAgentId = vMPropertiesResponse.getAgentId();
        if (!this.status.remoteProfiling) {
            int n = CalibrationDataFileIO.readSavedCalibrationData(this.status);
            if (n < 0) {
                String string4 = MessageFormat.format(ERROR_GETTING_CALIBRATION_DATA_MSG, CalibrationDataFileIO.getErrorMessage());
                this.appStatusHandler.displayErrorAndWaitForConfirm(string4);
                return false;
            }
            if (n > 0) {
                this.appStatusHandler.displayErrorWithDetailsAndWaitForConfirm(MUST_CALIBRATE_FIRST_SHORT_MSG, MUST_CALIBRATE_FIRST_MSG);
                try {
                    if (bl) {
                        this.terminateTargetJVM();
                    } else {
                        this.detachFromTargetJVM();
                    }
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    // empty catch block
                }
                return false;
            }
        }
        this.status.jvmArguments = vMPropertiesResponse.getJVMArguments();
        this.status.javaCommand = vMPropertiesResponse.getJavaCommand();
        this.status.targetMachineOSName = vMPropertiesResponse.getTargetMachineOSName();
        this.status.maxHeapSize = vMPropertiesResponse.getMaxHeapSize();
        this.status.startupTimeMillis = vMPropertiesResponse.getStartupTimeMillis();
        this.status.startupTimeInCounts = vMPropertiesResponse.getStartupTimeInCounts();
        if (!this.status.remoteProfiling) {
            this.settings.setWorkingDir(vMPropertiesResponse.getWorkingDir());
            this.settings.setVMClassPaths(vMPropertiesResponse.getJavaClassPath(), vMPropertiesResponse.getJavaExtDirs(), vMPropertiesResponse.getBootClassPath());
            ClassRepository.initClassPaths(this.settings.getWorkingDir(), this.settings.getVMClassPaths());
        }
        return true;
    }

    private void checkForInstrMethodsLimitReached() {
        if (this.status.getStartingMethodId() >= 65535 && !this.instrMethodsLimitReported && this.status.targetAppRunning) {
            this.appStatusHandler.displayWarningAndWaitForConfirm(INSTRUMENTATION_LIMIT_REACHED_MSG);
            this.instrMethodsLimitReported = true;
        }
    }

    private void checkForTargetAppRunning() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.status.targetAppRunning) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(2);
        }
    }

    private void checkForTargetVMAlive() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetVMAlive) {
            this.serverCommandHandler.handleServerCommand(null);
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPreviousInstrumentationInServer() throws InstrumentationException, ClientUtils.TargetAppOrVMTerminated {
        String string;
        Response response = null;
        this.checkForTargetAppRunning();
        if (this.handlingEventBufferDump) {
            while (this.handlingEventBufferDump) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }
        if ((string = this.sendSimpleCommandAndGetResponse(9)) != null) {
            throw new InstrumentationException(string);
        }
        long l = System.currentTimeMillis();
        InstrumentMethodGroupCommand instrumentMethodGroupCommand = this.instrumentor.createClearAllInstrumentationCommand();
        ProfilerClient profilerClient = this;
        synchronized (profilerClient) {
            this.sendComplexCmdToServer(instrumentMethodGroupCommand);
            this.instrProcessingTime += System.currentTimeMillis() - l;
            response = this.getLastResponse();
        }
        if (!response.isOK()) {
            throw new InstrumentationException(response.getErrorMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (!this.serverListener.isRunning()) {
            return;
        }
        try {
            this.status.targetAppRunning = false;
            this.targetVMAlive = false;
            this.serverListener.shutdown();
            this.setLastResponse(null);
            this.socketOut.close();
            this.socketIn.close();
            this.clientSocket.close();
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
        }
        finally {
            EventBufferResultsProvider.getDefault().shutdown();
            EventBufferProcessor.removeEventBufferFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToServer(int n, boolean bl) {
        String string;
        this.status.targetAppRunning = false;
        this.targetVMAlive = false;
        this.terminateOrDetachCommandIssued = false;
        String string2 = string = n == 1 ? this.settings.getRemoteHost() : "";
        if (string.equals("") || string.equals("localhost") || string.equals("127.0.0.1")) {
            this.status.remoteProfiling = false;
            string = "127.0.0.1";
        } else {
            this.status.remoteProfiling = true;
        }
        String string3 = string;
        int n2 = this.settings.getPortNo();
        AppStatusHandler.AsyncDialog asyncDialog = this.appStatusHandler.getAsyncDialogInstance(CONNECT_VM_MSG, true, true);
        asyncDialog.display();
        boolean bl2 = true;
        boolean bl3 = true;
        int n3 = 600;
        try {
            this.serverListener = new ServerListener();
            this.serverListener.start();
            while (bl3) {
                try {
                    this.clientSocket = new Socket(string3, n2);
                    this.clientSocket.setSoTimeout(0);
                    this.clientSocket.setTcpNoDelay(true);
                    this.socketOut = new ObjectOutputStream(this.clientSocket.getOutputStream());
                    this.socketIn = new ObjectInputStream(this.clientSocket.getInputStream());
                    this.wireIO = new WireIO(this.socketOut, this.socketIn);
                    bl3 = false;
                    this.targetVMAlive = true;
                    this.serverListener.startRunning();
                }
                catch (ConnectException connectException) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (asyncDialog.cancelPressed()) {
                        bl3 = false;
                        this.serverListener.cancel();
                    }
                    if (--n3 != 0) continue;
                    MiscUtils.printWarningMessage("timed out while trying to connect to the target JVM.");
                    bl3 = false;
                    this.serverListener.cancel();
                }
            }
        }
        catch (Exception exception) {
            MiscUtils.printErrorMessage("exception while trying to connect to the target JVM:\n" + exception);
        }
        finally {
            asyncDialog.close();
        }
        if (!this.serverListener.isRunning()) {
            MiscUtils.printErrorMessage("connection with server not open");
            return false;
        }
        try {
            String string4 = this.sendSimpleCommandAndGetResponse(1);
            if (string4 != null) {
                this.targetVMAlive = false;
                MiscUtils.printErrorMessage("got error message from agent:" + string4);
                return false;
            }
            if (bl) {
                boolean bl4 = this.getCalibrationData(false);
                try {
                    this.terminateTargetJVM();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    ProfilerLogger.warning("terminateTargetJVM failed with TargetAppOrVMTerminated exception:");
                    ProfilerLogger.log(targetAppOrVMTerminated);
                }
                return bl4;
            }
            boolean bl5 = n == 1;
            ProfilerClient profilerClient = this;
            synchronized (profilerClient) {
                this.sendSimpleCmdToServer(28);
                Response response = this.getLastResponse();
                if (!(response instanceof VMPropertiesResponse)) {
                    System.err.println("SEVERE: Received " + response.getClass().getName() + "(" + response.toString() + ") instead of VMPropertiesResponse");
                }
                if (!this.setVMProperties((VMPropertiesResponse)response, bl5)) {
                    return false;
                }
            }
            this.serverClassesInitialized = false;
            string4 = this.sendCommandAndGetResponse(new InitiateInstrumentationCommand(2, "*FAKE_CLASS_FOR_INTERNAL_TEST*", false));
            if (string4 != null) {
                MiscUtils.printErrorMessage("got error message from agent:" + string4);
                this.targetVMAlive = false;
                return false;
            }
            n3 = 20;
            while (!this.serverClassesInitialized && --n3 > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.serverClassesInitialized) {
                MiscUtils.printErrorMessage("timed out while trying to initialize internals in the target JVM.");
                this.targetVMAlive = false;
                return false;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            this.targetVMAlive = false;
            MiscUtils.printErrorMessage("target app terminated:" + targetAppOrVMTerminated.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInSeparateThread(Command command) {
        Object object = this.execInSeparateThreadLock;
        synchronized (object) {
            this.execInSeparateThreadCmd = command;
            try {
                this.execInSeparateThreadLock.notify();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                MiscUtils.internalError("ProfilerClient.executeInSeparateThread()");
            }
        }
    }

    private boolean handleFakeClassLoad(RootClassLoadedCommand rootClassLoadedCommand) {
        if (rootClassLoadedCommand.getAllLoadedClassNames()[0].equals("*FAKE_CLASS_1*")) {
            this.sendComplexRespToServer(new InstrumentMethodGroupResponse(new String[]{"*FAKE_CLASS_1*", "*FAKE_CLASS_2*"}, new int[]{0, 0}, new byte[][]{{0}, {0}}, null, 0));
            this.serverClassesInitialized = true;
            return true;
        }
        return false;
    }

    private void handleIOExceptionOnSend(IOException iOException) throws ClientUtils.TargetAppOrVMTerminated {
        this.checkForTargetVMAlive();
        this.appStatusHandler.displayError(MessageFormat.format(TARGET_JVM_ERROR_MSG, iOException.getMessage()));
        this.closeConnection();
        throw new ClientUtils.TargetAppOrVMTerminated(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrumentMethodGroupFollowUp(Command command) {
        Object object = this.instrumentationLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            InstrumentMethodGroupResponse instrumentMethodGroupResponse = this.instrumentor.createFollowUpInstrumentMethodGroupResponse(command);
            this.instrProcessingTime += System.currentTimeMillis() - l;
            this.sendComplexRespToServer(instrumentMethodGroupResponse);
        }
        this.checkForInstrMethodsLimitReached();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void instrumentMethodGroupFromRoot(RootClassLoadedCommand var1_1) {
        var2_2 = null;
        var3_3 = this.instrumentationLock;
        synchronized (var3_3) {
            block27: {
                block25: {
                    block26: {
                        block23: {
                            block24: {
                                try {
                                    var4_4 = null;
                                    if (this.serverClassesInitialized || !this.handleFakeClassLoad(var1_1)) break block23;
                                    if (var2_2 == null) break block24;
                                    var5_5 = var2_2;
                                }
                                catch (Throwable var7_11) {
                                    if (var2_2 != null) {
                                        var8_12 = var2_2;
                                        if (EventQueue.isDispatchThread()) {
                                            var8_12.close();
                                        } else {
                                            EventQueue.invokeLater(new Runnable(var8_12){
                                                private final /* synthetic */ AppStatusHandler.AsyncDialog val$dialog;
                                                {
                                                    this.val$dialog = asyncDialog;
                                                }

                                                public void run() {
                                                    this.val$dialog.close();
                                                }
                                            });
                                        }
                                    }
                                    this.appStatusHandler.resumeLiveUpdates();
                                    throw var7_11;
                                }
                                if (EventQueue.isDispatchThread()) {
                                    var5_5.close();
                                } else {
                                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                }
                            }
                            this.appStatusHandler.resumeLiveUpdates();
                            return;
                        }
                        if (!this.currentInstrTypeIsRecursiveCPUProfiling() && !this.currentInstrTypeIsMemoryProfiling()) ** GOTO lbl44
                        if (EventBufferProcessor.bufFileExists() || EventBufferProcessor.setEventBufferFile(var1_1.getEventBufferFileName())) break block25;
                        this.appStatusHandler.displayError(MessageFormat.format(ProfilerClient.CANNOT_OPEN_SERVER_TEMPFILE_MSG, new Object[]{var1_1.getEventBufferFileName()}));
                        this.sendComplexRespToServer(new InstrumentMethodGroupResponse((Object)null));
                        if (var2_2 == null) break block26;
                        var5_6 = var2_2;
                        if (EventQueue.isDispatchThread()) {
                            var5_6.close();
                        } else {
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    this.appStatusHandler.resumeLiveUpdates();
                    return;
                }
                JMethodIdTable.reset();
lbl44:
                // 2 sources

                this.appStatusHandler.pauseLiveUpdates();
                if (this.status.targetAppRunning) {
                    var2_2 = this.appStatusHandler.getAsyncDialogInstance(ProfilerClient.PERFORMING_INSTRUMENTATION_STRING, true, false);
                    var2_2.display();
                }
                try {
                    var5_7 = System.currentTimeMillis();
                    var4_4 = this.instrumentor.createInitialInstrumentMethodGroupResponse(var1_1);
                    this.instrProcessingTime += System.currentTimeMillis() - var5_7;
                }
                catch (BadLocationException var5_8) {
                    var4_4 = new InstrumentMethodGroupResponse((Object)null);
                    this.appStatusHandler.displayError(ProfilerClient.INVALID_CODE_REGION_MSG);
                }
                catch (ClassNotFoundException var5_9) {
                    var4_4 = new InstrumentMethodGroupResponse((Object)null);
                    if (this.getCurrentInstrType() == 1) {
                        this.appStatusHandler.displayError(MessageFormat.format(ProfilerClient.CLASS_NOT_FOUND_MSG, new Object[]{var5_9.getMessage()}));
                    } else {
                        MiscUtils.printErrorMessage("problem in instrumentMethodGroupFromRoot: " + var5_9);
                    }
                }
                catch (Exception var5_10) {
                    MiscUtils.printErrorMessage("in instrumentMethodGroupFromRoot(), caught exception: " + var5_10);
                }
                this.sendComplexRespToServer((Response)var4_4);
                if (var2_2 == null) break block27;
                var4_4 = var2_2;
                if (EventQueue.isDispatchThread()) {
                    var4_4.close();
                } else {
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            this.appStatusHandler.resumeLiveUpdates();
        }
    }

    private void readAndProcessProfilingResults(EventBufferDumpedCommand eventBufferDumpedCommand) {
        int n = eventBufferDumpedCommand.getBufSize();
        if (n == 0) {
            this.sendSimpleRespToServer(true, null);
            return;
        }
        this.handlingEventBufferDump = true;
        int n2 = this.getCurrentInstrType();
        if (this.currentInstrTypeIsMemoryProfiling() && !this.status.remoteProfiling && !this.forceObtainedResultsDumpCalled) {
            this.executeInSeparateThread(eventBufferDumpedCommand);
            this.handlingEventBufferDump = false;
        } else {
            EventBufferProcessor.readDataAndPrepareForProcessing(n);
            EventBufferResultsProvider.getDefault().dataReady(n, n2);
            this.handlingEventBufferDump = false;
            this.sendSimpleRespToServer(true, null);
            this.forceObtainedResultsDumpCalled = false;
        }
    }

    private synchronized String sendCommandAndGetResponse(Command command) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendComplexCmdToServer(command);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmd = " + command + " and resp = " + response + " got error message: " + response.getErrorMessage());
            return response.getErrorMessage();
        }
        return null;
    }

    private void sendComplexCmdToServer(Command command) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendComplexCommand(command);
        }
        catch (IOException iOException) {
            this.handleIOExceptionOnSend(iOException);
        }
    }

    private void sendComplexRespToServer(Response response) {
        try {
            this.wireIO.sendComplexResponse(response);
        }
        catch (IOException iOException) {
            MiscUtils.printErrorMessage("exception when trying to send a response: " + iOException);
            try {
                this.handleIOExceptionOnSend(iOException);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    private void sendSimpleCmdToServer(int n) throws ClientUtils.TargetAppOrVMTerminated {
        try {
            this.wireIO.sendSimpleCommand(n);
        }
        catch (IOException iOException) {
            this.handleIOExceptionOnSend(iOException);
        }
    }

    private synchronized String sendSimpleCommandAndGetResponse(int n) throws ClientUtils.TargetAppOrVMTerminated {
        this.sendSimpleCmdToServer(n);
        Response response = this.getLastResponse();
        if (!response.isOK()) {
            MiscUtils.printErrorMessage("error in sendCommandAndGetResponse: for cmdType = " + n + " and resp = " + response + " got error message: " + response.getErrorMessage());
            return response.getErrorMessage();
        }
        return null;
    }

    private void sendSimpleRespToServer(boolean bl, String string) {
        try {
            this.wireIO.sendSimpleResponse(bl, string);
        }
        catch (IOException iOException) {
            try {
                this.handleIOExceptionOnSend(iOException);
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ int[] access$1402(ProfilerClient profilerClient, int[] nArray) {
        profilerClient.savedAllocatedObjectsCountResults = nArray;
        return nArray;
    }

    private class ServerListener
    extends Thread {
        private final Object startedFlagLock = new Object();
        private int startedFlag = 0;

        private ServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                return this.startedFlag == 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = -1;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                while (this.startedFlag == 0) {
                    try {
                        this.startedFlagLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.startedFlag = -1;
                    }
                }
                if (this.startedFlag == -1) {
                    return;
                }
            }
            while (ProfilerClient.this.targetVMAlive) {
                try {
                    object = ProfilerClient.this.wireIO.receiveCommandOrResponse();
                    if (object == null) {
                        ProfilerClient.this.closeConnection();
                        continue;
                    }
                    if (object instanceof Command) {
                        this.handleServerCommand((Command)object);
                        continue;
                    }
                    ProfilerClient.this.setLastResponse((Response)object);
                }
                catch (IOException iOException) {
                    if (!ProfilerClient.this.targetVMAlive || ProfilerClient.this.terminateOrDetachCommandIssued) continue;
                    MiscUtils.printErrorMessage("exception while trying to get response from the target JVM:\n" + iOException);
                    ProfilerClient.this.closeConnection();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 0;
                this.startedFlagLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startRunning() {
            Object object = this.startedFlagLock;
            synchronized (object) {
                this.startedFlag = 1;
                this.startedFlagLock.notifyAll();
            }
        }

        private void handleServerCommand(Command command) {
            switch (command.getType()) {
                case 18: {
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    new Thread(){

                        public void run() {
                            try {
                                int n = ProfilerClient.this.getCurrentInstrType();
                                if (ProfilerClient.this.currentInstrTypeIsRecursiveCPUProfiling() || ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.this.forceObtainedResultsDump();
                                }
                                if (ProfilerClient.this.currentInstrTypeIsMemoryProfiling()) {
                                    ProfilerClient.access$1402(ProfilerClient.this, ProfilerClient.this.getAllocatedObjectsCountResults());
                                }
                                ((ProfilerClient)((ServerListener)ServerListener.this).ProfilerClient.this).status.savedInternalStats = ProfilerClient.this.getInternalStats();
                                ProfilerClient.this.appStatusHandler.handleShutdown();
                                ProfilerClient.this.sendSimpleCmdToServer(15);
                            }
                            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                                // empty catch block
                            }
                        }
                    }.start();
                    break;
                }
                case 19: {
                    ProfilerClient.this.targetVMAlive = false;
                    ((ProfilerClient)ProfilerClient.this).status.targetAppRunning = false;
                    EventBufferProcessor.removeEventBufferFile();
                    break;
                }
                case 17: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 26: {
                    ProfilerClient.this.readAndProcessProfilingResults((EventBufferDumpedCommand)command);
                    break;
                }
                case 36: {
                    ProfilerClient.this.executeInSeparateThread(command);
                    break;
                }
                case 38: {
                    ProfilerClient.this.resultsStart = System.currentTimeMillis();
                    break;
                }
                case 42: {
                    GetClassIdCommand getClassIdCommand = (GetClassIdCommand)command;
                    int n = ProfilerClient.this.instrumentor.getClassId(getClassIdCommand.getClassName(), getClassIdCommand.getClassLoaderId());
                    ProfilerClient.this.sendComplexRespToServer(new GetClassIdResponse(n != -1, n));
                    break;
                }
            }
            if (!ProfilerClient.this.targetVMAlive) {
                ProfilerClient.this.closeConnection();
            }
            ProfilerClient.this.serverCommandHandler.handleServerCommand(command);
        }
    }

    private class SeparateCmdExecutionThread
    extends Thread {
        private SeparateCmdExecutionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.setName("*** JFluid Separate Command Execution Thread");
            Object object = ProfilerClient.this.execInSeparateThreadLock;
            synchronized (object) {
                while (true) {
                    try {
                        ProfilerClient.this.execInSeparateThreadLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        MiscUtils.internalError("ProfilerClient.SpecialExecutionThread.run()");
                    }
                    if (ProfilerClient.this.execInSeparateThreadCmd == null) {
                        return;
                    }
                    Command command = ProfilerClient.this.execInSeparateThreadCmd;
                    ProfilerClient.this.execInSeparateThreadCmd = null;
                    switch (command.getType()) {
                        case 17: {
                            ProfilerClient.this.instrumentMethodGroupFromRoot((RootClassLoadedCommand)command);
                            break;
                        }
                        case 3: 
                        case 22: 
                        case 23: {
                            ProfilerClient.this.instrumentMethodGroupFollowUp(command);
                            break;
                        }
                        case 26: {
                            int n = ((EventBufferDumpedCommand)command).getBufSize();
                            EventBufferProcessor.readDataAndPrepareForProcessing(n);
                            ArrayList arrayList = new ArrayList();
                            EventBufferResultsProvider.getDefault().dataReady(n, ProfilerClient.this.getCurrentInstrType());
                            ProfilerClient.this.sendSimpleRespToServer(true, null);
                            break;
                        }
                        case 36: {
                            ProfilerClient profilerClient = ProfilerClient.this;
                            synchronized (profilerClient) {
                                Object object2 = ProfilerClient.this.forceObtainedResultsDumpLock;
                                synchronized (object2) {
                                    if (ProfilerClient.this.memCctProvider != null) {
                                        ProfilerClient.this.memCctProvider.updateInternals();
                                    }
                                    ProfilerClient.this.sendSimpleRespToServer(true, null);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

