/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.rename;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyncDocumentRegion {
    private Document doc;
    private List<? extends MutablePositionRegion> regions;
    private List<? extends MutablePositionRegion> sortedRegions;
    private boolean regionsSortPerformed;

    public SyncDocumentRegion(Document document, List<? extends MutablePositionRegion> list) {
        this.doc = document;
        this.regions = list;
        this.regionsSortPerformed = PositionRegion.isRegionsSorted(list);
        if (this.regionsSortPerformed) {
            this.sortedRegions = list;
        } else {
            this.sortedRegions = new ArrayList<MutablePositionRegion>(list);
            Collections.sort(this.sortedRegions, PositionRegion.getComparator());
        }
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public MutablePositionRegion getRegion(int n) {
        return this.regions.get(n);
    }

    public int getFirstRegionStartOffset() {
        return this.getRegion(0).getStartOffset();
    }

    public int getFirstRegionEndOffset() {
        return this.getRegion(0).getEndOffset();
    }

    public int getFirstRegionLength() {
        return this.getFirstRegionEndOffset() - this.getFirstRegionStartOffset();
    }

    public MutablePositionRegion getSortedRegion(int n) {
        return this.sortedRegions.get(n);
    }

    public void sync(int n) {
        String string;
        if (n != 0) {
            string = this.getRegion(0);
            try {
                Position position = this.doc.createPosition(string.getStartOffset() - n);
                string.setStartPosition(position);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
        }
        if ((string = this.getFirstRegionText()) != null) {
            int n2 = this.getRegionCount();
            for (int i = 1; i < n2; ++i) {
                MutablePositionRegion mutablePositionRegion = this.getRegion(i);
                int n3 = mutablePositionRegion.getStartOffset();
                int n4 = mutablePositionRegion.getEndOffset() - n3;
                try {
                    if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)DocumentUtilities.getText((Document)this.doc, (int)n3, (int)n4))) continue;
                    if (string.length() > 0) {
                        this.doc.insertString(n3, string, null);
                    }
                    this.doc.remove(n3 + string.length(), n4);
                    continue;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        }
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int n) {
        try {
            MutablePositionRegion mutablePositionRegion = this.getRegion(n);
            int n2 = mutablePositionRegion.getStartOffset();
            int n3 = mutablePositionRegion.getEndOffset() - n2;
            return this.doc.getText(n2, n3);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify((Throwable)badLocationException);
            return null;
        }
    }
}

