/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenPopup;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotation;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsOverriddenAnnotation
extends Annotation {
    private StyledDocument document;
    private Position pos;
    private String shortDescription;
    private AnnotationType type;
    private List<ElementDescription> declarations;

    public IsOverriddenAnnotation(StyledDocument styledDocument, Position position, AnnotationType annotationType, String string, List<ElementDescription> list) {
        this.document = styledDocument;
        this.pos = position;
        this.type = annotationType;
        this.shortDescription = string;
        this.declarations = list;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getAnnotationType() {
        switch (this.type) {
            case IS_OVERRIDDEN: {
                return "org-netbeans-modules-editor-java-is_overridden";
            }
            case HAS_IMPLEMENTATION: {
                return "org-netbeans-modules-editor-java-has_implementations";
            }
            case IMPLEMENTS: {
                return "org-netbeans-modules-editor-java-implements";
            }
            case OVERRIDES: {
                return "org-netbeans-modules-editor-java-overrides";
            }
        }
        throw new IllegalStateException("Currently not implemented: " + (Object)((Object)this.type));
    }

    public void attach() {
        NbDocument.addAnnotation((StyledDocument)this.document, (Position)this.pos, (int)-1, (Annotation)this);
    }

    public void detachImpl() {
        NbDocument.removeAnnotation((StyledDocument)this.document, (Annotation)this);
    }

    public String toString() {
        return "[IsOverriddenAnnotation: " + this.shortDescription + "]";
    }

    public Position getPosition() {
        return this.pos;
    }

    public String debugDump() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ElementDescription elementDescription : this.declarations) {
            arrayList.add(elementDescription.getDisplayName());
        }
        Collections.sort(arrayList);
        return "IsOverriddenAnnotation: type=" + this.type.name() + ", elements:" + ((Object)arrayList).toString();
    }

    void mouseClicked(JTextComponent jTextComponent, Point point) {
        Point point2 = new Point(point);
        SwingUtilities.convertPointToScreen(point2, jTextComponent);
        IsOverriddenAnnotation.performGoToAction(this.type, this.declarations, point2, this.shortDescription);
    }

    static void performGoToAction(AnnotationType annotationType, List<ElementDescription> list, Point point, String string) {
        String string2;
        if ((annotationType == AnnotationType.IMPLEMENTS || annotationType == AnnotationType.OVERRIDES) && list.size() == 1) {
            ElementDescription elementDescription = list.get(0);
            FileObject fileObject = elementDescription.getSourceFile();
            if (fileObject != null) {
                ElementOpen.open((FileObject)fileObject, elementDescription.getHandle());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        switch (annotationType) {
            case IMPLEMENTS: {
                string2 = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Implements");
                break;
            }
            case OVERRIDES: {
                string2 = NbBundle.getMessage(IsOverriddenAnnotation.class, (String)"CAP_Overrides");
                break;
            }
            case IS_OVERRIDDEN: 
            case HAS_IMPLEMENTATION: {
                string2 = string;
                break;
            }
            default: {
                throw new IllegalStateException("Currently not implemented: " + (Object)((Object)annotationType));
            }
        }
        PopupUtil.showPopup(new IsOverriddenPopup(string2, list), string2, point.x, point.y, true, 0);
    }
}

