/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.java.editor.codegen.CodeGenerator;
import org.netbeans.modules.java.editor.codegen.ui.GenerateCodePanel;
import org.netbeans.modules.java.editor.overridden.PopupUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateCodeAction
extends BaseAction {
    public static final String generateCode = "generate-code";

    public GenerateCodeAction() {
        super(generateCode);
        this.putValue("trimmed-text", NbBundle.getBundle(GenerateCodeAction.class).getString("generate-code-trimmed"));
        this.putValue("ShortDescription", NbBundle.getBundle(GenerateCodeAction.class).getString("desc-generate-code"));
        this.putValue("PopupMenuText", NbBundle.getBundle(GenerateCodeAction.class).getString("popup-generate-code"));
    }

    public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        try {
            JavaSource javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument());
            if (javaSource != null) {
                final int n = jTextComponent.getCaretPosition();
                final ArrayList arrayList = new ArrayList();
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.PARSED);
                        TreePath treePath = compilationController.getTreeUtilities().pathFor(n);
                        for (CodeGenerator.Factory factory : GenerateCodeAction.this.getCodeGeneratorFactories()) {
                            for (CodeGenerator codeGenerator : factory.create(compilationController, treePath)) {
                                arrayList.add(codeGenerator);
                            }
                        }
                    }
                }, true);
                if (arrayList.size() > 0) {
                    Rectangle rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    SwingUtilities.convertPointToScreen(point, jTextComponent);
                    GenerateCodePanel generateCodePanel = new GenerateCodePanel(jTextComponent, arrayList);
                    PopupUtil.showPopup(generateCodePanel, null, point.x, point.y, true, rectangle.height);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private Iterable<? extends CodeGenerator.Factory> getCodeGeneratorFactories() {
        return MimeLookup.getLookup((String)"text/x-java").lookupAll(CodeGenerator.Factory.class);
    }

    public static final class GlobalAction
    extends MainMenuAction {
        private final JMenuItem menuPresenter = new JMenuItem(this.getMenuItemText());

        public GlobalAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(GlobalAction.class).getString("generate-code-main-menu-source-item");
        }

        protected String getActionName() {
            return GenerateCodeAction.generateCode;
        }

        public JMenuItem getMenuPresenter() {
            return this.menuPresenter;
        }
    }
}

