/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.netbeans.libs.freemarker.FreemarkerFactory;
import org.netbeans.libs.freemarker.RsrcLoader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

class FreemarkerEngine
extends AbstractScriptEngine {
    public static final String STRING_OUTPUT_MODE = "com.sun.script.freemarker.stringOut";
    public static final String FREEMARKER_CONFIG = "com.sun.script.freemarker.config";
    public static final String FREEMARKER_PROPERTIES = "com.sun.script.freemarker.properties";
    public static final String FREEMARKER_TEMPLATE_DIR = "com.sun.script.freemarker.template.dir";
    public static final String FREEMARKER_TEMPLATE = "org.openide.filesystems.FileObject";
    private static Map<FileObject, Template> templates = Collections.synchronizedMap(new WeakHashMap());
    private volatile ScriptEngineFactory factory;
    private volatile Configuration conf;
    private volatile FileObject fo;

    public FreemarkerEngine(ScriptEngineFactory scriptEngineFactory) {
        this.factory = scriptEngineFactory;
    }

    public FreemarkerEngine() {
        this((ScriptEngineFactory)null);
    }

    public Object eval(String string, ScriptContext scriptContext) throws ScriptException {
        return this.eval((Reader)new StringReader(string), scriptContext);
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        scriptContext.setAttribute("context", scriptContext, 100);
        this.initFreeMarkerConfiguration(scriptContext);
        String string = FreemarkerEngine.getFilename(scriptContext);
        boolean bl = FreemarkerEngine.isStringOutputMode(scriptContext);
        Writer writer = bl ? new StringWriter() : scriptContext.getWriter();
        Template template = null;
        try {
            if (this.fo != null) {
                template = templates.remove(this.fo);
            }
            if (template == null) {
                template = new MyTemplate(this.fo, string, reader, this.conf);
            } else {
                ((MyTemplate)template).conf = this.conf;
            }
            template.process(null, writer);
            writer.flush();
            if (this.fo != null) {
                templates.put(this.fo, template);
            }
        }
        catch (Exception exception) {
            throw new ScriptException(exception);
        }
        return bl ? writer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        FreemarkerEngine freemarkerEngine = this;
        synchronized (freemarkerEngine) {
            if (this.factory == null) {
                this.factory = new FreemarkerFactory();
            }
        }
        return this.factory;
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    private static String getFilename(ScriptContext scriptContext) {
        Object object = scriptContext.getAttribute(FREEMARKER_TEMPLATE);
        if (object instanceof FileObject) {
            return ((FileObject)object).getPath();
        }
        Object object2 = scriptContext.getAttribute("javax.script.filename");
        if (object2 != null) {
            return object2.toString();
        }
        return "unknown";
    }

    private static boolean isStringOutputMode(ScriptContext scriptContext) {
        Object object = scriptContext.getAttribute(STRING_OUTPUT_MODE);
        if (object != null) {
            return object.equals(Boolean.TRUE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFreeMarkerConfiguration(ScriptContext scriptContext) {
        if (this.conf == null) {
            FreemarkerEngine freemarkerEngine = this;
            synchronized (freemarkerEngine) {
                if (this.conf != null) {
                    return;
                }
                Object object = scriptContext.getAttribute(FREEMARKER_CONFIG);
                if (object instanceof Configuration) {
                    this.conf = (Configuration)object;
                    return;
                }
                Object object2 = scriptContext.getAttribute(FREEMARKER_TEMPLATE);
                this.fo = object2 instanceof FileObject ? (FileObject)object2 : null;
                RsrcLoader rsrcLoader = new RsrcLoader(this.fo, scriptContext);
                try {
                    FreemarkerEngine.initConfProps(rsrcLoader, scriptContext);
                    FreemarkerEngine.initTemplateDir(rsrcLoader, this.fo, scriptContext);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                this.conf = rsrcLoader;
            }
        }
    }

    private static void initConfProps(Configuration configuration, ScriptContext scriptContext) {
        try {
            Object object;
            Object object2;
            Properties properties = null;
            Object object3 = scriptContext.getAttribute(FREEMARKER_PROPERTIES);
            if (properties instanceof Properties) {
                properties = (Properties)object3;
            } else {
                object2 = System.getProperty(FREEMARKER_PROPERTIES);
                if (object2 != null && ((File)(object = new File((String)object2))).exists() && ((File)object).canRead()) {
                    properties = new Properties();
                    properties.load(new FileInputStream((File)object));
                }
            }
            if (properties != null) {
                object2 = properties.keySet();
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof String)) continue;
                    String string = (String)e;
                    try {
                        configuration.setSetting(string, properties.get(string).toString());
                    }
                    catch (TemplateException templateException) {}
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void initTemplateDir(Configuration configuration, FileObject fileObject, ScriptContext scriptContext) {
        try {
            String string;
            Object object = scriptContext.getAttribute(FREEMARKER_TEMPLATE_DIR);
            if (object != null) {
                string = object.toString();
            } else {
                if (fileObject != null) {
                    return;
                }
                object = System.getProperty(FREEMARKER_TEMPLATE_DIR);
                string = object == null ? "." : object.toString();
            }
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                configuration.setDirectoryForTemplateLoading(file);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static final class MyTemplate
    extends Template
    implements FileChangeListener {
        public Configuration conf;

        public MyTemplate(FileObject fileObject, String string, Reader reader, Configuration configuration) throws IOException {
            super(string, reader, configuration);
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }

        public Configuration getConfiguration() {
            return this.conf == null ? super.getConfiguration() : this.conf;
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.clear();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.clear();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.clear();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.clear();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.clear();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.clear();
        }

        private void clear() {
            templates.clear();
        }
    }
}

