/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.wizard.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.catalogsupport.util.ProjectUtilities;
import org.netbeans.modules.xml.catalogsupport.util.ProjectWSDL;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.project.wizard.element.FileDialog;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Panel<T>
implements WizardDescriptor.ValidatingPanel<T> {
    private ChangeSupport myChangeSupport;
    private Project myProject;
    private JPanel myComponent;
    private FileObject myFolder;
    private Panel<T> myParent;
    private static final String DOT = ".";
    private static final String EXT = "xsl";
    private static final String NAME = "newXSLFile";
    private static final String BROWSE_LABEL = "LBL_Browse";
    private static final String BROWSE_LABEL2 = "LBL_Browse2";
    protected static final String EMPTY = "";
    protected static final String NAME_TYPE = UI.i18n(Panel.class, (String)"LBL_Service_Type");
    protected static final String NAME_WSDL = UI.i18n(Panel.class, (String)"LBL_WSDL_File");
    protected static final String NAME_XSLT = UI.i18n(Panel.class, (String)"LBL_XSLT_Configuration");
    public static final String INPUT_FILE = "input.file";
    public static final String INPUT_OPERATION = "input.operation";
    public static final String INPUT_PARTNER_ROLE_PORT = "input.partner.role.port";
    public static final String OUTPUT_FILE = "output.file";
    public static final String OUTPUT_OPERATION = "output.operation";
    public static final String OUTPUT_PARTNER_ROLE_PORT = "output.partner.role.port";
    public static final String CHOICE = "choice";
    public static final String CHOICE_REQUEST_REPLY = "choice.request.reply";
    public static final String CHOICE_FILTER_ONE_WAY = "choice.filter.one.way";
    public static final String CHOICE_FILTER_REQUEST_REPLY = "choice.filter.request.reply";

    Panel(Project project, Panel<T> panel) {
        this.myProject = project;
        this.myFolder = ProjectUtilities.getSrcFolder((Project)project);
        this.myParent = panel;
        this.myChangeSupport = new ChangeSupport((Object)this);
    }

    protected final Project getProject() {
        return this.myProject;
    }

    protected final FileObject getFolder() {
        return this.myFolder;
    }

    protected final Panel<T> getParent() {
        return this.myParent;
    }

    protected abstract void createPanel(JPanel var1, GridBagConstraints var2);

    protected void setEnabled(boolean bl) {
    }

    protected void update() {
    }

    protected String getComponentName() {
        return null;
    }

    protected Panel<T> getNext() {
        return null;
    }

    protected Object getResult() {
        return null;
    }

    protected final Panel<T> getPrevious() {
        return this.myParent;
    }

    protected String getError() {
        return null;
    }

    protected final String getError(String string, String string2) {
        if (string != null) {
            return string;
        }
        return string2;
    }

    public JPanel getComponent() {
        if (this.myComponent == null) {
            this.myComponent = this.createMainPanel();
            String string = this.getComponentName();
            this.myComponent.setName(string);
            String[] stringArray = new String[]{NAME_TYPE, NAME_WSDL, NAME_XSLT};
            this.myComponent.putClientProperty("WizardPanel_contentData", stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                this.myComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i - 1));
            }
        }
        return this.myComponent;
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.createPanel(jPanel, gridBagConstraints);
        return jPanel;
    }

    public void validate() throws WizardValidationException {
        String string = this.getError();
        if (string != null) {
            throw new WizardValidationException((JComponent)this.myComponent, string, string);
        }
    }

    protected final String i18n(String string) {
        return UI.i18n(Panel.class, (String)string);
    }

    protected final String i18n(String string, String string2) {
        return UI.i18n(Panel.class, (String)string, (String)string2);
    }

    protected final String i18n(String string, String string2, String string3) {
        return UI.i18n(Panel.class, (String)string, (String)string2, (String)string3);
    }

    public boolean isValid() {
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("xslt_project_addxsl");
    }

    public void storeSettings(Object object) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myChangeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.myChangeSupport.removeChangeListener(changeListener);
    }

    public void readSettings(Object object) {
    }

    protected final int getXslFileNumber(int n) {
        int n2 = n;
        while (this.getFolder().getFileObject(NAME + n2, EXT) != null) {
            ++n2;
        }
        return n2;
    }

    protected final String getXslFileName(int n) {
        return NAME + n;
    }

    protected final String getType(OperationParameter operationParameter) {
        if (operationParameter == null) {
            return EMPTY;
        }
        NamedComponentReference namedComponentReference = operationParameter.getMessage();
        if (namedComponentReference == null) {
            return EMPTY;
        }
        Message message = (Message)namedComponentReference.get();
        if (message == null) {
            return EMPTY;
        }
        Collection collection = message.getParts();
        if (collection == null) {
            return EMPTY;
        }
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        return this.getType((Part)iterator.next());
    }

    private String getType(Part part) {
        QName qName;
        NamedComponentReference namedComponentReference = part.getType();
        NamedComponentReference namedComponentReference2 = namedComponentReference = namedComponentReference == null ? part.getElement() : namedComponentReference;
        if (namedComponentReference != null && (qName = namedComponentReference.getQName()) != null) {
            return qName.getLocalPart();
        }
        return EMPTY;
    }

    protected final String addExtension(String string) {
        String string2 = string = File.separator.equals("\\") ? string.replace(File.separatorChar, '/') : string;
        if (string.endsWith(".xsl")) {
            return string;
        }
        return string + DOT + EXT;
    }

    protected final JButton createBrowseButton(JTextField jTextField) {
        return this.createBrowseButton(jTextField, BROWSE_LABEL);
    }

    protected final JButton createBrowseButton(final JTextField jTextField, String string) {
        final JPanel jPanel = this.myComponent;
        JButton jButton = UI.createButton((Action)new UI.ButtonAction(this.i18n(string), this.i18n("TLT_Browse")){

            public void actionPerformed(ActionEvent actionEvent) {
                FileFilter fileFilter = new FileFilter(){

                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String string = FileUtil.getExtension((String)file.getName());
                        return Panel.EXT.equals(string) || "xslt".equals(string);
                    }

                    public String getDescription() {
                        return Panel.this.i18n("LBL_Transformation_Filter_Descr");
                    }
                };
                JFileChooser jFileChooser = new JFileChooser(FileUtil.toFile((FileObject)Panel.this.getFolder()), (FileSystemView)new FileDialog(Panel.this.getProject()));
                jFileChooser.setFileFilter(fileFilter);
                int n = jFileChooser.showOpenDialog(jPanel);
                File file = jFileChooser.getSelectedFile();
                if (n == 0 && file != null) {
                    String string = Panel.EMPTY;
                    if (!(file = FileUtil.normalizeFile((File)file)).exists()) {
                        string = FileUtil.getRelativePath((FileObject)Panel.this.getFolder(), (FileObject)FileUtil.toFileObject((File)file.getParentFile()));
                        string = (string == null || Panel.EMPTY.equals(string) ? Panel.EMPTY : string + "/") + file.getName();
                    } else {
                        string = FileUtil.getRelativePath((FileObject)Panel.this.getFolder(), (FileObject)FileUtil.toFileObject((File)file));
                    }
                    jTextField.setText(string);
                }
            }
        });
        return jButton;
    }

    public static class PartnerRolePort {
        private Role myRole;
        private PortType myPortType;
        private PartnerLinkType myPartnerLinkType;

        public PartnerRolePort(PartnerLinkType partnerLinkType, Role role, PortType portType) {
            this.myPartnerLinkType = partnerLinkType;
            this.myRole = role;
            this.myPortType = portType;
        }

        public PartnerLinkType getPartnerLinkType() {
            return this.myPartnerLinkType;
        }

        public Role getRole() {
            return this.myRole;
        }

        public PortType getPortType() {
            return this.myPortType;
        }

        public String getName() {
            return this.myPortType.getName() + " (" + this.myPartnerLinkType.getName() + "/" + this.myRole.getName() + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof PartnerRolePort)) {
                return false;
            }
            PartnerRolePort partnerRolePort = (PartnerRolePort)object;
            return partnerRolePort.getPartnerLinkType().equals(this.getPartnerLinkType()) && partnerRolePort.getRole().equals(this.getRole()) && partnerRolePort.getPortType().equals(this.getPortType());
        }

        public int hashCode() {
            return this.getPartnerLinkType().hashCode() * this.getRole().hashCode() * this.getPortType().hashCode();
        }
    }

    protected class Renderer
    extends DefaultListCellRenderer {
        protected Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ProjectWSDL) {
                this.setText(((ProjectWSDL)object).getName());
            }
            if (object instanceof Operation) {
                this.setText(((Operation)object).getName());
            }
            if (object instanceof PartnerRolePort) {
                this.setText(((PartnerRolePort)object).getName());
            }
            return this;
        }
    }
}

