/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.wizard.element;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.catalogsupport.util.ProjectUtilities;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xslt.project.wizard.element.Panel;
import org.netbeans.modules.xslt.project.wizard.element.PanelStartup;
import org.netbeans.modules.xslt.project.wizard.element.PanelUtil;
import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponentFactory;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.netbeans.modules.xslt.tmap.model.api.Variable;
import org.netbeans.modules.xslt.tmap.model.api.VariableDeclarator;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;
import org.netbeans.modules.xslt.tmap.model.impl.VariableReferenceImpl;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 1L;
    private static Map<String, TransformationUseCase> TRANSFORMATION_USE_CASE = new HashMap<String, TransformationUseCase>();
    private static String TEMPLATES_PATH;
    private static String XSLT_SERVICE;
    private static String XSL;
    private Panel<WizardDescriptor> myPanel;
    private static final String DEFAULT_VARIABLE_PREFIX = "var";
    private static final String INPUT_OPERATION_VARIABLE_PREFIX = "inOpVar";
    private static final String OUTPUT_OPERATION_VARIABLE_PREFIX = "outOpVar";
    private static final String INPUT_INVOKE_VARIABLE_PREFIX = "inInvokeVar";
    private static final String OUTPUT_INVOKE_VARIABLE_PREFIX = "outInvokeVar";

    public static Iterator createXsl() {
        return new Iterator();
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        return Collections.singleton(this.createFile(templateWizard));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.myPanel = new PanelStartup<WizardDescriptor>(Templates.getProject((WizardDescriptor)templateWizard), null);
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.myPanel = null;
    }

    public String name() {
        return UI.i18n(Iterator.class, (String)"LBL_Title");
    }

    public boolean hasNext() {
        return this.myPanel.getNext() != null;
    }

    public boolean hasPrevious() {
        return this.myPanel.getPrevious() != null;
    }

    public void nextPanel() {
        this.myPanel = this.myPanel.getNext();
    }

    public void previousPanel() {
        this.myPanel = this.myPanel.getPrevious();
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.myPanel;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private DataObject createFile(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject = null;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        String string = (String)templateWizard.getProperty("choice");
        TransformationUseCasesFactory transformationUseCasesFactory = TransformationUseCasesFactory.getInstance();
        fileObject = transformationUseCasesFactory.createUseCase(project, templateWizard);
        return fileObject == null ? null : DataObject.find((FileObject)fileObject);
    }

    private static TransformationUseCase getUseCase(TemplateWizard templateWizard) {
        String string = templateWizard == null ? null : (String)templateWizard.getProperty("choice");
        return string == null ? null : TRANSFORMATION_USE_CASE.get(string);
    }

    static {
        TRANSFORMATION_USE_CASE.put("choice.request.reply", TransformationUseCase.REQUEST_REPLY);
        TRANSFORMATION_USE_CASE.put("choice.filter.one.way", TransformationUseCase.FILTER_ONE_WAY);
        TRANSFORMATION_USE_CASE.put("choice.filter.request.reply", TransformationUseCase.FILTER_REQUEST_REPLY);
        TEMPLATES_PATH = "Templates/SOA_XSLT/";
        XSLT_SERVICE = "xslt.service";
        XSL = "xsl";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TransformationUseCasesFactory {
        private static TransformationUseCasesFactory INSTANCE = new TransformationUseCasesFactory();

        private TransformationUseCasesFactory() {
        }

        public static TransformationUseCasesFactory getInstance() {
            return INSTANCE;
        }

        public FileObject createUseCase(Project project, TemplateWizard templateWizard) throws IOException {
            assert (project != null && templateWizard != null);
            ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
            TransformationUseCase transformationUseCase = Iterator.getUseCase(templateWizard);
            assert (transformationUseCase != null);
            FileObject fileObject = this.createXslFiles(transformationUseCase, project, templateWizard, arrayList);
            if (fileObject != null) {
                try {
                    this.configureTMapModel(transformationUseCase, project, templateWizard);
                }
                catch (IOException iOException) {
                    this.rollbackCreatedXslFiles(arrayList);
                    fileObject = null;
                    throw iOException;
                }
            }
            return fileObject;
        }

        private void rollbackCreatedXslFiles(List<FileObject> list) throws IOException {
            assert (list != null);
            for (FileObject fileObject : list) {
                if (fileObject == null || !fileObject.isValid()) continue;
                fileObject.delete();
            }
        }

        private FileObject createXslFiles(TransformationUseCase transformationUseCase, Project project, TemplateWizard templateWizard, List<FileObject> list) throws IOException {
            assert (project != null && transformationUseCase != null && templateWizard != null);
            String string = (String)templateWizard.getProperty("input.file");
            String string2 = TransformationUseCase.FILTER_REQUEST_REPLY.equals((Object)transformationUseCase) ? (String)templateWizard.getProperty("output.file") : null;
            FileObject fileObject = null;
            if (string != null) {
                fileObject = this.createXslFile(project, string, list);
            }
            if (string2 != null) {
                fileObject = this.createXslFile(project, string2, list);
            }
            return fileObject;
        }

        private FileObject createXslFile(Project project, String string, List<FileObject> list) throws IOException {
            if (string == null || "".equals(string)) {
                return null;
            }
            int n = string.lastIndexOf(XSL) - 1;
            if (n <= 0) {
                return null;
            }
            if ("".equals(string = string.substring(0, n))) {
                return null;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (File.separatorChar == '\\') {
                bl2 = true;
                string = string.replace('/', File.separatorChar);
            } else {
                bl = true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
            int n2 = stringTokenizer.countTokens();
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n3] = stringTokenizer.nextToken();
                ++n3;
            }
            FileObject fileObject = ProjectUtilities.getSrcFolder((Project)project);
            boolean bl3 = false;
            if (n2 > 1) {
                string = stringArray[n2 - 1];
                for (int i = 0; i < n2 - 1; ++i) {
                    FileObject fileObject2 = fileObject.getFileObject(stringArray[i]);
                    if (fileObject2 == null) {
                        try {
                            fileObject = fileObject.createFolder(stringArray[i]);
                        }
                        catch (IOException iOException) {
                            this.rollbackCreatedXslFiles(list);
                            throw iOException;
                        }
                        if (fileObject == null) {
                            this.rollbackCreatedXslFiles(list);
                            break;
                        }
                        if (bl3) continue;
                        bl3 = true;
                        list.add(fileObject);
                        continue;
                    }
                    fileObject = fileObject2;
                }
            }
            FileObject fileObject3 = null;
            if (fileObject != null && (fileObject3 = fileObject.getFileObject(string)) == null) {
                fileObject3 = PanelUtil.copyFile(fileObject, TEMPLATES_PATH, XSLT_SERVICE, string, XSL);
                if (!bl3) {
                    list.add(fileObject3);
                }
                SoaUiUtil.fixEncoding((DataObject)DataObject.find((FileObject)fileObject3), (FileObject)fileObject);
            }
            return fileObject3;
        }

        private void configureTMapModel(TransformationUseCase transformationUseCase, Project project, TemplateWizard templateWizard) throws IOException {
            TMapModel tMapModel;
            assert (transformationUseCase != null && project != null && templateWizard != null);
            FileObject fileObject = this.getTMapFo(project);
            TMapModel tMapModel2 = tMapModel = fileObject == null ? null : Util.getTMapModel((FileObject)fileObject);
            if (tMapModel == null || !Model.State.VALID.equals((Object)tMapModel.getState())) {
                throw new IllegalStateException("" + tMapModel.getState());
            }
            switch (transformationUseCase) {
                case REQUEST_REPLY: {
                    this.configureRequestReply(tMapModel, templateWizard);
                    break;
                }
                case FILTER_ONE_WAY: {
                    this.configureFilterOneWay(tMapModel, templateWizard);
                    break;
                }
                case FILTER_REQUEST_REPLY: {
                    this.configureFilterRequestReply(tMapModel, templateWizard);
                }
            }
            this.saveConfiguredModel(fileObject);
        }

        private void saveConfiguredModel(FileObject fileObject) throws IOException {
            if (fileObject == null) {
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && dataObject.isModified()) {
                SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                assert (saveCookie != null);
                saveCookie.save();
            }
        }

        private FileObject getTMapFo(Project project) {
            FileObject fileObject = Util.getTMapFo((Project)project);
            if (fileObject == null) {
                fileObject = Util.createDefaultTransformmap((Project)project);
            }
            return fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureRequestReply(TMapModel tMapModel, TemplateWizard templateWizard) {
            assert (tMapModel != null && templateWizard != null);
            try {
                tMapModel.startTransaction();
                TMapComponentFactory tMapComponentFactory = tMapModel.getFactory();
                org.netbeans.modules.xslt.tmap.model.api.Operation operation = this.setOperation(tMapModel, templateWizard, tMapComponentFactory);
                Transform transform = null;
                if (operation != null) {
                    transform = this.createTransform(tMapComponentFactory, (String)templateWizard.getProperty("input.file"), (VariableDeclarator)operation);
                }
                if (transform != null) {
                    operation.addTransform(transform);
                }
            }
            finally {
                tMapModel.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureFilterOneWay(TMapModel tMapModel, TemplateWizard templateWizard) {
            assert (tMapModel != null && templateWizard != null);
            try {
                Object object;
                tMapModel.startTransaction();
                TMapComponentFactory tMapComponentFactory = tMapModel.getFactory();
                org.netbeans.modules.xslt.tmap.model.api.Operation operation = this.setOperation(tMapModel, templateWizard, tMapComponentFactory);
                Transform transform = null;
                if (operation != null) {
                    transform = this.createTransform(tMapComponentFactory, (String)templateWizard.getProperty("input.file"), (VariableDeclarator)operation);
                }
                Invoke invoke = null;
                if (operation != null) {
                    invoke = this.createInvoke(operation, templateWizard, tMapComponentFactory);
                }
                if (transform != null) {
                    operation.addTransform(transform);
                }
                if (invoke != null) {
                    operation.addInvoke(invoke);
                }
                if (operation != null) {
                    Object object2;
                    object = operation.getTransforms();
                    if (object != null) {
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            Transform transform2 = (Transform)object2.next();
                            if (!transform2.equals(transform)) continue;
                            transform = transform2;
                            break;
                        }
                    }
                    Invoke invoke2 = invoke = (object2 = operation.getInvokes()) == null || object2.size() < 1 ? invoke : (Invoke)object2.get(object2.size() - 1);
                }
                if (transform != null && (object = this.getTMapVarRef(invoke.getInputVariable())) != null) {
                    transform.setResult((String)object);
                }
            }
            finally {
                tMapModel.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void configureFilterRequestReply(TMapModel tMapModel, TemplateWizard templateWizard) {
            assert (tMapModel != null && templateWizard != null);
            try {
                String string;
                tMapModel.startTransaction();
                TMapComponentFactory tMapComponentFactory = tMapModel.getFactory();
                org.netbeans.modules.xslt.tmap.model.api.Operation operation = this.setOperation(tMapModel, templateWizard, tMapComponentFactory);
                if (operation == null) {
                    return;
                }
                Invoke invoke = null;
                String string2 = this.getVariableName(Iterator.INPUT_INVOKE_VARIABLE_PREFIX, this.getVariableNumber(operation, Iterator.INPUT_INVOKE_VARIABLE_PREFIX, 1));
                String string3 = this.getVariableName(Iterator.OUTPUT_INVOKE_VARIABLE_PREFIX, this.getVariableNumber(operation, Iterator.OUTPUT_INVOKE_VARIABLE_PREFIX, 1));
                Transform transform = null;
                transform = this.createTransform(tMapComponentFactory, (String)templateWizard.getProperty("input.file"), (VariableDeclarator)operation);
                invoke = this.createInvoke(operation, string2, string3, templateWizard, tMapComponentFactory);
                Transform transform2 = null;
                transform2 = this.createTransform(tMapComponentFactory, (String)templateWizard.getProperty("output.file"), (VariableDeclarator)operation);
                if (transform != null) {
                    operation.addTransform(transform);
                }
                if (invoke != null) {
                    operation.addInvoke(invoke);
                }
                if (transform2 != null) {
                    operation.addTransform(transform2);
                    string = this.getTMapVarRef(invoke.getOutputVariable());
                    if (string != null) {
                        transform2.setSource(string);
                    }
                }
                if (transform != null && (string = this.getTMapVarRef(invoke.getInputVariable())) != null) {
                    transform.setResult(string);
                }
            }
            finally {
                tMapModel.endTransaction();
            }
        }

        private int getVariableNumber(org.netbeans.modules.xslt.tmap.model.api.Operation operation, String string, int n) {
            if (operation == null || string == null) {
                return n;
            }
            List list = operation.getVariables();
            if (list == null || list.size() < 1) {
                // empty if block
            }
            int n2 = n;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Variable variable : list) {
                String string2 = variable == null ? null : variable.getName();
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            while (arrayList.contains(string + n2)) {
                ++n2;
            }
            return n2;
        }

        private String getVariableName(String string, int n) {
            string = string == null ? Iterator.DEFAULT_VARIABLE_PREFIX : string;
            return string + n;
        }

        private Service getTMapService(TMapModel tMapModel, PartnerLinkType partnerLinkType, Role role) {
            if (tMapModel == null || partnerLinkType == null || role == null) {
                return null;
            }
            Service service = null;
            TransformMap transformMap = tMapModel.getTransformMap();
            if (transformMap == null) {
                return service;
            }
            List list = transformMap.getServices();
            if (list == null || list.size() < 1) {
                return service;
            }
            for (Service service2 : list) {
                WSDLReference wSDLReference = service2.getPartnerLinkType();
                WSDLReference wSDLReference2 = service2.getRole();
                if (wSDLReference2 == null || wSDLReference == null || !partnerLinkType.equals(wSDLReference.get()) || !role.equals(wSDLReference2.get())) continue;
                service = service2;
                break;
            }
            return service;
        }

        private org.netbeans.modules.xslt.tmap.model.api.Operation getTMapOperation(Service service, Operation operation) {
            org.netbeans.modules.xslt.tmap.model.api.Operation operation2 = null;
            if (service == null) {
                return operation2;
            }
            List list = service.getOperations();
            if (list == null || list.size() < 1) {
                return operation2;
            }
            for (org.netbeans.modules.xslt.tmap.model.api.Operation operation3 : list) {
                Reference reference = operation3.getOperation();
                if (reference == null || !operation.equals(reference.get())) continue;
                operation2 = operation3;
                break;
            }
            return operation2;
        }

        private org.netbeans.modules.xslt.tmap.model.api.Operation getTMapOperation(TMapModel tMapModel, PartnerLinkType partnerLinkType, Role role, Operation operation) {
            return this.getTMapOperation(this.getTMapService(tMapModel, partnerLinkType, role), operation);
        }

        private org.netbeans.modules.xslt.tmap.model.api.Operation setOperation(TMapModel tMapModel, TemplateWizard templateWizard, TMapComponentFactory tMapComponentFactory) {
            Role role;
            assert (tMapModel != null && templateWizard != null && tMapComponentFactory != null);
            String string = (String)templateWizard.getProperty("input.file");
            Operation operation = (Operation)templateWizard.getProperty("input.operation");
            Panel.PartnerRolePort partnerRolePort = (Panel.PartnerRolePort)templateWizard.getProperty("input.partner.role.port");
            PartnerLinkType partnerLinkType = partnerRolePort == null ? null : partnerRolePort.getPartnerLinkType();
            Role role2 = role = partnerRolePort == null ? null : partnerRolePort.getRole();
            if (partnerLinkType == null || role == null || operation == null) {
                return null;
            }
            Service service = this.getTMapService(tMapModel, partnerLinkType, role);
            if (service == null) {
                service = this.createTMapService(tMapComponentFactory, tMapModel, partnerLinkType, role);
            }
            if (service == null) {
                return null;
            }
            org.netbeans.modules.xslt.tmap.model.api.Operation operation2 = null;
            operation2 = this.getTMapOperation(service, operation);
            if (operation2 == null) {
                operation2 = tMapComponentFactory.createOperation();
                operation2.setOperation(operation2.createWSDLReference((ReferenceableWSDLComponent)operation, Operation.class));
                service.addOperation(operation2);
                operation2.setInputVariableName(this.getVariableName(Iterator.INPUT_OPERATION_VARIABLE_PREFIX, 1));
                operation2.setOutputVariableName(this.getVariableName(Iterator.OUTPUT_OPERATION_VARIABLE_PREFIX, 1));
            }
            return operation2;
        }

        private Service createTMapService(TMapComponentFactory tMapComponentFactory, TMapModel tMapModel, PartnerLinkType partnerLinkType, Role role) {
            assert (tMapComponentFactory != null && tMapModel != null && partnerLinkType != null && role != null);
            Service service = null;
            TransformMap transformMap = tMapModel.getTransformMap();
            if (transformMap == null) {
                transformMap = tMapComponentFactory.createTransformMap();
                tMapModel.addChildComponent(null, (Component)transformMap, -1);
            }
            if (transformMap == null) {
                return null;
            }
            service = tMapComponentFactory.createService();
            service.setPartnerLinkType(service.createWSDLReference((ReferenceableWSDLComponent)partnerLinkType, PartnerLinkType.class));
            service.setRole(service.createWSDLReference((ReferenceableWSDLComponent)role, Role.class));
            transformMap.addService(service);
            return service;
        }

        private Transform createTransform(TMapComponentFactory tMapComponentFactory, String string, Variable variable, Variable variable2) {
            if (variable == null || variable2 == null) {
                return null;
            }
            Transform transform = tMapComponentFactory.createTransform();
            if (string != null && !"".equals(string)) {
                transform.setFile(string);
            }
            String string2 = this.getFirstPartName(variable);
            transform.setSource(this.getTMapVarRef(variable, string2));
            String string3 = this.getFirstPartName(variable2);
            transform.setResult(this.getTMapVarRef(variable2, string3));
            return transform;
        }

        private Transform createTransform(TMapComponentFactory tMapComponentFactory, String string, VariableDeclarator variableDeclarator) {
            if (variableDeclarator == null) {
                return null;
            }
            return this.createTransform(tMapComponentFactory, string, variableDeclarator.getInputVariable(), variableDeclarator.getOutputVariable());
        }

        private String getTMapVarRef(Variable variable) {
            String string = variable == null ? null : this.getFirstPartName(variable);
            return this.getTMapVarRef(variable, string);
        }

        private String getTMapVarRef(Variable variable, String string) {
            if (string == null || variable == null) {
                return null;
            }
            String string2 = variable.getName();
            return string2 == null ? null : VariableReferenceImpl.getVarRefString((String)string2, (String)string);
        }

        private String getFirstPartName(Reference<Message> reference) {
            String string = null;
            if (reference == null) {
                return string;
            }
            Message message = (Message)reference.get();
            Collection collection = null;
            if (message != null) {
                collection = message.getParts();
            }
            Part part = null;
            if (collection != null && collection.size() > 0) {
                java.util.Iterator iterator = collection.iterator();
                part = (Part)iterator.next();
            }
            if (part != null) {
                string = part.getName();
            }
            return string;
        }

        private String getFirstPartName(Variable variable) {
            if (variable == null) {
                return null;
            }
            return this.getFirstPartName((Reference<Message>)variable.getMessage());
        }

        private String getFirstPartName(OperationParameter operationParameter) {
            if (operationParameter == null) {
                return null;
            }
            return this.getFirstPartName((Reference<Message>)operationParameter.getMessage());
        }

        private Invoke createInvoke(org.netbeans.modules.xslt.tmap.model.api.Operation operation, TemplateWizard templateWizard, TMapComponentFactory tMapComponentFactory) {
            return this.createInvoke(operation, null, null, templateWizard, tMapComponentFactory);
        }

        private Invoke createInvoke(org.netbeans.modules.xslt.tmap.model.api.Operation operation, String string, String string2, TemplateWizard templateWizard, TMapComponentFactory tMapComponentFactory) {
            Role role;
            assert (operation != null && templateWizard != null && tMapComponentFactory != null);
            Invoke invoke = null;
            Operation operation2 = (Operation)templateWizard.getProperty("output.operation");
            Panel.PartnerRolePort partnerRolePort = (Panel.PartnerRolePort)templateWizard.getProperty("output.partner.role.port");
            PartnerLinkType partnerLinkType = partnerRolePort == null ? null : partnerRolePort.getPartnerLinkType();
            Role role2 = role = partnerRolePort == null ? null : partnerRolePort.getRole();
            if (partnerLinkType != null && role != null && operation2 != null) {
                invoke = tMapComponentFactory.createInvoke();
                invoke.setPartnerLinkType(invoke.createWSDLReference((ReferenceableWSDLComponent)partnerLinkType, PartnerLinkType.class));
                invoke.setRole(invoke.createWSDLReference((ReferenceableWSDLComponent)role, Role.class));
                invoke.setOperation(invoke.createWSDLReference((ReferenceableWSDLComponent)operation2, Operation.class));
                if (string == null || "".equals(string)) {
                    string = this.getVariableName(Iterator.INPUT_INVOKE_VARIABLE_PREFIX, this.getVariableNumber(operation, Iterator.INPUT_INVOKE_VARIABLE_PREFIX, 1));
                }
                if (string2 == null || "".equals(string2)) {
                    string2 = this.getVariableName(Iterator.OUTPUT_INVOKE_VARIABLE_PREFIX, this.getVariableNumber(operation, Iterator.OUTPUT_INVOKE_VARIABLE_PREFIX, 1));
                }
                invoke.setInputVariableName(string);
                invoke.setOutputVariableName(string2);
            }
            return invoke;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TransformationUseCase {
        REQUEST_REPLY,
        FILTER_ONE_WAY,
        FILTER_REQUEST_REPLY;

    }
}

