/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.HeaderPanel;
import org.netbeans.modules.websvc.saas.spi.ServiceData;
import org.openide.awt.HtmlBrowser;

public class ServiceDetailPanel
extends JTextPane {
    private JScrollPane scrollPane;
    private HeaderPanel header = new HeaderPanel();
    private JLabel title = this.header.getTitle();
    private ServiceData currentData;

    public ServiceDetailPanel() {
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray);
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(matteBorder, border);
        this.header.setBorder(compoundBorder);
        this.initHtmlKit();
        this.header.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (10 == keyEvent.getKeyCode() && ServiceDetailPanel.this.currentData != null) {
                    ServiceDetailPanel.this.currentData.setPackageName(ServiceDetailPanel.this.header.getPackageName());
                }
            }
        });
        this.header.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (ServiceDetailPanel.this.currentData != null) {
                    ServiceDetailPanel.this.currentData.setPackageName(ServiceDetailPanel.this.header.getPackageName());
                }
            }
        });
    }

    private void initHtmlKit() {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        if (styleSheet.getStyleSheets() == null) {
            StyleSheet styleSheet2 = new StyleSheet();
            Font font = new JList().getFont();
            int n = font.getSize();
            styleSheet2.addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet2.addStyleSheet(styleSheet);
            hTMLEditorKit.setStyleSheet(styleSheet2);
        }
        this.setEditorKit(hTMLEditorKit);
        this.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (HyperlinkEvent.EventType.ACTIVATED == hyperlinkEvent.getEventType()) {
                    assert (hyperlinkEvent.getURL() != null);
                    ServiceDetailPanel.showURL(hyperlinkEvent.getURL());
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.getScrollPane();
    }

    public boolean isEditable() {
        return false;
    }

    JScrollPane getScrollPane() {
        Container container;
        Container container2;
        if (this.scrollPane == null && (container2 = this.getParent()) instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            this.scrollPane = (JScrollPane)container;
        }
        return this.scrollPane;
    }

    void clear() {
        this.setCurrentService(null);
    }

    void setCurrentService(ServiceData serviceData) {
        if (this.currentData != null) {
            this.currentData.setPackageName(this.header.getPackageName());
        }
        this.currentData = serviceData;
        if (this.currentData != null) {
            this.getScrollPane().setColumnHeaderView(this.header);
            this.header.setPackageName(this.currentData.getPackageName());
            this.setTitle(this.currentData.getServiceName());
            this.setDetails();
        } else {
            this.setTitle("");
            this.header.setPackageName("");
            this.setText("");
        }
    }

    ServiceData getCurrentService() {
        return this.currentData;
    }

    String getPackageName() {
        this.currentData.setPackageName(this.header.getPackageName());
        return this.currentData.getPackageName();
    }

    public void setTitle(String string) {
        if (string != null) {
            this.title.setText("<html><h3>" + string + "</h3></html>");
        } else {
            this.title.setText("");
        }
    }

    private void setDetails() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.currentData != null) {
            String string = this.currentData.getUrl();
            String string2 = this.currentData.getInfoPage();
            String string3 = this.currentData.getPurchaseLink();
            stringBuilder.append("<b>Version: </b>" + this.currentData.getVersion() + "<br>");
            stringBuilder.append("<b>Provider: </b>" + this.currentData.getProviderName() + "<br>");
            stringBuilder.append("<h3>Description: </h3>" + this.currentData.getDescription() + "<br>");
            stringBuilder.append("<br>");
            stringBuilder.append("<b>WSDL Location: </b><br><a href=\"" + string + "\">" + string + "</a><br>");
            stringBuilder.append("<br>");
            stringBuilder.append("<b>Info Page: </b><br><a href=\"" + string2 + "\">" + string2 + "</a><br>");
            stringBuilder.append("<br>");
            stringBuilder.append("<b>Purchase Link: </b><br><a href=\"" + string3 + "\">" + string3 + "</a><br>");
        }
        this.setText(stringBuilder.toString());
        this.setCaretPosition(0);
    }

    public static void showURL(URL uRL) {
        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (uRLDisplayer != null) {
            uRLDisplayer.showURL(uRL);
        } else {
            Logger.global.log(Level.INFO, "No URLDisplayer found.");
        }
    }
}

