/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.services.strikeiron.ui;

import com.strikeiron.search.AUTHENTICATIONSTYLE;
import com.strikeiron.search.SORTBY;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.ServiceDetailPanel;
import org.netbeans.modules.websvc.saas.services.strikeiron.ui.ServiceTableModel;
import org.netbeans.modules.websvc.saas.spi.ServiceData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceData;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindServiceUI
extends JPanel {
    private ProgressHandle progressHandle;
    private JComponent progressComponent;
    private boolean jaxrpcWarned = false;
    private JButton bAdd;
    private JButton bCancel;
    private JButton addButton;
    private JButton bSearch;
    private JButton cancelButton;
    private JComboBox cbAuthenticationMode;
    private JComboBox cbSortBy;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel jlAuthenticationMode;
    private JLabel jlSortBy;
    private JLabel labelDescription;
    private JPanel progressContainerPanel;
    private JPanel searchPanel;
    private JTextPane serviceInfoPanel;
    private JTable serviceSelectionTable;
    private JPanel settingsPanel;
    private JSplitPane spTab;
    private JLabel statusMessage;
    private JTextField tfSearch;
    private JTabbedPane tpTabs;

    public FindServiceUI(JButton jButton, JButton jButton2) {
        this.bAdd = jButton;
        this.bCancel = jButton2;
        this.initComponents();
        this.cbAuthenticationMode.setSelectedItem((Object)this.getModel().getAuthenticationStyle());
        this.cbSortBy.setSelectedItem((Object)this.getModel().getSortBy());
        this.serviceSelectionTable.getColumnModel().getColumn(1).setMinWidth(220);
        this.serviceSelectionTable.getColumnModel().getColumn(0).setMinWidth(50);
        this.serviceSelectionTable.getColumnModel().getColumn(0).setResizable(false);
        this.bSearch.setEnabled(false);
        this.addButton.setEnabled(false);
        this.clearMessage();
        this.warnJaxRpc();
        this.addSearchListener();
        this.serviceSelectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = FindServiceUI.this.serviceSelectionTable.getSelectedRow();
                WsdlServiceData wsdlServiceData = n < 0 ? null : FindServiceUI.this.getModel().getService(n);
                FindServiceUI.this.getDetailPanel().setCurrentService((ServiceData)wsdlServiceData);
                if (wsdlServiceData != null && wsdlServiceData.isInRepository()) {
                    FindServiceUI.this.showMessageByKey("MSG_AlreadyExists", true);
                } else {
                    FindServiceUI.this.clearMessage();
                }
            }
        });
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public Set<? extends WsdlServiceData> getSelectedServices() {
        return this.getModel().getSelectedServices();
    }

    ServiceTableModel getModel() {
        return (ServiceTableModel)this.serviceSelectionTable.getModel();
    }

    private void addSearchListener() {
        this.getModel().addEventListener(new ServiceTableModel.SearchListener(){

            public void searchCompleted(ChangeEvent changeEvent) {
                FindServiceUI.this.stopProgress();
                FindServiceUI.this.setCursor(null);
                FindServiceUI.this.tfSearch.setEnabled(true);
            }

            public void serviceSelectionChanged(ChangeEvent changeEvent) {
                if (FindServiceUI.this.getSelectedServices().size() > 0) {
                    FindServiceUI.this.addButton.setEnabled(true);
                }
            }
        });
    }

    public void startProgress() {
        this.progressHandle = ProgressHandleFactory.createHandle(null, (Cancellable)new Cancellable(){

            public boolean cancel() {
                return FindServiceUI.this.getModel().cancelSearch();
            }
        });
        this.progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
        this.progressContainerPanel.add((Component)this.progressComponent, "Center");
        this.progressContainerPanel.setVisible(true);
        this.progressHandle.start();
        this.progressContainerPanel.revalidate();
        this.clearMessage();
    }

    public void stopProgress() {
        this.progressHandle.finish();
        this.progressContainerPanel.remove(this.progressComponent);
        this.progressContainerPanel.revalidate();
        this.progressContainerPanel.repaint();
        this.showMessage(this.getModel().getStatusMessage(), this.getModel().hasWarnsOrErrors());
    }

    private void initComponents() {
        this.labelDescription = new JLabel();
        this.tpTabs = new JTabbedPane();
        this.searchPanel = new JPanel();
        this.spTab = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.serviceSelectionTable = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.serviceInfoPanel = new ServiceDetailPanel();
        this.tfSearch = new JTextField();
        this.bSearch = new JButton();
        this.progressContainerPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.jlAuthenticationMode = new JLabel();
        this.jlSortBy = new JLabel();
        this.cbAuthenticationMode = new JComboBox();
        this.cbSortBy = new JComboBox();
        this.statusMessage = new JLabel();
        this.cancelButton = this.bCancel;
        this.addButton = this.bAdd;
        this.labelDescription.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.labelDescription.text"));
        this.tpTabs.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tpTabs.setOpaque(true);
        this.tpTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FindServiceUI.this.tpTabsStateChanged(changeEvent);
            }
        });
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(275);
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        this.serviceSelectionTable.setModel(new ServiceTableModel());
        this.jScrollPane1.setViewportView(this.serviceSelectionTable);
        this.spTab.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setViewportView(this.serviceInfoPanel);
        this.spTab.setRightComponent(this.jScrollPane2);
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                FindServiceUI.this.tfSearchKeyReleased(keyEvent);
            }

            public void keyTyped(KeyEvent keyEvent) {
                FindServiceUI.this.tfSearchonKeyTyped(keyEvent);
            }
        });
        this.bSearch.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.bSearch.text"));
        this.bSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindServiceUI.this.bSearchperformSearch(actionEvent);
            }
        });
        this.progressContainerPanel.setMinimumSize(new Dimension(20, 20));
        this.progressContainerPanel.setPreferredSize(new Dimension(20, 20));
        this.progressContainerPanel.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this.searchPanel);
        this.searchPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.tfSearch, -2, 216, -2).addPreferredGap(0).add((Component)this.bSearch).addPreferredGap(1).add((Component)this.progressContainerPanel, -1, 277, Short.MAX_VALUE)).add(2, (Component)this.spTab, -1, 580, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(4).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.bSearch, -2, 19, -2).add((Component)this.progressContainerPanel, -2, 15, -2)).addPreferredGap(0).add((Component)this.spTab, -1, 270, Short.MAX_VALUE).addContainerGap()));
        this.tpTabs.addTab(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.searchPanel.TabConstraints.tabTitle"), this.searchPanel);
        this.settingsPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FindServiceUI.this.settingsPanelMousePressed(mouseEvent);
            }
        });
        this.jlAuthenticationMode.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.jlAuthenticationMode.text"));
        this.jlSortBy.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.jlSortBy.text"));
        this.cbAuthenticationMode.setModel(new DefaultComboBoxModel<AUTHENTICATIONSTYLE>(AUTHENTICATIONSTYLE.values()));
        this.cbAuthenticationMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindServiceUI.this.cbAuthenticationModeActionPerformed(actionEvent);
            }
        });
        this.cbSortBy.setModel(new DefaultComboBoxModel<SORTBY>(SORTBY.values()));
        this.cbSortBy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindServiceUI.this.cbSortByActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.settingsPanel);
        this.settingsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jlAuthenticationMode).add((Component)this.jlSortBy)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.cbSortBy, 0, 467, Short.MAX_VALUE).add((Component)this.cbAuthenticationMode, 0, 467, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(16, 16, 16).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jlAuthenticationMode).add((Component)this.cbAuthenticationMode, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jlSortBy).add((Component)this.cbSortBy, -2, -1, -2)).addContainerGap(249, Short.MAX_VALUE)));
        this.tpTabs.addTab(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.settingsPanel.TabConstraints.tabTitle"), this.settingsPanel);
        this.statusMessage.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/websvc/saas/services/strikeiron/resources/warning.png")));
        this.statusMessage.setText("");
        this.cancelButton.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.cancelButton.text"));
        this.cancelButton.setVerticalAlignment(3);
        this.addButton.setText(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.addButton.text"));
        this.addButton.setActionCommand(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.addButton.actionCommand"));
        this.addButton.setLabel(NbBundle.getMessage(FindServiceUI.class, (String)"FindServiceUI.addButton.label"));
        this.addButton.setVerticalAlignment(3);
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.labelDescription, -1, 611, Short.MAX_VALUE).add((Component)this.tpTabs, -1, 611, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.statusMessage, -1, 449, Short.MAX_VALUE).add(16, 16, 16).add((Component)this.addButton, -2, 67, -2).addPreferredGap(1).add((Component)this.cancelButton))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.labelDescription).addPreferredGap(0).add((Component)this.tpTabs, -1, 348, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.statusMessage, -1, 25, Short.MAX_VALUE).add((Component)this.cancelButton).add((Component)this.addButton)).addContainerGap()));
    }

    private void tfSearchKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.startSearch();
        } else {
            this.bSearch.setEnabled(this.tfSearch.getText().length() > 0);
        }
    }

    private void tfSearchonKeyTyped(KeyEvent keyEvent) {
        this.bSearch.setEnabled(this.tfSearch.getText().length() > 0);
    }

    private void bSearchperformSearch(ActionEvent actionEvent) {
        this.startSearch();
    }

    private void cbAuthenticationModeActionPerformed(ActionEvent actionEvent) {
        this.getModel().setAuthenticationStyle((AUTHENTICATIONSTYLE)((Object)this.cbAuthenticationMode.getSelectedItem()));
    }

    private void cbSortByActionPerformed(ActionEvent actionEvent) {
        this.getModel().setSortBy((SORTBY)((Object)this.cbSortBy.getSelectedItem()));
    }

    private void settingsPanelMousePressed(MouseEvent mouseEvent) {
    }

    private void tpTabsStateChanged(ChangeEvent changeEvent) {
        if (this.settingsPanel.isShowing()) {
            this.addButton.setEnabled(false);
            this.clearMessage();
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private ServiceDetailPanel getDetailPanel() {
        return (ServiceDetailPanel)this.serviceInfoPanel;
    }

    private void startSearch() {
        this.getDetailPanel().clear();
        this.startProgress();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.tfSearch.setEnabled(false);
        this.getModel().doSearch(this.tfSearch.getText());
    }

    private void clearMessage() {
        this.showMessage(null, false);
    }

    private void showMessageByKey(String string, boolean bl) {
        String string2 = string == null ? "" : NbBundle.getMessage(FindServiceUI.class, (String)string);
        this.showMessage(string2, bl);
    }

    private void showMessage(String string, boolean bl) {
        if (bl) {
            this.statusMessage.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/websvc/saas/services/strikeiron/resources/warning.png")));
        } else {
            this.statusMessage.setIcon(null);
        }
        if (string != null) {
            this.statusMessage.setText("<html>" + string + "</html>");
        } else {
            this.statusMessage.setText("");
        }
    }

    private void warnJaxRpc() {
        if (!this.jaxrpcWarned) {
            this.jaxrpcWarned = true;
            if (!WsdlUtil.isJAXRPCAvailable()) {
                this.showMessageByKey("WARNING_JAXRPC_UNAVAILABLE", true);
            }
        }
    }
}

