/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.add;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.WrapperUtils;
import org.netbeans.lib.cvsclient.command.add.AddBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.ArgumentxRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;
import org.netbeans.lib.cvsclient.request.IsModifiedRequest;
import org.netbeans.lib.cvsclient.request.KoptRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.StickyRequest;
import org.netbeans.lib.cvsclient.util.SimpleStringPattern;

public class AddCommand
extends BuildableCommand {
    private static final String DIR_ADDED = " added to the repository";
    private static final String DIRECTORY = "Directory ";
    private List requests;
    private final List argumentRequests = new LinkedList();
    private final List newDirList = new LinkedList();
    private ClientServices clientServices;
    private File[] files;
    private String message;
    private KeywordSubstitutionOptions keywordSubst;
    private Map wrapperMap;
    private HashMap dir2WrapperMap = new HashMap(16);
    private static final Map EMPTYWRAPPER = new HashMap(1);

    public AddCommand() {
        this.resetCVSCommand();
    }

    public void setFiles(File[] fileArray) {
        this.files = fileArray;
        if (fileArray == null) {
            return;
        }
        this.files = new File[fileArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = fileArray.length;
        for (int i = 0; i < n3; ++i) {
            File file = fileArray[i];
            if (file.isDirectory()) {
                this.files[n] = file;
                ++n;
                continue;
            }
            this.files[n3 - (1 + n2)] = file;
            ++n2;
        }
    }

    public File[] getFiles() {
        return this.files;
    }

    public File getFileEndingWith(String string) {
        String string2 = string.replace('\\', '/');
        String string3 = this.getLocalDirectory().replace('\\', '/');
        int n = 0;
        for (n = 0; n < this.files.length; ++n) {
            String string4 = this.files[n].getAbsolutePath();
            String string5 = this.files[n].getParentFile().getAbsolutePath().replace('\\', '/');
            if ((!(string4 = string4.replace('\\', '/')).endsWith(string2) || string2.indexOf(47) < 0) && (!this.files[n].getName().equals(string2) || !string5.equals(string3))) continue;
            return this.files[n];
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubst = keywordSubstitutionOptions;
    }

    protected void addRequests(File file) throws IOException, CommandException {
        if (file.isDirectory()) {
            this.addRequestsForDirectory(file, false);
        } else {
            this.addRequestsForFile(file);
        }
    }

    private void addRequestsForDirectory(File file, boolean bl) throws IOException {
        String string;
        String string2;
        String string3;
        String string4;
        File file2 = file.getParentFile();
        String string5 = string4 = bl ? this.getRelativeToLocalPathInUnixStyle(file) : this.getRelativeToLocalPathInUnixStyle(file2);
        if (string4.equals(".")) {
            string3 = file.getName();
        } else {
            string3 = string4 + "/" + file.getName();
            this.addRequestsForDirectory(file2, true);
        }
        if (bl) {
            string3 = string4;
        }
        if (bl) {
            string2 = this.clientServices.getRepositoryForDirectory(file.getAbsolutePath());
            string = this.clientServices.getStickyTagForDirectory(file);
        } else {
            string2 = this.clientServices.getRepositoryForDirectory(file2.getAbsolutePath());
            string2 = string2.endsWith(".") ? string2.substring(0, string2.length() - 1) + file.getName() : string2 + "/" + file.getName();
            string = this.clientServices.getStickyTagForDirectory(file2);
        }
        this.requests.add(new DirectoryRequest(string3, string2));
        if (string != null) {
            this.requests.add(new StickyRequest(string));
        }
        if (!bl) {
            this.argumentRequests.add(new ArgumentRequest(string3));
            this.newDirList.add(new Paths(string3, string2));
        }
    }

    protected void addRequestsForFile(File file) throws IOException, CommandException {
        Entry entry;
        File file2 = file.getParentFile();
        String string = this.getRelativeToLocalPathInUnixStyle(file2);
        String string2 = this.clientServices.getRepositoryForDirectory(file2.getAbsolutePath());
        this.requests.add(new DirectoryRequest(string, string2));
        String string3 = this.clientServices.getStickyTagForDirectory(file2);
        if (string3 != null) {
            this.requests.add(new StickyRequest(string3));
        }
        if ((entry = this.clientServices.getEntry(file)) != null) {
            this.requests.add(new EntryRequest(entry));
        } else {
            boolean bl;
            HashMap hashMap = (HashMap)this.dir2WrapperMap.get(string);
            if (hashMap == null) {
                File file3 = new File(file2, ".cvswrappers");
                if (file3.exists()) {
                    hashMap = new HashMap(5);
                    WrapperUtils.readWrappersFromFile(file3, hashMap);
                } else {
                    hashMap = EMPTYWRAPPER;
                }
                this.dir2WrapperMap.put(string, hashMap);
            }
            if (bl = this.isBinary(this.clientServices, file.getName(), hashMap)) {
                this.requests.add(new KoptRequest("-kb"));
            }
            this.requests.add(new IsModifiedRequest(file));
        }
        if (string.equals(".")) {
            this.argumentRequests.add(new ArgumentRequest(file.getName(), true));
        } else {
            this.argumentRequests.add(new ArgumentRequest(string + "/" + file.getName()));
        }
    }

    private boolean isBinary(ClientServices clientServices, String string, Map map) throws CommandException {
        SimpleStringPattern simpleStringPattern;
        KeywordSubstitutionOptions keywordSubstitutionOptions = this.getKeywordSubst();
        if (keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY) {
            return true;
        }
        boolean bl = false;
        if (this.wrapperMap == null) {
            this.wrapperMap = WrapperUtils.mergeWrapperMap(clientServices);
        }
        Iterator iterator = this.wrapperMap.keySet().iterator();
        while (iterator.hasNext()) {
            simpleStringPattern = (SimpleStringPattern)iterator.next();
            if (!simpleStringPattern.doesMatch(string)) continue;
            keywordSubstitutionOptions = (KeywordSubstitutionOptions)this.wrapperMap.get(simpleStringPattern);
            bl = true;
            break;
        }
        if (!bl && map != null && map != EMPTYWRAPPER) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                simpleStringPattern = (SimpleStringPattern)iterator.next();
                if (!simpleStringPattern.doesMatch(string)) continue;
                keywordSubstitutionOptions = (KeywordSubstitutionOptions)map.get(simpleStringPattern);
                bl = true;
                break;
            }
        }
        return keywordSubstitutionOptions == KeywordSubstitutionOptions.BINARY;
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        String string;
        if (this.files == null || this.files.length == 0) {
            throw new CommandException("No files have been specified for adding.", CommandException.getLocalMessage("AddCommand.noFilesSpecified", null));
        }
        clientServices.ensureConnection();
        this.clientServices = clientServices;
        this.setLocalDirectory(clientServices.getLocalPath());
        String string2 = clientServices.getLocalPath();
        File file = new File(string2, "CVS");
        if (!file.isDirectory()) {
            MessageEvent messageEvent = new MessageEvent(this, "cvs [add aborted]: there is no version here; do 'cvs checkout' first", true);
            this.messageSent(messageEvent);
            eventManager.fireCVSEvent(messageEvent);
            return;
        }
        this.newDirList.clear();
        super.execute(clientServices, eventManager);
        this.requests = new LinkedList();
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        if ((string = this.getMessage()) != null) {
            string = string.trim();
        }
        if (string != null && string.length() > 0) {
            this.addMessageRequest(string);
        }
        if (this.getKeywordSubst() != null && !this.getKeywordSubst().equals("")) {
            this.requests.add(new ArgumentRequest("-k" + this.getKeywordSubst()));
        }
        try {
            for (int i = 0; i < this.files.length; ++i) {
                this.addRequests(this.files[i]);
            }
            this.requests.add(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
            this.requests.addAll(this.argumentRequests);
            this.argumentRequests.clear();
            this.requests.add(CommandRequest.ADD);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    private void addMessageRequest(String string) {
        this.requests.add(new ArgumentRequest("-m"));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                this.requests.add(new ArgumentRequest(stringTokenizer.nextToken()));
                bl = false;
                continue;
            }
            this.requests.add(new ArgumentxRequest(stringTokenizer.nextToken()));
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("add ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i].getName());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public Builder createBuilder(EventManager eventManager) {
        return new AddBuilder(eventManager, this);
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'm') {
            this.setMessage(string);
        } else if (c == 'k') {
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string);
            this.setKeywordSubst(keywordSubstitutionOptions);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "m:k:";
    }

    public void messageSent(MessageEvent messageEvent) {
        String string = messageEvent.getMessage();
        if (string.endsWith(DIR_ADDED)) {
            string = string.substring(DIRECTORY.length(), string.indexOf(DIR_ADDED)).trim();
            this.createCvsFiles(string);
        }
        super.messageSent(messageEvent);
    }

    private void createCvsFiles(String string) {
        String string2 = string;
        String string3 = string2;
        if (string3.lastIndexOf(47) >= 0) {
            string3 = string3.substring(string3.lastIndexOf(47) + 1, string3.length());
        }
        if (this.newDirList.size() == 0) {
            System.err.println("JavaCVS: Bug in AddCommand|createCvsFiles");
            System.err.println("         newDirInRepository = " + string);
            return;
        }
        Paths paths = null;
        Object object = this.newDirList.iterator();
        while (object.hasNext()) {
            paths = (Paths)object.next();
            if (!paths.getRepositoryPath().equals(string)) continue;
            object.remove();
            break;
        }
        object = paths.getPartPath();
        String string4 = paths.getRepositoryPath();
        string2 = paths.getRepositoryPath();
        String string5 = string4;
        if (string4.lastIndexOf(47) >= 0) {
            string5 = string4.substring(string4.lastIndexOf(47) + 1, string4.length());
        }
        if (!string5.equalsIgnoreCase(string3)) {
            System.err.println("JavaCVS: Bug in AddCommand|createCvsFiles");
            System.err.println("         newDirInRepository = " + string);
            System.err.println("         tempDirName = " + string5);
            System.err.println("         dirName = " + string3);
            return;
        }
        try {
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            this.clientServices.updateAdminData((String)object, string2, null);
            this.createCvsTagFile((String)object, string2);
        }
        catch (IOException iOException) {
            System.err.println("TODO: couldn't create/update Cvs admin files");
        }
    }

    private void createCvsTagFile(String string, String string2) throws IOException {
        File file = new File(this.getLocalDirectory(), string);
        File file2 = file.getParentFile();
        String string3 = this.clientServices.getStickyTagForDirectory(file2);
        if (string3 != null) {
            File file3 = new File(file, "CVS/Tag");
            file3.createNewFile();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file3)));
            printWriter.println(string3);
            printWriter.close();
        }
    }

    public void resetCVSCommand() {
        this.setMessage(null);
        this.setKeywordSubst(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMessage() != null) {
            stringBuffer.append("-m \"");
            stringBuffer.append(this.getMessage());
            stringBuffer.append("\" ");
        }
        if (this.getKeywordSubst() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubst().toString());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static class Paths {
        private final String partPath;
        private final String repositoryPath;

        public Paths(String string, String string2) {
            this.partPath = string;
            this.repositoryPath = string2;
        }

        public String getPartPath() {
            return this.partPath;
        }

        public String getRepositoryPath() {
            return this.repositoryPath;
        }
    }
}

