/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.palette.codeclips;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.netbeans.modules.visualweb.palette.codeclips.ActiveEditorDropCodeClipProvider;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipHandler;
import org.netbeans.modules.visualweb.palette.codeclips.CodeClipItemNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CodeClipEnvironmentProvider
implements Environment.Provider {
    private static CodeClipEnvironmentProvider createProvider() {
        return new CodeClipEnvironmentProvider();
    }

    private CodeClipEnvironmentProvider() {
    }

    public Lookup getEnvironment(DataObject dataObject) {
        CodeClipNodeFactory codeClipNodeFactory = new CodeClipNodeFactory((XMLDataObject)dataObject);
        return codeClipNodeFactory.getLookup();
    }

    private static class CodeClipNodeFactory
    implements InstanceContent.Convertor {
        private XMLDataObject xmlDataObject = null;
        private Lookup lookup = null;
        Reference<CodeClipItemNode> refNode = new WeakReference<Object>(null);

        CodeClipNodeFactory(XMLDataObject xMLDataObject) {
            this.xmlDataObject = xMLDataObject;
            InstanceContent instanceContent = new InstanceContent();
            instanceContent.add(Node.class, (InstanceContent.Convertor)this);
            this.lookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
        }

        Lookup getLookup() {
            return this.lookup;
        }

        public Class type(Object object) {
            return (Class)object;
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return ((Class)object).getName();
        }

        public Object convert(Object object) {
            CodeClipItemNode codeClipItemNode = null;
            if (object == Node.class) {
                try {
                    codeClipItemNode = this.getInstance();
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            return codeClipItemNode;
        }

        public synchronized CodeClipItemNode getInstance() {
            CodeClipItemNode codeClipItemNode = this.refNode.get();
            if (codeClipItemNode != null) {
                return codeClipItemNode;
            }
            FileObject fileObject = this.xmlDataObject.getPrimaryFile();
            if (fileObject.getSize() == 0L) {
                return null;
            }
            CodeClipHandler codeClipHandler = new CodeClipHandler();
            try {
                XMLReader xMLReader = XMLUtil.createXMLReader((boolean)true);
                xMLReader.setContentHandler(codeClipHandler);
                xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
                String string = this.xmlDataObject.getPrimaryFile().getURL().toExternalForm();
                InputStream inputStream = this.xmlDataObject.getPrimaryFile().getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
                InputSource inputSource = new InputSource(inputStreamReader);
                inputSource.setSystemId(string);
                xMLReader.parse(inputSource);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            codeClipItemNode = this.createPaletteItemNode(codeClipHandler);
            this.refNode = new WeakReference<CodeClipItemNode>(codeClipItemNode);
            return codeClipItemNode;
        }

        private CodeClipItemNode createPaletteItemNode(CodeClipHandler codeClipHandler) {
            Object object;
            String string = this.xmlDataObject.getName();
            InstanceContent instanceContent = new InstanceContent();
            if (codeClipHandler.getBody() != null) {
                object = new ArrayList<String>(2);
                object.add(0, codeClipHandler.getBundleName());
                object.add(1, codeClipHandler.getBody());
                object.add(2, codeClipHandler.getDisplayNameKey());
                instanceContent.add(object, (InstanceContent.Convertor)ActiveEditorDropCodeClipProvider.getInstance());
            }
            object = new CodeClipItemNode(new DataNode((DataObject)this.xmlDataObject, Children.LEAF), string, codeClipHandler.getBundleName(), codeClipHandler.getDisplayNameKey(), codeClipHandler.getTooltipKey(), codeClipHandler.getIcon16URL(), codeClipHandler.getIcon32URL(), codeClipHandler.getBody(), instanceContent);
            return object;
        }
    }
}

