/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion;

import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionQuery
extends AsyncCompletionQuery {
    private JTextComponent component;
    private FileObject primaryFile;
    private CompletionContextImpl context;

    public CompletionQuery(FileObject fileObject) {
        this.primaryFile = fileObject;
    }

    protected void prepareQuery(JTextComponent jTextComponent) {
        this.component = jTextComponent;
    }

    protected void query(CompletionResultSet completionResultSet, Document document, int n) {
        if (CompletionUtil.isDTDBasedDocument(document)) {
            completionResultSet.finish();
            return;
        }
        List<CompletionResultItem> list = this.getCompletionItems(document, n);
        if (list != null) {
            completionResultSet.addAllItems(list);
        }
        completionResultSet.finish();
    }

    List<CompletionResultItem> getCompletionItems(Document document, int n) {
        List<CompletionResultItem> list = null;
        XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
        this.context = new CompletionContextImpl(this.primaryFile, xMLSyntaxSupport, n);
        if (!this.context.initModels() || !this.context.initContext()) {
            return null;
        }
        switch (this.context.getCompletionType()) {
            case COMPLETION_TYPE_ELEMENT: {
                list = CompletionUtil.getElements(this.context);
                break;
            }
            case COMPLETION_TYPE_ATTRIBUTE: {
                list = CompletionUtil.getAttributes(this.context);
                break;
            }
            case COMPLETION_TYPE_VALUE: {
                list = CompletionUtil.getElementValues(this.context);
                break;
            }
            case COMPLETION_TYPE_ENTITY: {
                break;
            }
            case COMPLETION_TYPE_NOTATION: {
                break;
            }
        }
        return list;
    }
}

