/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.InfoPanel;
import org.netbeans.modules.i18n.PropertyPanel;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaPropertyPanel;
import org.netbeans.modules.i18n.java.JavaReplacePanel;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.netbeans.modules.i18n.regexp.ParseException;
import org.netbeans.modules.i18n.regexp.Translator;
import org.netbeans.modules.properties.UtilConvert;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaI18nSupport
extends I18nSupport {
    protected Set<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
    protected String identifier;
    protected boolean generateField;
    protected String initFormat = I18nUtil.getOptions().getInitJavaCode();
    private static final String octalDigitChars = "01234567";
    private static final String hexaDigitChars = "0123456789abcdefABCDEF";

    public JavaI18nSupport(DataObject dataObject) {
        super(dataObject);
    }

    @Override
    protected I18nSupport.I18nFinder createFinder() {
        return new JavaI18nFinder(this.document);
    }

    @Override
    protected I18nSupport.I18nReplacer createReplacer() {
        return new JavaI18nReplacer();
    }

    @Override
    protected ResourceHolder createResourceHolder() {
        return new JavaResourceHolder();
    }

    @Override
    public I18nString getDefaultI18nString(HardCodedString hardCodedString) {
        Object object;
        JavaI18nString javaI18nString = new JavaI18nString(this);
        ResourceHolder resourceHolder = javaI18nString.getSupport().getResourceHolder();
        if (resourceHolder.getResource() == null && (object = I18nUtil.getOptions().getLastResource2()) != null) {
            FileObject fileObject = this.sourceDataObject.getPrimaryFile();
            FileObject fileObject2 = object.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            if (classPath.getResourceName(fileObject2) != null) {
                resourceHolder.setResource((DataObject)object);
            }
        }
        if (hardCodedString == null) {
            return javaI18nString;
        }
        javaI18nString.setComment("");
        object = JavaI18nSupport.decodeUnicodeSeq(hardCodedString.getText());
        javaI18nString.setKey(((String)object).replace(' ', '_'));
        javaI18nString.setValue((String)object);
        if (this.isGenerateField() && javaI18nString.getReplaceFormat().indexOf("{identifier}") == -1) {
            javaI18nString.setReplaceFormat(I18nUtil.getReplaceFormatItems().get(0));
        }
        return javaI18nString;
    }

    private static String decodeUnicodeSeq(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        char[] cArray2 = new char[3];
        int n4 = 0;
        int n5 = 0;
        block12: while (n5 < cArray.length) {
            n = cArray[n5++];
            switch (n2) {
                case 0: {
                    if (n == 92) {
                        n2 = 1;
                        continue block12;
                    }
                    stringBuilder.append((char)n);
                    continue block12;
                }
                case 1: {
                    if (n == 117) {
                        n2 = 2;
                        continue block12;
                    }
                    if (n >= 48 && n <= 51) {
                        n3 = n - 48;
                        assert (n3 >= 0 && n3 <= 3);
                        n4 = 1;
                        n2 = 3;
                        continue block12;
                    }
                    stringBuilder.append('\\').append((char)n);
                    n2 = 0;
                    continue block12;
                }
                case 3: {
                    int n6 = octalDigitChars.indexOf(n);
                    if (n6 >= 0) {
                        n3 = n3 << 3 | n6;
                        ++n4;
                    } else {
                        --n5;
                    }
                    if (n6 >= 0 && n4 != 3) continue block12;
                    JavaI18nSupport.appendChar(stringBuilder, n3);
                    n2 = 0;
                    n4 = 0;
                    n3 = 0;
                    continue block12;
                }
                case 2: {
                    int n6 = hexaDigitChars.indexOf(n);
                    if (n6 >= 0) {
                        if (n6 > 15) {
                            n6 -= 6;
                        }
                        assert (n6 <= 15);
                        n3 = n3 << 4 | n6;
                        if (++n4 == 4) {
                            JavaI18nSupport.appendChar(stringBuilder, n3);
                            n2 = 0;
                        } else {
                            cArray2[n4 - 1] = n;
                        }
                    } else if (n != 117) {
                        stringBuilder.append('\\');
                        stringBuilder.append('u');
                        for (int i = 0; i < n4; ++i) {
                            stringBuilder.append(cArray2[i]);
                        }
                        stringBuilder.append((char)n);
                        n2 = 0;
                    }
                    if (n2 == 2) continue block12;
                    n4 = 0;
                    n3 = 0;
                    continue block12;
                }
            }
            assert (false);
            throw new IllegalStateException();
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                stringBuilder.append('\\');
                break;
            }
            case 3: {
                assert (n4 >= 0 && n4 < 3);
                JavaI18nSupport.appendChar(stringBuilder, n3);
                break;
            }
            case 2: {
                assert (n4 >= 0 && n4 < 4);
                stringBuilder.append('\\').append('u');
                for (n = 0; n < n4; ++n) {
                    stringBuilder.append(cArray2[n]);
                }
                break;
            }
            default: {
                assert (false);
                throw new IllegalStateException();
            }
        }
        return stringBuilder.toString();
    }

    private static final StringBuilder appendChar(StringBuilder stringBuilder, int n) throws IllegalArgumentException {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("value out of range: " + n);
        }
        if (n >= 32 && n != 127) {
            stringBuilder.append((char)n);
        } else {
            stringBuilder.append('\\');
            switch (n) {
                case 8: {
                    stringBuilder.append('b');
                    break;
                }
                case 9: {
                    stringBuilder.append('t');
                    break;
                }
                case 10: {
                    stringBuilder.append('n');
                    break;
                }
                case 12: {
                    stringBuilder.append('f');
                    break;
                }
                case 13: {
                    stringBuilder.append('r');
                    break;
                }
                default: {
                    stringBuilder.append('u');
                    for (int i = 12; i >= 0; i -= 4) {
                        stringBuilder.append(hexaDigitChars.charAt(n >> i & 0xF));
                    }
                }
            }
        }
        return stringBuilder;
    }

    @Override
    public JPanel getInfo(HardCodedString hardCodedString) {
        return new JavaInfoPanel(hardCodedString, this.document);
    }

    public String getIdentifier() {
        if (this.identifier == null || this.identifier == "") {
            this.createIdentifier();
        }
        return this.identifier;
    }

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public Set<Modifier> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Set<Modifier> set) {
        this.modifiers = set;
    }

    public boolean isGenerateField() {
        return this.generateField;
    }

    public void setGenerateField(boolean bl) {
        this.generateField = bl;
    }

    public String getInitFormat() {
        return this.initFormat;
    }

    public void setInitFormat(String string) {
        this.initFormat = string;
    }

    @Override
    public PropertyPanel getPropertyPanel() {
        return new JavaPropertyPanel();
    }

    @Override
    public boolean hasAdditionalCustomizer() {
        return true;
    }

    @Override
    public JPanel getAdditionalCustomizer() {
        return new JavaReplacePanel(this);
    }

    @Override
    public void performAdditionalChanges() {
        this.createField();
    }

    public void createIdentifier() {
        String string;
        try {
            string = this.resourceHolder.getResource().getName();
        }
        catch (NullPointerException nullPointerException) {
            this.identifier = "";
            return;
        }
        string = string.length() > 0 ? string.substring(0, 1).toLowerCase() + string.substring(1) : string.toLowerCase();
        this.identifier = string;
    }

    private void createField() {
        if (!this.isGenerateField()) {
            return;
        }
        JavaSource javaSource = JavaSource.forDocument((Document)this.document);
        try {
            ModificationResult modificationResult = javaSource.runModificationTask((Task)new AddFieldTask(this.getIdentifier()));
            modificationResult.commit();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    public String getInitString() {
        String string = this.getInitFormat();
        FileObject fileObject = this.resourceHolder.getResource().getPrimaryFile();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("bundleNameSlashes", classPath.getResourceName(fileObject, '/', false));
        hashMap.put("bundleNameDots", classPath.getResourceName(fileObject, '.', false));
        hashMap.put("sourceFileName", this.sourceDataObject != null ? this.sourceDataObject.getPrimaryFile().getName() : "");
        return MapFormat.format((String)string, hashMap);
    }

    public static class Factory
    extends I18nSupport.Factory {
        public I18nSupport createI18nSupport(DataObject dataObject) {
            return new JavaI18nSupport(dataObject);
        }

        public Class getDataObjectClass() {
            try {
                return Class.forName("org.netbeans.modules.java.JavaDataObject", false, (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    private static class JavaInfoPanel
    extends InfoPanel {
        public JavaInfoPanel(HardCodedString hardCodedString, StyledDocument styledDocument) {
            super(hardCodedString, styledDocument);
        }

        protected void setHardCodedString(HardCodedString hardCodedString, StyledDocument styledDocument) {
            String string;
            this.getStringText().setText(hardCodedString == null ? "" : hardCodedString.getText());
            if (hardCodedString.getStartPosition() == null) {
                string = "";
            } else {
                int n = hardCodedString.getStartPosition().getOffset();
                try {
                    Element element = styledDocument.getParagraphElement(n);
                    string = styledDocument.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset()).trim();
                }
                catch (BadLocationException badLocationException) {
                    string = "";
                }
            }
            this.getFoundInText().setText(string);
            this.remove(this.getComponentLabel());
            this.remove(this.getComponentText());
            this.remove(this.getPropertyLabel());
            this.remove(this.getPropertyText());
        }
    }

    public static class JavaI18nReplacer
    implements I18nSupport.I18nReplacer {
        public void replace(final HardCodedString hardCodedString, I18nString i18nString) {
            if (!(i18nString instanceof JavaI18nString)) {
                throw new IllegalArgumentException("I18N module: i18nString have to be an instance of JavaI18nString.");
            }
            final String string = i18nString.getReplaceString();
            final StyledDocument styledDocument = i18nString.getSupport().getDocument();
            NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

                public void run() {
                    try {
                        if (hardCodedString.getLength() > 0) {
                            styledDocument.remove(hardCodedString.getStartPosition().getOffset(), hardCodedString.getLength());
                        }
                        if (string != null && string.length() > 0) {
                            styledDocument.insertString(hardCodedString.getEndPosition().getOffset(), string, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_CouldNotReplace"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                }
            });
        }
    }

    public static class JavaI18nFinder
    implements I18nSupport.I18nFinder {
        protected static final int STATE_JAVA = 0;
        protected static final int STATE_JAVA_A_SLASH = 1;
        protected static final int STATE_LINECOMMENT = 2;
        protected static final int STATE_BLOCKCOMMENT = 3;
        protected static final int STATE_BLOCKCOMMENT_A_STAR = 4;
        protected static final int STATE_STRING = 5;
        protected static final int STATE_STRING_A_BSLASH = 6;
        protected static final int STATE_CHAR = 7;
        protected StyledDocument document;
        protected int state;
        protected boolean i18nSearch;
        protected Position lastPosition;
        protected StringBuffer lastJavaString;
        protected char[] buffer;
        protected int position;
        protected int currentStringStart;
        protected int currentStringEnd;

        public JavaI18nFinder(StyledDocument styledDocument) {
            this.document = styledDocument;
            this.init();
        }

        private void init() {
            this.state = 0;
            this.initJavaStringBuffer();
            this.lastPosition = null;
        }

        protected void reset() {
            this.init();
        }

        public HardCodedString[] findAllHardCodedStrings() {
            this.reset();
            this.i18nSearch = false;
            return this.findAllStrings();
        }

        public HardCodedString findNextHardCodedString() {
            this.i18nSearch = false;
            return this.findNextString();
        }

        public HardCodedString[] findAllI18nStrings() {
            this.reset();
            this.i18nSearch = true;
            return this.findAllStrings();
        }

        public HardCodedString findNextI18nString() {
            this.i18nSearch = true;
            return this.findNextString();
        }

        protected HardCodedString[] findAllStrings() {
            HardCodedString hardCodedString;
            ArrayList<HardCodedString> arrayList = new ArrayList<HardCodedString>();
            while ((hardCodedString = this.findNextString()) != null) {
                arrayList.add(hardCodedString);
            }
            return !arrayList.isEmpty() ? arrayList.toArray(new HardCodedString[arrayList.size()]) : null;
        }

        protected HardCodedString findNextString() {
            try {
                this.buffer = this.document.getText(0, this.document.getLength()).toCharArray();
            }
            catch (BadLocationException badLocationException) {
                if (Boolean.getBoolean("netbeans.debug.exception")) {
                    badLocationException.printStackTrace();
                }
                return null;
            }
            this.position = this.lastPosition == null ? 0 : this.lastPosition.getOffset();
            this.currentStringStart = -1;
            this.currentStringEnd = -1;
            while (this.position < this.buffer.length) {
                char c = this.buffer[this.position];
                if (c != '\n') {
                    HardCodedString hardCodedString = this.handleCharacter(c);
                    if (hardCodedString != null) {
                        return hardCodedString;
                    }
                } else {
                    this.handleNewLineCharacter();
                }
                ++this.position;
            }
            return null;
        }

        protected HardCodedString handleCharacter(char c) {
            if (this.state == 0) {
                return this.handleStateJava(c);
            }
            if (this.state == 1) {
                return this.handleStateJavaASlash(c);
            }
            if (this.state == 7) {
                return this.handleStateChar(c);
            }
            if (this.state == 6) {
                return this.handleStateStringABSlash(c);
            }
            if (this.state == 2) {
                return this.handleStateLineComment(c);
            }
            if (this.state == 3) {
                return this.handleStateBlockComment(c);
            }
            if (this.state == 4) {
                return this.handleStateBlockCommentAStar(c);
            }
            if (this.state == 5) {
                return this.handleStateString(c);
            }
            return null;
        }

        protected void handleNewLineCharacter() {
            if (this.state == 0 || this.state == 1 || this.state == 7 || this.state == 2 || this.state == 5 || this.state == 6) {
                this.initJavaStringBuffer();
                this.currentStringStart = -1;
                this.currentStringEnd = -1;
                this.state = 0;
            } else if (this.state == 3 || this.state == 4) {
                this.state = 3;
            }
        }

        protected HardCodedString handleStateJava(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 1;
            } else if (c == '\"') {
                this.state = 5;
                if (this.currentStringStart == -1) {
                    this.currentStringStart = this.position;
                }
            } else if (c == '\'') {
                this.state = 7;
            }
            return null;
        }

        protected HardCodedString handleStateJavaASlash(char c) {
            this.lastJavaString.append(c);
            if (c == '/') {
                this.state = 2;
            } else if (c == '*') {
                this.state = 3;
            }
            return null;
        }

        protected HardCodedString handleStateChar(char c) {
            this.lastJavaString.append(c);
            if (c == '\'') {
                this.state = 0;
            }
            return null;
        }

        protected HardCodedString handleStateStringABSlash(char c) {
            this.state = 5;
            return null;
        }

        protected HardCodedString handleStateLineComment(char c) {
            return null;
        }

        protected HardCodedString handleStateBlockComment(char c) {
            if (c == '*') {
                this.state = 4;
            }
            return null;
        }

        protected HardCodedString handleStateBlockCommentAStar(char c) {
            if (c == '/') {
                this.state = 0;
                this.initJavaStringBuffer();
            } else if (c != '*') {
                this.state = 3;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HardCodedString handleStateString(char c) {
            if (c == '\\') {
                this.state = 6;
            } else if (c == '\"') {
                this.state = 0;
                if (this.currentStringEnd == -1 && this.currentStringStart != -1) {
                    this.currentStringEnd = this.position + 1;
                    int n = this.currentStringEnd - this.currentStringStart;
                    try {
                        Position position = this.document.createPosition(this.currentStringStart);
                        Position position2 = this.document.createPosition(this.currentStringEnd);
                        String string = this.document.getText(position.getOffset(), n);
                        String string2 = new String(this.buffer, this.currentStringEnd, this.buffer.length - this.currentStringEnd);
                        int n2 = string2.indexOf(10);
                        if (n2 == -1) {
                            n2 = string2.length();
                        }
                        this.lastJavaString.append(this.document.getText(this.currentStringStart + 1, string.length()));
                        String string3 = this.document.getText(this.currentStringStart + 1 + string.length(), this.currentStringEnd + n2 - this.currentStringStart - string.length());
                        this.lastJavaString.append(string3.replace('\"', '_'));
                        if (this.isSearchedString(this.lastJavaString.toString(), string)) {
                            this.lastPosition = position2;
                            HardCodedString hardCodedString = new HardCodedString(this.extractString(string), position, position2);
                            return hardCodedString;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
                    }
                    finally {
                        this.currentStringStart = -1;
                        this.currentStringEnd = -1;
                        this.initJavaStringBuffer();
                    }
                }
            }
            return null;
        }

        private void initJavaStringBuffer() {
            this.lastJavaString = new StringBuffer();
        }

        private String extractString(String string) {
            if (string == null) {
                return "";
            }
            if (string.length() >= 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
                string = string.substring(1, string.length() - 1);
            }
            return string;
        }

        protected boolean isSearchedString(String string, String string2) {
            Boolean bl;
            Object object;
            String string3 = UtilConvert.unicodesToChars((String)string);
            Exception exception = null;
            try {
                object = this.createRegularExpression(string2);
                bl = Pattern.compile((String)object).matcher(string3).find() == this.i18nSearch;
            }
            catch (ParseException parseException) {
                exception = parseException;
                bl = null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                exception = patternSyntaxException;
                bl = null;
            }
            if (Boolean.FALSE.equals(bl)) {
                return false;
            }
            object = new AnnotationDetector(this.currentStringStart);
            try {
                boolean bl2 = true;
                do {
                    if (!bl2) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            Exceptions.printStackTrace((Throwable)interruptedException);
                        }
                    }
                    ((AnnotationDetector)object).reset();
                    JavaSource.forDocument((Document)this.document).runUserActionTask((Task)object, true);
                    bl2 = false;
                } while (((AnnotationDetector)object).wasCancelled());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (((AnnotationDetector)object).wasAnnotationDetected()) {
                return false;
            }
            if (bl != null) {
                assert (bl.equals(Boolean.TRUE));
                return true;
            }
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            String string4 = NbBundle.getMessage(JavaI18nSupport.class, (String)"MSG_RegExpCompileError", (Object)string2);
            Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)string4, 0, 0));
            return NotifyDescriptor.YES_OPTION.equals(object2);
        }

        private String createRegularExpression(String string) throws ParseException {
            String string2 = this.i18nSearch ? I18nUtil.getOptions().getI18nRegularExpression() : I18nUtil.getOptions().getRegularExpression();
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            hashMap.put("key", string);
            hashMap.put("hardString", string);
            return Translator.translateRegexp(string2, hashMap);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class AnnotationDetector
        implements CancellableTask<CompilationController> {
            private final int caretPosition;
            private volatile boolean cancelled;
            private boolean annotationDetected = false;

            private AnnotationDetector(int n) {
                this.caretPosition = n;
            }

            void reset() {
                this.cancelled = false;
                this.annotationDetected = false;
            }

            public void run(CompilationController compilationController) throws IOException {
                if (this.cancelled) {
                    return;
                }
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                if (this.cancelled) {
                    return;
                }
                TreePath treePath = compilationController.getTreeUtilities().pathFor(this.caretPosition);
                if (treePath == null) {
                    return;
                }
                Tree.Kind kind = treePath.getLeaf().getKind();
                if (kind == Tree.Kind.STRING_LITERAL) {
                    if ((treePath = treePath.getParentPath()) == null) {
                        return;
                    }
                    kind = treePath.getLeaf().getKind();
                }
                if (kind == Tree.Kind.NEW_ARRAY) {
                    if ((treePath = treePath.getParentPath()) == null) {
                        return;
                    }
                    kind = treePath.getLeaf().getKind();
                }
                if (kind == Tree.Kind.ASSIGNMENT) {
                    if ((treePath = treePath.getParentPath()) == null) {
                        return;
                    }
                    kind = treePath.getLeaf().getKind();
                }
                this.annotationDetected = kind == Tree.Kind.ANNOTATION;
            }

            public void cancel() {
                this.cancelled = true;
            }

            boolean wasCancelled() {
                return this.cancelled;
            }

            boolean wasAnnotationDetected() {
                return this.annotationDetected;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddFieldTask
    implements Task<WorkingCopy> {
        private final String fieldName;

        AddFieldTask(String string) {
            this.fieldName = string;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            TypeElement typeElement = this.getClass(workingCopy);
            if (typeElement == null) {
                return;
            }
            List<? extends javax.lang.model.element.Element> list = typeElement.getEnclosedElements();
            List<VariableElement> list2 = ElementFilter.fieldsIn(list);
            if (this.containsField(list2, this.fieldName)) {
                return;
            }
            int n = this.findTargetPosition(list, list2);
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            Elements elements = workingCopy.getElements();
            Trees trees = workingCopy.getTrees();
            TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
            TypeElement typeElement2 = elements.getTypeElement("java.util.ResourceBundle");
            assert (typeElement2 != null);
            ExpressionTree expressionTree = treeUtilities.parseVariableInitializer(JavaI18nSupport.this.getInitString(), new SourcePositions[1]);
            TreePath treePath = trees.getPath(typeElement);
            Scope scope = trees.getScope(treePath);
            if (scope != null) {
                treeUtilities.attributeTree((Tree)expressionTree, scope);
            }
            VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(JavaI18nSupport.this.modifiers), (CharSequence)this.fieldName, (Tree)treeMaker.QualIdent((javax.lang.model.element.Element)typeElement2), (ExpressionTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)expressionTree));
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ClassTree classTree2 = n != -1 ? treeMaker.insertClassMember(classTree, n, (Tree)variableTree) : treeMaker.addClassMember(classTree, (Tree)variableTree);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }

        private int findTargetPosition(List<? extends javax.lang.model.element.Element> list, List<? extends VariableElement> list2) {
            if (list2.isEmpty()) {
                return 0;
            }
            int n = 0;
            boolean bl = false;
            Iterator<? extends javax.lang.model.element.Element> iterator = list.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                javax.lang.model.element.Element element = iterator.next();
                ElementKind elementKind = element.getKind();
                if (elementKind.isField() && elementKind != ElementKind.ENUM_CONSTANT && element.getModifiers().contains((Object)Modifier.STATIC)) {
                    bl = true;
                } else if (bl) {
                    bl = false;
                    n = n2;
                }
                ++n2;
            }
            return !bl ? n : -1;
        }

        private TypeElement getClass(WorkingCopy workingCopy) throws IOException {
            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            String string = JavaI18nSupport.this.sourceDataObject.getName();
            TypeElement typeElement = null;
            List list = workingCopy.getTopLevelElements();
            for (TypeElement typeElement2 : list) {
                ElementKind elementKind = typeElement2.getKind();
                if (!elementKind.isClass()) continue;
                if (typeElement2.getSimpleName().contentEquals(string)) {
                    return typeElement2;
                }
                if (typeElement != null || !typeElement2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                typeElement = typeElement2;
            }
            return typeElement;
        }

        private boolean containsField(List<? extends VariableElement> list, String string) {
            if (!list.isEmpty()) {
                for (VariableElement variableElement : list) {
                    if (!variableElement.getSimpleName().contentEquals(string)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

