/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.ServiceNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientChildren
extends Children.Keys<WsdlService> {
    Client client;
    WsdlModel wsdlModel;
    FileObject srcRoot;

    public JaxWsClientChildren(Client client, FileObject fileObject) {
        this.client = client;
        this.srcRoot = fileObject;
    }

    protected void addNotify() {
        final WsdlModeler wsdlModeler = ((JaxWsClientNode)this.getNode()).getWsdlModeler();
        if (wsdlModeler != null) {
            JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
            if (jAXWSClientSupport != null) {
                wsdlModeler.setCatalog(jAXWSClientSupport.getCatalog());
            }
            this.wsdlModel = wsdlModeler.getWsdlModel();
            if (this.wsdlModel == null) {
                wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel wsdlModel) {
                        JaxWsClientChildren.this.wsdlModel = wsdlModel;
                        ((JaxWsClientNode)JaxWsClientChildren.this.getNode()).changeIcon();
                        if (wsdlModel == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                        }
                        JaxWsClientChildren.this.updateKeys();
                    }
                });
            } else {
                this.updateKeys();
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        List list = null;
        if (this.wsdlModel != null) {
            list = this.wsdlModel.getServices();
        }
        this.setKeys(list == null ? new ArrayList() : list);
    }

    protected Node[] createNodes(WsdlService wsdlService) {
        return new Node[]{new ServiceNode(wsdlService)};
    }

    void refreshKeys(boolean bl) {
        this.refreshKeys(bl, "");
    }

    void refreshKeys(boolean bl, String string) {
        Project project;
        String string2;
        String string3;
        FileObject fileObject;
        String string4;
        Object object;
        super.addNotify();
        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
        final JaxWsClientNode jaxWsClientNode = (JaxWsClientNode)this.getNode();
        if (bl) {
            try {
                FileObject fileObject2;
                object = jaxWsClientNode.getName();
                string4 = this.client.getWsdlUrl();
                boolean bl2 = false;
                fileObject = null;
                if (string.length() > 0 && !string4.equals(string)) {
                    fileObject = WSUtils.retrieveResource((FileObject)jAXWSClientSupport.getLocalWsdlFolderForClient((String)object, true), (URI)new URI(string));
                    bl2 = true;
                } else {
                    WSUtils.retrieveResource((FileObject)jAXWSClientSupport.getLocalWsdlFolderForClient((String)object, true), (URI)new URI(string4));
                }
                if (bl2) {
                    this.client.setWsdlUrl(string);
                    string3 = jAXWSClientSupport.getLocalWsdlFolderForClient((String)object, false);
                    if (string3 != null) {
                        string2 = FileUtil.getRelativePath((FileObject)string3, (FileObject)fileObject);
                        this.client.setLocalWsdlFile(string2);
                    }
                    jaxWsClientNode.getJaxWsModel().write();
                }
                if (this.client.getWsdlUrl().startsWith("file:") && (string2 = FileOwnerQuery.getOwner((FileObject)(string3 = (FileObject)this.getNode().getLookup().lookup(FileObject.class)))).getLookup().lookup(J2eeModuleProvider.class) != null && (fileObject2 = jAXWSClientSupport.getLocalWsdlFolderForClient((String)object, false)) != null) {
                    FileObject fileObject3 = this.getWsdlFolderForClient(jAXWSClientSupport, (String)object);
                    WSUtils.copyFiles((FileObject)fileObject2, (FileObject)fileObject3);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorManager.getDefault().annotate((Throwable)unknownHostException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
        }
        object = jaxWsClientNode.getWsdlModeler();
        jaxWsClientNode.setModelGenerationFinished(false);
        jaxWsClientNode.changeIcon();
        if (object != null) {
            object.generateWsdlModel(new WsdlModelListener((WsdlModeler)object){
                final /* synthetic */ WsdlModeler val$wsdlModeler;
                {
                    this.val$wsdlModeler = wsdlModeler;
                }

                public void modelCreated(WsdlModel wsdlModel) {
                    Client client;
                    JaxWsClientChildren.this.wsdlModel = wsdlModel;
                    jaxWsClientNode.setModelGenerationFinished(true);
                    jaxWsClientNode.changeIcon();
                    if (wsdlModel == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(this.val$wsdlModeler.getCreationException()));
                    }
                    JaxWsClientChildren.this.updateKeys();
                    if (wsdlModel != null && (client = jaxWsClientNode.getJaxWsModel().findClientByName(jaxWsClientNode.getName())) != null) {
                        String string;
                        int n;
                        WsdlService wsdlService = null;
                        boolean bl = false;
                        List list = wsdlModel.getServices();
                        if (list != null && list.size() > 0) {
                            wsdlService = (WsdlService)list.get(0);
                        }
                        String string2 = client.getPackageName();
                        if (wsdlService != null && !client.isPackageNameForceReplace() && (n = (string = wsdlService.getJavaName()).lastIndexOf(".")) >= 0) {
                            String string3 = string.substring(0, n);
                            if (string2 == null && string3 != null || !string2.equals(string3)) {
                                client.setPackageName(string3);
                                bl = true;
                            }
                        }
                        if (bl) {
                            try {
                                jaxWsClientNode.getJaxWsModel().write();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                            }
                        }
                    }
                }
            });
        }
        if ((project = FileOwnerQuery.getOwner((FileObject)(string4 = (FileObject)this.getNode().getLookup().lookup(FileObject.class)))) != null) {
            fileObject = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                string3 = this.client.getName();
                string2 = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-client-clean-" + string3, "wsimport-client-" + string3}, null);
                string2.waitFinished();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
            }
            string3 = this.client.getPackageName();
            if (string3 != null) {
                string3 = string3.replace(".", "/");
                string2 = project.getProjectDirectory().getFileObject("build/generated/wsimport/client/" + string3);
                if (string2 != null) {
                    string2.refresh();
                }
            }
        }
    }

    WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForClient(JAXWSClientSupport jAXWSClientSupport, String string) throws IOException {
        FileLock fileLock;
        FileObject fileObject = jAXWSClientSupport.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject("client/" + string);
        if (fileObject2 != null) {
            fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        if ((fileLock = fileObject.getFileObject("client")) == null) {
            fileLock = fileObject.createFolder("client");
        }
        return fileLock.createFolder(string);
    }
}

