/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandler;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChains;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerClass;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerName;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModelFactory;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.DefinitionsBindings;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClientHandlerButtonListener
implements ActionListener {
    private MessageHandlerPanel panel;
    private BindingsModel bindingsModel;
    private Client client;
    private Node node;
    private JaxWsModel jaxWsModel;
    private String bindingsHandlerFile;

    public ClientHandlerButtonListener(MessageHandlerPanel messageHandlerPanel, BindingsModel bindingsModel, Client client, Node node, JaxWsModel jaxWsModel) {
        this.panel = messageHandlerPanel;
        this.bindingsModel = bindingsModel;
        this.client = client;
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ClientHandlerButtonListener.this.configureHandler();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureHandler() {
        if (!this.panel.isChanged()) {
            return;
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ClientHandlerButtonListener.class, (String)"MSG_ConfigureHandler"));
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        FileObject fileObject = (FileObject)this.node.getLookup().lookup(FileObject.class);
        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
        FileObject fileObject2 = jAXWSClientSupport.getBindingsFolderForClient(this.node.getName(), true);
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        assert (client != null);
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            BindingsHandlerChains bindingsHandlerChains;
            DefinitionsBindings definitionsBindings;
            Object object4;
            Object object5;
            Object object6;
            this.bindingsHandlerFile = client.getHandlerBindingFile();
            if (this.bindingsHandlerFile == null) {
                object6 = this.node.getName() + "_handler";
                this.bindingsHandlerFile = FileUtil.findFreeFileName((FileObject)fileObject2, (String)object6, (String)"xml") + ".xml";
                client.setHandlerBindingFile(this.bindingsHandlerFile);
            }
            object6 = FileUtil.createData((FileObject)fileObject2, (String)this.bindingsHandlerFile);
            if (this.bindingsModel == null) {
                object5 = Repository.getDefault().getDefaultFileSystem().findResource("jax-ws/default-binding-handler.xml").getInputStream();
                object4 = ClientHandlerButtonListener.readResource((InputStream)object5);
                ((InputStream)object5).close();
                fileObject2.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((FileObject)object6, (String)object4){
                    final /* synthetic */ FileObject val$bindingHandlerFO;
                    final /* synthetic */ String val$bindingsContent;
                    {
                        this.val$bindingHandlerFO = fileObject;
                        this.val$bindingsContent = string;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        BufferedWriter bufferedWriter = null;
                        OutputStream outputStream = null;
                        OutputStreamWriter outputStreamWriter = null;
                        FileLock fileLock = this.val$bindingHandlerFO.lock();
                        try {
                            outputStream = this.val$bindingHandlerFO.getOutputStream(fileLock);
                            outputStreamWriter = new OutputStreamWriter(outputStream);
                            bufferedWriter = new BufferedWriter(outputStreamWriter);
                            bufferedWriter.write(this.val$bindingsContent);
                        }
                        finally {
                            try {
                                if (bufferedWriter != null) {
                                    bufferedWriter.close();
                                }
                                if (outputStream != null) {
                                    outputStream.close();
                                }
                                if (outputStreamWriter != null) {
                                    outputStreamWriter.close();
                                }
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify((Throwable)iOException);
                            }
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                        }
                    }
                });
                definitionsBindings = Utilities.getModelSource((FileObject)object6, (boolean)true);
                this.bindingsModel = BindingsModelFactory.getDefault().getModel((ModelSource)definitionsBindings);
                bindingsHandlerChains = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false).getFileObject(client.getLocalWsdlFile());
                object3 = FileUtil.toFile((FileObject)object6);
                object2 = Utilities.relativize((URI)((File)object3).toURI(), (URI)new URI(bindingsHandlerChains.getURL().toExternalForm()));
                object = this.bindingsModel.getGlobalBindings();
                try {
                    this.bindingsModel.startTransaction();
                    object.setWsdlLocation((String)object2);
                }
                finally {
                    this.bindingsModel.endTransaction();
                }
                BindingsHandler bindingsHandler = DataObject.find((FileObject)object6);
                if (bindingsHandler.isModified()) {
                    string = (SaveCookie)bindingsHandler.getCookie(SaveCookie.class);
                    string.save();
                }
            }
            object5 = this.panel.getHandlerTableModel();
            object4 = this.bindingsModel.getGlobalBindings();
            definitionsBindings = object4.getDefinitionsBindings();
            bindingsHandlerChains = definitionsBindings.getHandlerChains();
            object3 = bindingsHandlerChains.getHandlerChains().iterator().next();
            try {
                this.bindingsModel.startTransaction();
                object2 = object3.getHandlers();
                for (BindingsHandler bindingsHandler : object2) {
                    object3.removeHandler(bindingsHandler);
                }
                if (object5.getRowCount() > 0) {
                    object = this.bindingsModel.getFactory();
                    for (int i = 0; i < object5.getRowCount(); ++i) {
                        string = (String)object5.getValueAt(i, 0);
                        BindingsHandler bindingsHandler = object.createHandler();
                        String string2 = string.substring(string.indexOf(".") + 1);
                        BindingsHandlerName bindingsHandlerName = object.createHandlerName();
                        bindingsHandlerName.setHandlerName(string2);
                        bindingsHandler.setHandlerName(bindingsHandlerName);
                        BindingsHandlerClass bindingsHandlerClass = object.createHandlerClass();
                        bindingsHandlerClass.setClassName(string);
                        bindingsHandler.setHandlerClass(bindingsHandlerClass);
                        object3.addHandler(bindingsHandler);
                    }
                }
            }
            finally {
                this.bindingsModel.endTransaction();
            }
            object2 = DataObject.find((FileObject)object6);
            if (object2.isModified()) {
                object = (SaveCookie)object2.getCookie(SaveCookie.class);
                object.save();
            }
            if (object5.getRowCount() > 0) {
                object = client.getBindingByFileName(this.bindingsHandlerFile);
                if (object == null) {
                    object = client.newBinding();
                    object.setFileName(this.bindingsHandlerFile);
                    client.addBinding((Binding)object);
                }
            } else {
                object = client.getBindingByFileName(this.bindingsHandlerFile);
                if (object != null) {
                    client.removeBinding((Binding)object);
                }
                this.removeHandlerAnnotation();
            }
            this.jaxWsModel.write();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        progressHandle.finish();
        this.invokeWsImport(fileObject);
    }

    private void removeHandlerAnnotation() {
        JaxWsClientNode jaxWsClientNode = (JaxWsClientNode)this.node.getLookup().lookup(JaxWsClientNode.class);
        WsdlModel wsdlModel = jaxWsClientNode.getWsdlModel();
        WsdlService wsdlService = (WsdlService)wsdlModel.getServices().get(0);
        String string = wsdlService.getJavaName();
        FileObject fileObject = (FileObject)this.node.getLookup().lookup(FileObject.class);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/source");
        FileObject fileObject2 = classPath.findResource(string.replaceAll("\\.", "/") + ".java");
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                TypeElement typeElement2 = workingCopy.getElements().getTypeElement("javax.jws.HandlerChain");
                if (typeElement2 != null) {
                    Iterable<Tree> iterable;
                    Tree tree;
                    AnnotationTree tree3 = null;
                    List<? extends AnnotationTree> list = classTree.getModifiers().getAnnotations();
                    for (AnnotationTree tree22 : list) {
                        tree = (IdentifierTree)tree22.getAnnotationType();
                        iterable = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), tree);
                        TypeElement typeElement3 = (TypeElement)workingCopy.getTrees().getElement((TreePath)iterable);
                        if (typeElement3 == null || !typeElement3.getQualifiedName().contentEquals("javax.jws.HandlerChain")) continue;
                        tree3 = tree22;
                        break;
                    }
                    ModifiersTree modifiersTree = classTree.getModifiers();
                    ModifiersTree modifiersTree2 = treeMaker.removeModifiersAnnotation(modifiersTree, tree3);
                    workingCopy.rewrite((Tree)modifiersTree, (Tree)modifiersTree2);
                    tree = workingCopy.getCompilationUnit();
                    iterable = tree.getImports();
                    for (ImportTree importTree : iterable) {
                        Tree tree2 = importTree.getQualifiedIdentifier();
                        TreePath treePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), tree2);
                        TypeElement typeElement4 = (TypeElement)workingCopy.getTrees().getElement(treePath);
                        if (typeElement4 == null || !typeElement4.getQualifiedName().contentEquals("javax.jws.HandlerChain")) continue;
                        CompilationUnitTree compilationUnitTree = treeMaker.removeCompUnitImport((CompilationUnitTree)tree, importTree);
                        workingCopy.rewrite(tree, (Tree)compilationUnitTree);
                        break;
                    }
                }
            }

            public void cancel() {
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable((CancellableTask)cancellableTask, fileObject2){
                final /* synthetic */ CancellableTask val$modificationTask;
                final /* synthetic */ FileObject val$serviceFO;
                {
                    this.val$modificationTask = cancellableTask;
                    this.val$serviceFO = fileObject;
                }

                public void run() {
                    try {
                        javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                        ClientHandlerButtonListener.saveFile(this.val$serviceFO);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
            });
        } else {
            try {
                javaSource.runModificationTask((Task)cancellableTask).commit();
                ClientHandlerButtonListener.saveFile(fileObject2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private static void saveFile(FileObject fileObject) throws IOException {
        SaveCookie saveCookie;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            saveCookie.save();
        }
    }

    private void invokeWsImport(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            FileObject fileObject2;
            String string;
            FileObject fileObject3 = project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
            try {
                string = this.client.getName();
                fileObject2 = ActionUtils.runTarget((FileObject)fileObject3, (String[])new String[]{"wsimport-client-clean-" + string, "wsimport-client-" + string}, null);
                fileObject2.waitFinished();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
            }
            string = this.client.getPackageName();
            if (string != null) {
                string = string.replace(".", "/");
                fileObject2 = project.getProjectDirectory().getFileObject("build/generated/wsimport/client/" + string);
                if (fileObject2 != null) {
                    fileObject2.refresh();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readResource(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string = System.getProperty("line.separator");
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                string2 = bufferedReader.readLine();
            }
        }
        finally {
            inputStreamReader.close();
            bufferedReader.close();
            inputStream.close();
        }
        return stringBuilder.toString();
    }
}

