/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.dev.wizard.PortChooser;
import org.netbeans.modules.websvc.core.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.core.dev.wizard.nodes.WsdlNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class WebServiceFromWSDLPanel
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static String previousDirectory = "";
    private final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
    private boolean isWaitingForScan = false;
    private WsdlModeler wsdlModeler;
    private WsdlModel wsdlModel;
    private WsdlService service;
    private WsdlPort port;
    private WsdlServiceHandler wsdlServiceHandler;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private JAXWSSupport wss;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jwsdpSupported;
    private boolean jaxWsInJ2ee14Supported;
    private WebModule wm;
    private RequestProcessor.Task generateWsdlModelTask;
    private URL wsdlURL;
    private JButton jButtonBrowsePort;
    private JButton jButtonWSDLFileBrowse;
    private JLabel jLabelPort;
    private JLabel jLabelPortDescription;
    private JLabel jLabelWSDLFile;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldWSDLFile;
    private JCheckBox useProviderBtn;

    public WebServiceFromWSDLPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.initJsr109Info();
        this.jTextFieldWSDLFile.getDocument().addDocumentListener(this);
        if (this.supportsJaxrpc()) {
            this.useProviderBtn.setVisible(false);
        }
        this.generateWsdlModelTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                Object object;
                Object object2;
                WsdlWrapperHandler wsdlWrapperHandler = null;
                try {
                    wsdlWrapperHandler = WsdlWrapperGenerator.parse((String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    object2 = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_SAXException", (Object)sAXException.getLocalizedMessage());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message(object2, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (wsdlWrapperHandler != null && !wsdlWrapperHandler.isServiceElement()) {
                    object = new StreamSource(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                    try {
                        object2 = new File(System.getProperty("java.io.tmpdir"), WsdlWrapperGenerator.getWrapperName((URL)WebServiceFromWSDLPanel.this.wsdlURL));
                        if (!((File)object2).exists()) {
                            try {
                                ((File)object2).createNewFile();
                            }
                            catch (IOException iOException) {
                                String string = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_UnableToCreateTempFile", (Object)((File)object2).getPath());
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                return;
                            }
                        }
                        WsdlWrapperGenerator.generateWrapperWSDLContent((File)object2, (StreamSource)object, (String)wsdlWrapperHandler.getTargetNsPrefix(), (String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                        WebServiceFromWSDLPanel.this.wsdlURL = ((File)object2).toURL();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                object = wsdlWrapperHandler;
                WebServiceFromWSDLPanel.this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(WebServiceFromWSDLPanel.this.wsdlURL);
                WebServiceFromWSDLPanel.this.wsdlModeler.generateWsdlModel(new WsdlModelListener((WsdlWrapperHandler)object){
                    final /* synthetic */ WsdlWrapperHandler val$wsdlHandler;
                    {
                        this.val$wsdlHandler = wsdlWrapperHandler;
                    }

                    public void modelCreated(WsdlModel wsdlModel) {
                        Object object;
                        WebServiceFromWSDLPanel.this.wsdlModel = wsdlModel;
                        if (WebServiceFromWSDLPanel.this.wsdlModel == null) {
                            object = null;
                            String string = null;
                            try {
                                WebServiceFromWSDLPanel.this.wsdlServiceHandler = WsdlServiceHandler.parse(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                                object = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getServiceName();
                                string = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getPortName();
                            }
                            catch (ParserConfigurationException parserConfigurationException) {
                            }
                            catch (SAXException sAXException) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (object != null && string != null) {
                                WebServiceFromWSDLPanel.this.jTextFieldPort.setText((String)object + "#" + string);
                            } else {
                                RequestProcessor.getDefault().post(new Runnable(){

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TXT_CannotGenerateService", (Object)WebServiceFromWSDLPanel.this.wsdlModeler.getCreationException().getLocalizedMessage()), 2));
                                    }
                                });
                            }
                        } else {
                            WebServiceFromWSDLPanel.this.jButtonBrowsePort.setEnabled(true);
                            object = WebServiceFromWSDLPanel.this.wsdlModel.getServices();
                            if (object != null && object.size() > 0) {
                                WebServiceFromWSDLPanel.this.service = (WsdlService)object.get(0);
                                List list = WebServiceFromWSDLPanel.this.service.getPorts();
                                if (list != null && list.size() > 0) {
                                    WebServiceFromWSDLPanel.this.port = (WsdlPort)list.get(0);
                                }
                            }
                        }
                        if (WebServiceFromWSDLPanel.this.service != null && WebServiceFromWSDLPanel.this.port != null) {
                            WebServiceFromWSDLPanel.this.jTextFieldPort.setText(WebServiceFromWSDLPanel.this.service.getName() + "#" + WebServiceFromWSDLPanel.this.port.getName());
                            if (this.val$wsdlHandler != null && (object = this.val$wsdlHandler.getBindingTypeForPort(WebServiceFromWSDLPanel.this.port.getName())) != null) {
                                WebServiceFromWSDLPanel.this.port.setSOAPVersion((String)object);
                            }
                        }
                        WebServiceFromWSDLPanel.this.fireChange();
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.jLabelWSDLFile = new JLabel();
        this.jTextFieldWSDLFile = new JTextField();
        this.jButtonWSDLFileBrowse = new JButton();
        this.jLabelPortDescription = new JLabel();
        this.jLabelPort = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jButtonBrowsePort = new JButton();
        this.useProviderBtn = new JCheckBox();
        this.jLabelWSDLFile.setLabelFor(this.jTextFieldWSDLFile);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWSDLFile, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WSDL_File"));
        this.jLabelWSDLFile.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWSDLFileBrowse, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_Browse"));
        this.jButtonWSDLFileBrowse.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        this.jButtonWSDLFileBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceFromWSDLPanel.this.jButtonWSDLFileBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelPortDescription, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_PortMessage"));
        this.jLabelPort.setLabelFor(this.jTextFieldPort);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_WebServicePort"));
        this.jLabelPort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jTextFieldPort.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowsePort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_BrowsePort"));
        this.jButtonBrowsePort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jButtonBrowsePort.setEnabled(false);
        this.jButtonBrowsePort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceFromWSDLPanel.this.jButtonBrowsePortActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useProviderBtn, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_UseProvider"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelWSDLFile).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextFieldWSDLFile, -1, 731, Short.MAX_VALUE).add((Component)this.jLabelPortDescription, -1, 731, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelPort).addPreferredGap(0).add((Component)this.jTextFieldPort, -1, 640, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.jButtonWSDLFileBrowse, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonBrowsePort, -1, 141, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.useProviderBtn))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelWSDLFile).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonWSDLFileBrowse).add((Component)this.jTextFieldWSDLFile, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelPortDescription, -2, 43, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonBrowsePort).add((Component)this.jLabelPort).add((Component)this.jTextFieldPort, -2, -1, -2)).add(57, 57, 57).add((Component)this.useProviderBtn).addContainerGap(122, Short.MAX_VALUE)));
        this.jTextFieldWSDLFile.getAccessibleContext().setAccessibleDescription("null");
        this.jButtonWSDLFileBrowse.getAccessibleContext().setAccessibleDescription("null");
        this.jTextFieldPort.getAccessibleContext().setAccessibleDescription("null");
    }

    private void jButtonBrowsePortActionPerformed(ActionEvent actionEvent) {
        WsdlNode wsdlNode = new WsdlNode(this.wsdlModel);
        PortChooser portChooser = new PortChooser((Node)wsdlNode);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)portChooser, NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        portChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("portChooser_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                }
            }
        });
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION && (Util.isJavaEE5orHigher((Project)this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported)) {
            this.jTextFieldPort.setText(portChooser.getSelectedPortOwnerName() + "#" + portChooser.getSelectedNodes()[0].getDisplayName());
            this.service = this.wsdlModel.getServiceByName(portChooser.getSelectedPortOwnerName());
            this.port = this.service.getPortByName(portChooser.getSelectedNodes()[0].getDisplayName());
        }
    }

    private void jButtonWSDLFileBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(previousDirectory);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        jFileChooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            this.jTextFieldWSDLFile.setText(file.getAbsolutePath());
            previousDirectory = file.getPath();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    private void initJsr109Info() {
        J2eePlatform j2eePlatform;
        Map map;
        String string;
        this.wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        this.wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
        if (this.wss != null && (string = (String)(map = this.wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(string)) != null) {
            this.jsr109Supported = j2eePlatform.isToolSupported("jsr109");
            this.jsr109oldSupported = j2eePlatform.isToolSupported("wscompile");
            this.jwsdpSupported = j2eePlatform.isToolSupported("jwsdp");
            this.jaxWsInJ2ee14Supported = j2eePlatform.isToolSupported("JaxWs-in-j2ee14-supported");
        }
    }

    private boolean checkNonJsr109Valid() {
        if (this.wss != null && (!this.jsr109Supported && !this.jsr109oldSupported || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) && Util.isSourceLevel14orLower((Project)this.project)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        return true;
    }

    private boolean projectHasEmbeddedSpaces() {
        FileObject fileObject = this.project.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = file.getAbsolutePath();
        int n = string.indexOf(" ");
        return n != -1;
    }

    private boolean supportsJaxrpc() {
        boolean bl = this.wm != null && !this.jsr109Supported && !this.jsr109oldSupported;
        boolean bl2 = this.wm != null && this.jaxWsInJ2ee14Supported;
        return !Util.isJavaEE5orHigher((Project)this.project) && !bl && !bl2;
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        if (!this.checkNonJsr109Valid()) {
            return false;
        }
        if (this.supportsJaxrpc() && WebServicesSupport.getWebServicesSupport((FileObject)this.project.getProjectDirectory()) == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_NoJaxrpcPluginFound"));
            return false;
        }
        String string = this.jTextFieldWSDLFile.getText().trim();
        if (string.length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_EnterWsdlName"));
            return false;
        }
        if (!(string.startsWith("http://") || string.startsWith("https://") || string.startsWith("www."))) {
            File file = new File(string);
            if ((file = WebServiceFromWSDLPanel.getCanonicalFile(file)) == null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlInvalid"));
                return false;
            }
            if (!file.exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlDoesNotExist"));
                return false;
            }
        }
        if (Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) {
            if (this.wsdlModel != null) {
                if (this.service == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoService"));
                    return false;
                }
                if (this.port == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                    return false;
                }
            } else {
                if (this.wsdlServiceHandler != null && this.wsdlServiceHandler.getServiceName() != null && this.wsdlServiceHandler.getPortName() != null) {
                    return true;
                }
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                return false;
            }
        }
        if (this.projectHasEmbeddedSpaces()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_SPACE_IN_PROJECT_PATH"));
        } else {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.jTextFieldWSDLFile.getText().trim();
        Boolean bl = this.useProviderBtn.isSelected();
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            wizardDescriptor.putProperty("wsdl_url", (Object)string);
        } else {
            wizardDescriptor.putProperty("wsdlFilePath", (Object)string);
        }
        wizardDescriptor.putProperty("wsdlModel", (Object)this.wsdlModel);
        wizardDescriptor.putProperty("wsdlModeler", (Object)this.wsdlModeler);
        wizardDescriptor.putProperty("wsdlService", (Object)this.service);
        wizardDescriptor.putProperty("wsdlPort", (Object)this.port);
        wizardDescriptor.putProperty("wsdlServiceHandler", (Object)this.wsdlServiceHandler);
        wizardDescriptor.putProperty("useProvider", (Object)bl);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceFromWSDLPanel.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    private void updatePortBrowseButton() {
        this.wsdlModel = null;
        this.service = null;
        this.port = null;
        this.jTextFieldPort.setText("");
        String string = this.jTextFieldWSDLFile.getText().trim();
        if (string.length() == 0) {
            this.jButtonBrowsePort.setEnabled(false);
        } else {
            if (!(string.startsWith("http://") || string.startsWith("https://") || string.startsWith("www."))) {
                File file = new File(string);
                if ((file = WebServiceFromWSDLPanel.getCanonicalFile(file)) == null) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
                if (!file.exists()) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
            }
            this.fireChange();
            if (Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) {
                this.createModel();
            }
        }
    }

    private void createModel() {
        String string = this.jTextFieldWSDLFile.getText().trim();
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            try {
                this.wsdlURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        } else {
            File file = FileUtil.normalizeFile((File)new File(this.jTextFieldWSDLFile.getText().trim()));
            this.wsdlURL = null;
            try {
                this.wsdlURL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        this.generateWsdlModelTask.schedule(1000);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public static File getCanonicalFile(File file) {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = null;
        }
        return file2;
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        public boolean accept(File file) {
            String string = FileUtil.getExtension((String)file.getName());
            return file.isDirectory() || "wsdl".equalsIgnoreCase(string) || "asmx".equalsIgnoreCase(string);
        }

        public String getDescription() {
            return NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

