/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class NodeDisplayPanel
extends JPanel
implements ExplorerManager.Provider {
    private PropertyChangeSupport pcs;
    private ExplorerManager manager = new ExplorerManager();

    public NodeDisplayPanel(Node node) {
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setRootVisible(false);
        beanTreeView.setDefaultActionAllowed(false);
        beanTreeView.setSelectionMode(1);
        this.manager.setRootContext(node);
        Node[] nodeArray = node.getChildren().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            beanTreeView.expandNode(nodeArray[i]);
        }
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NodeDisplayPanel.this.firePropertyChange();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)beanTreeView, "Center");
        beanTreeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NodeDisplayPanel.class, (String)"ACSD_PortNodeTreeView"));
        beanTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NodeDisplayPanel.class, (String)"ACSD_PortNodeTreeView"));
    }

    private PropertyChangeSupport getProperChangeSupport() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getProperChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChange() {
        this.getProperChangeSupport().firePropertyChange("nodeChange", null, null);
    }

    public Node[] getSelectedNodes() {
        return this.manager.getSelectedNodes();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

