/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xslt.model.AttributeSet;
import org.netbeans.modules.xslt.model.ReferenceableXslComponent;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.XslReference;
import org.netbeans.modules.xslt.model.impl.AttributeAccess;
import org.netbeans.modules.xslt.model.impl.GlobalReferenceImpl;
import org.netbeans.modules.xslt.model.impl.ReferenceListResolveFactory;
import org.netbeans.modules.xslt.model.impl.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeSetReferenceListResolver
implements ReferenceListResolveFactory {
    AttributeSetReferenceListResolver() {
    }

    @Override
    public boolean isApplicable(Class clazz) {
        return AttributeSet.class.isAssignableFrom(clazz);
    }

    @Override
    public <T extends ReferenceableXslComponent> List<XslReference<T>> resolve(AttributeAccess attributeAccess, Class<T> clazz, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        LinkedList<Reference<T>> linkedList = new LinkedList<Reference<T>>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Collection<Reference<T>> collection = this.find(clazz, string2, attributeAccess);
            linkedList.addAll(collection);
        }
        return null;
    }

    private <T extends ReferenceableXslComponent> Collection<Reference<T>> find(Class<T> clazz, String string, AttributeAccess attributeAccess) {
        assert (AttributeSet.class.isAssignableFrom(clazz));
        LinkedHashSet<XslModel> linkedHashSet = Utilities.getAvailibleModels(attributeAccess.getComponent().getModel());
        LinkedList<GlobalReferenceImpl<AttributeSet>> linkedList = new LinkedList<GlobalReferenceImpl<AttributeSet>>();
        QName qName = this.getQName(string, attributeAccess);
        for (XslModel xslModel : linkedHashSet) {
            Stylesheet stylesheet;
            if (!Model.State.VALID.equals((Object)xslModel.getState()) || (stylesheet = xslModel.getStylesheet()) == null) continue;
            List list = stylesheet.getChildren(AttributeSet.class);
            Collection<AttributeSet> collection = this.find(list, qName);
            for (AttributeSet attributeSet : collection) {
                GlobalReferenceImpl<AttributeSet> globalReferenceImpl = new GlobalReferenceImpl<AttributeSet>(attributeSet, AttributeSet.class, attributeAccess.getComponent());
                if (collection == null) continue;
                linkedList.add(globalReferenceImpl);
            }
        }
        return null;
    }

    private QName getQName(String string, AttributeAccess attributeAccess) {
        String string2;
        assert (string != null);
        String[] stringArray = string.split(":");
        String string3 = null;
        if (stringArray.length == 2) {
            string3 = stringArray[0];
            string2 = stringArray[1];
        } else {
            string2 = stringArray[0];
        }
        String string4 = attributeAccess.getComponent().lookupNamespaceURI(string3);
        return new QName(string4, string2, string3);
    }

    private Collection<AttributeSet> find(List<AttributeSet> list, QName qName) {
        LinkedList<AttributeSet> linkedList = new LinkedList<AttributeSet>();
        assert (qName != null);
        for (AttributeSet attributeSet : list) {
            QName qName2 = attributeSet.getName();
            if (qName2 == null) continue;
            String string = qName2.getLocalPart();
            String string2 = qName2.getNamespaceURI();
            if (!qName.getLocalPart().equals(string) || !Utilities.equals(qName.getNamespaceURI(), string2)) continue;
            linkedList.add(attributeSet);
        }
        return linkedList;
    }
}

