/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout.jlayout;

import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.service.TSConstraint;
import com.tomsawyer.service.layout.TSTwoNodeListsLayoutConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasDirectionConstraint;
import com.tomsawyer.service.layout.jlayout.TSHasSpacingConstraint;
import com.tomsawyer.util.TSParser;
import java.io.IOException;

public class TSSeparationConstraint
extends TSTwoNodeListsLayoutConstraint
implements TSHasDirectionConstraint,
TSHasSpacingConstraint {
    private int direction = 0;
    private double spacing = 40.0;

    public TSSeparationConstraint() {
        this(-1, 0, 0);
    }

    public TSSeparationConstraint(int n, int n2, int n3) {
        super(n, n2);
        this.direction = n3;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int n) {
        if (n != 0 && n != 2 && n != 1 && n != 3) {
            throw new RuntimeException("Invalid argument.");
        }
        int n2 = this.direction;
        this.direction = n;
        if (n2 != n) {
            this.fireConstraintChangedEvent();
        }
    }

    public double getSpacing() {
        return this.spacing;
    }

    public void setSpacing(double d) {
        double d2 = this.spacing;
        this.spacing = d;
        if (d2 != d) {
            this.fireConstraintChangedEvent();
        }
    }

    public TSConstraint cloneWithAttributes() {
        TSSeparationConstraint tSSeparationConstraint = new TSSeparationConstraint(this.getStyle(), this.getPriority(), this.getDirection());
        tSSeparationConstraint.setSpacing(this.getSpacing());
        return tSSeparationConstraint;
    }

    protected void copy(TSConstraint tSConstraint) {
        super.copy(tSConstraint);
        if (tSConstraint instanceof TSSeparationConstraint) {
            this.direction = ((TSSeparationConstraint)tSConstraint).getDirection();
            this.spacing = ((TSSeparationConstraint)tSConstraint).getSpacing();
        }
    }

    public void read(TSGraphObjectTable tSGraphObjectTable, TSParser tSParser) throws IOException {
        super.read(tSGraphObjectTable, tSParser);
        tSParser.parseInputString("direction");
        this.setDirection(tSParser.getInt());
        tSParser.parseInputString("spacing");
        this.setSpacing(tSParser.getDouble());
    }
}

