/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.service.layout.client;

import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.client.TSServiceInputFilter;
import com.tomsawyer.service.dm;
import com.tomsawyer.service.dp;
import com.tomsawyer.service.ds;
import com.tomsawyer.util.TSSystem;
import java.util.Iterator;

public class TSLayoutInputFilter
extends TSServiceInputFilter {
    private dp helper;

    public void execute(TSServiceInputData tSServiceInputData, TSServiceInputData tSServiceInputData2) {
        ds ds2 = tSServiceInputData.getServiceName();
        if (ds2 != null) {
            this.helper = new dp(ds2);
            tSServiceInputData2.setServiceName(ds2);
            tSServiceInputData2.copyAllOptions(tSServiceInputData);
            TSGraphManager tSGraphManager = (TSGraphManager)tSServiceInputData2.getValue(null, "all:all:none:graphManager");
            int n = tSServiceInputData2.getValueAsInteger(null, "all:all:none:operation");
            this.filterByOperation(tSServiceInputData2, n);
            if (n == 1000) {
                this.filterByLayoutStyle(tSServiceInputData2, tSGraphManager);
            }
        }
    }

    private void filterByOperation(TSServiceInputData tSServiceInputData, int n) {
        Iterator iterator = tSServiceInputData.getAllValueList().iterator();
        while (iterator.hasNext()) {
            dm dm2 = (dm)iterator.next();
            if (dm2.b().startsWith("labeling") || !this.isWrongOperation(n, dm2.b())) continue;
            tSServiceInputData.remove(dm2.a(), dm2.b());
        }
    }

    private boolean isWrongOperation(int n, String string) {
        boolean bl = !string.startsWith(this.convertOperationToString(n) + ":") && !string.startsWith("all:");
        return bl;
    }

    private String convertOperationToString(int n) {
        String string = null;
        switch (n) {
            case 1000: {
                string = "layout";
                break;
            }
            case 1002: {
                string = "labeling";
                break;
            }
            case 1001: {
                string = "routing";
                break;
            }
        }
        return string;
    }

    private String convertLayoutStyleToString(int n) {
        String string;
        switch (n) {
            case 4: {
                string = "circular";
                break;
            }
            case 2: {
                string = "orthogonal";
                break;
            }
            case 1: {
                string = "hierarchical";
                break;
            }
            case 3: {
                string = "symmetric";
                break;
            }
            case 5: {
                string = "tree";
                break;
            }
            default: {
                string = "grid";
            }
        }
        return string;
    }

    private void filterByLayoutStyle(TSServiceInputData tSServiceInputData, TSGraphManager tSGraphManager) {
        Iterator iterator = tSServiceInputData.getAllValueList().iterator();
        while (iterator.hasNext()) {
            dm dm2 = (dm)iterator.next();
            Object object = dm2.a();
            String string = dm2.b();
            if (object == null) continue;
            if (!(object instanceof TSGraphManager)) {
                TSGraph tSGraph = null;
                if (object instanceof TSGraph) {
                    tSGraph = (TSGraph)object;
                } else if (object instanceof TSGraphObject) {
                    tSGraph = ((TSGraphObject)object).getOwnerGraph();
                }
                if (tSGraph == null) continue;
                int n = this.helper.c(tSServiceInputData, tSGraph, "layout:all:graph:layoutStyle");
                String string2 = this.convertLayoutStyleToString(n);
                String string3 = this.extractLayoutStyle(string);
                if (!this.isWrongLayoutStyle(string3, string2)) continue;
                tSServiceInputData.remove(object, string);
                continue;
            }
            if (tSGraphManager == object) continue;
            tSServiceInputData.remove(object, string);
        }
    }

    private boolean isWrongLayoutStyle(String string, String string2) {
        return !TSSystem.equals((Object)string, (Object)string2) && !TSSystem.equals((Object)string, (Object)"all");
    }

    private String extractLayoutStyle(String string) {
        String string2;
        int n;
        String string3 = null;
        int n2 = string.indexOf(58);
        if (n2 != -1 && (n = (string2 = string.substring(n2 + 1)).indexOf(58)) != -1) {
            string3 = string2.substring(0, n);
        }
        return string3;
    }
}

