/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.properties;

import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeListener;
import com.tomsawyer.editor.TSEButtonKeyListener;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.command.TSELayoutCommand;
import com.tomsawyer.editor.command.TSERoutingCommand;
import com.tomsawyer.editor.dialog.TSDialogCallBackListener;
import com.tomsawyer.editor.dialog.TSDialogWithCallBack;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeListener;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.editor.service.layout.properties.hx;
import com.tomsawyer.event.TSGroupEventData;
import com.tomsawyer.service.client.TSServiceProxy;
import com.tomsawyer.service.dp;
import com.tomsawyer.service.event.TSServiceInputChangeEvent;
import com.tomsawyer.service.event.TSServiceInputChangeEventData;
import com.tomsawyer.service.event.TSServiceInputChangeListener;
import com.tomsawyer.util.command.TSCommand;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class TSEBaseLayoutPropertiesDialog
extends JDialog
implements ActionListener,
TSDrawingChangeListener,
TSServiceInputChangeListener,
TSESelectionChangeListener,
TSDialogWithCallBack {
    TSETabComponent[] tabs;
    int numberOfTabs;
    protected JTabbedPane tabbedPane;
    protected JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton applyButton;
    protected JButton layoutButton;
    protected JButton resetButton;
    protected JButton defaultsButton;
    Window owner;
    protected TSServiceProxy layoutProxy;
    protected TSEAllOptionsServiceInputData inputData;
    TSEGraphWindow graphWindow;
    protected Rectangle bounds;
    protected TSEResourceBundleWrapper labels;
    Class loaderClass;
    public int flags;
    TSDialogCallBackListener callBackListener;
    protected dp layoutHelper = null;

    public TSEBaseLayoutPropertiesDialog(Frame frame, String string, TSEGraphWindow tSEGraphWindow, TSServiceProxy tSServiceProxy, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData, Class clazz, int n) {
        super(frame, string);
        this.owner = frame;
        this.graphWindow = tSEGraphWindow;
        this.layoutProxy = tSServiceProxy;
        this.inputData = tSEAllOptionsServiceInputData;
        this.setImageLoaderClass(clazz);
        this.flags = n;
        this.setNumberOfTabs(this.getTabNames().length);
        this.tabs = new TSETabComponent[this.numberOfTabs];
        this.registerListeners();
        this.layoutHelper = this.newLayoutHelper();
        this.init();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    protected void init() {
        this.labels = TSEResourceBundleWrapper.getSystemLabelBundle();
        this.buttonPanel = this.makeButtonPanel();
        this.tabbedPane = this.createTabbedPane();
        this.selectCorrectTab();
        Container container = this.getContentPane();
        Dimension dimension = this.tabbedPane.getPreferredSize();
        Dimension dimension2 = this.buttonPanel.getPreferredSize();
        int n = 12;
        int n2 = (int)Math.max(dimension.getWidth(), dimension2.getWidth());
        this.tabbedPane.setBounds(n, n, n2, (int)dimension.getHeight());
        this.buttonPanel.setBounds(n, 2 * n + (int)dimension.getHeight(), n2, (int)dimension2.getHeight());
        ((JPanel)container).setPreferredSize(new Dimension(2 * n + n2, 3 * n + (int)dimension.getHeight() + (int)dimension2.getHeight()));
        container.setLayout(null);
        container.add(this.tabbedPane);
        container.add(this.buttonPanel);
        this.addKeyListener((KeyListener)new TSEButtonKeyListener((JDialog)this, (ActionListener)this));
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new hx(this));
    }

    protected abstract dp newLayoutHelper();

    public JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        Color color = new JPanel().getBackground();
        int n = 0;
        double d = 0.0;
        double d2 = -1.0;
        int n2 = this.getNumberOfTabs();
        String string = this.getClass().getName();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.getTabNames()[i];
            TSETabComponent tSETabComponent = this.createAppropriateTab(string2);
            if (tSETabComponent != null) {
                if (this.getImageLoaderClass() != null) {
                    Image image = TSEImage.loadImage((Class)this.getImageLoaderClass(), (String)("images/" + string2.toLowerCase() + ".gif"));
                    if (image != null) {
                        jTabbedPane.addTab(string2, new ImageIcon(image), tSETabComponent);
                    } else {
                        jTabbedPane.addTab(string2, tSETabComponent);
                    }
                } else {
                    jTabbedPane.addTab(string2, tSETabComponent);
                }
                this.tabs[i - n] = tSETabComponent;
                jTabbedPane.setBackgroundAt(i - n, color);
                d2 = Math.max(d2, tSETabComponent.getPreferredSize().getWidth());
                d += jTabbedPane.getUI().getTabBounds(jTabbedPane, i - n).getWidth();
            } else {
                ++n;
            }
            this.setNumberOfTabs(i - n + 1);
        }
        jTabbedPane.setFont(new Font("Dialog", 0, 11));
        if (d2 > 0.0) {
            double d3 = jTabbedPane.getPreferredSize().getWidth();
            d3 = Math.max(d3, d2);
            d3 = Math.max(d3, d);
            jTabbedPane.setPreferredSize(new Dimension((int)d3, (int)jTabbedPane.getPreferredSize().getHeight()));
        }
        return jTabbedPane;
    }

    protected void selectCorrectTab() {
        if (this.numberOfTabs > 0 && this.getGraph() != null) {
            int n = this.layoutHelper.c(this.inputData, null, "all:all:none:operation");
            int n2 = this.layoutHelper.c(this.inputData, this.getGraph(), "layout:all:graph:layoutStyle");
            int n3 = 0;
            for (int i = 0; i < this.getNumberOfTabs(); ++i) {
                if (this.tabs[i] == null || this.tabs[i].getOperation() != n) continue;
                if (n == 1000) {
                    if (this.tabs[i].getLayoutStyle() != n2) continue;
                    n3 = i;
                    break;
                }
                if (n != 1001) continue;
                n3 = i;
                break;
            }
            this.tabbedPane.setSelectedIndex(n3);
        }
    }

    protected abstract TSETabComponent createAppropriateTab(String var1);

    public JPanel makeButtonPanel() {
        JButton jButton;
        JPanel jPanel = new JPanel();
        this.okButton = new JButton(this.labels.getStringSafely("OK"));
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.labels.getStringSafely("Cancel"));
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.addActionListener(this);
        this.applyButton = new JButton(this.labels.getStringSafely("Apply"));
        this.applyButton.setActionCommand("apply");
        this.applyButton.addActionListener(this);
        this.layoutButton = new JButton(this.labels.getStringSafely("Layout"));
        this.layoutButton.setActionCommand("layout");
        this.layoutButton.addActionListener(this);
        this.resetButton = new JButton(this.labels.getStringSafely("Reset"));
        this.resetButton.setActionCommand("reset");
        this.resetButton.addActionListener(this);
        this.defaultsButton = new JButton(this.labels.getStringSafely("Defaults"));
        this.defaultsButton.setActionCommand("defaults");
        this.defaultsButton.addActionListener(this);
        this.deactivateButtons();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.okButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.cancelButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.applyButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.layoutButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.resetButton);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.defaultsButton);
        int n = 0;
        Vector<JButton> vector = new Vector<JButton>();
        vector.add(this.okButton);
        vector.add(this.cancelButton);
        vector.add(this.applyButton);
        vector.add(this.layoutButton);
        vector.add(this.resetButton);
        vector.add(this.defaultsButton);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            jButton = (JButton)iterator.next();
            n = Math.max(n, (int)jButton.getPreferredSize().getWidth());
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            jButton = (JButton)iterator.next();
            Dimension dimension = new Dimension(n, (int)jButton.getPreferredSize().getHeight());
            jButton.setSize(dimension);
            jButton.setPreferredSize(dimension);
            jButton.setMaximumSize(dimension);
        }
        if (this.layoutProxy == null) {
            this.layoutButton.setEnabled(false);
        }
        return jPanel;
    }

    public void dispose() {
        this.unregisterListeners();
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            this.setVisible(false);
            this.onApply();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
            this.onReset();
        } else if (string.equals("apply")) {
            this.onApply();
        } else if (string.equals("layout")) {
            this.onApply();
            this.onLayout();
        } else if (string.equals("reset")) {
            this.onReset();
        } else {
            this.onDefaults();
        }
    }

    public void onApply() {
        if (this.getGraphWindow() != null) {
            TSEEventManager tSEEventManager = (TSEEventManager)this.getGraphWindow().getGraphManager().getEventManager();
            int n = tSEEventManager.getContext();
            tSEEventManager.setContext(17);
            boolean bl = tSEEventManager.isCoalesce();
            tSEEventManager.setCoalesce(true);
            for (int i = 0; i < this.numberOfTabs; ++i) {
                TSETabComponent tSETabComponent = this.tabs[i];
                if (!tSETabComponent.isChanged()) continue;
                tSETabComponent.onApply();
            }
            tSEEventManager.setCoalesce(bl);
            tSEEventManager.setContext(n);
            this.getGraphWindow().updateScrollBarValues();
            this.deactivateButtons();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLayout() {
        block10: {
            block11: {
                Object var1_1 = null;
                try {
                    try {
                        if (this.layoutProxy == null) break block10;
                        int n = ((TSETabComponent)this.tabbedPane.getSelectedComponent()).getOperation();
                        TSERoutingCommand tSERoutingCommand = null;
                        if (n == 1000) {
                            this.inputData.setOption((Object)null, "all:all:none:operation", 1000);
                            int n2 = ((TSETabComponent)this.tabbedPane.getSelectedComponent()).getLayoutStyle();
                            if (n2 == 0) {
                                n2 = this.layoutHelper.c(this.inputData, this.getGraph(), "layout:all:graph:layoutStyle");
                            }
                            tSERoutingCommand = new TSELayoutCommand(this.graphWindow, this.layoutProxy, this.inputData, n2);
                        } else {
                            if (n != 1001) {
                                Object var6_6 = null;
                                this.setCursor(Cursor.getPredefinedCursor(0));
                                break block11;
                            }
                            this.inputData.setOption((Object)null, "all:all:none:operation", 1001);
                            tSERoutingCommand = new TSERoutingCommand(this.graphWindow, this.layoutProxy, this.inputData);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        this.getGraphWindow().setUserActionEnabled(false);
                        this.graphWindow.transmit((TSCommand)tSERoutingCommand);
                        break block10;
                    }
                    catch (Exception exception) {
                        this.callBack(exception);
                        if (var1_1 != null) {
                            this.inputData.setOption((Object)this.getGraph(), "layout:all:graph:layoutStyle", var1_1);
                        }
                        Object var6_8 = null;
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        this.getGraphWindow().setUserActionEnabled(true);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    this.getGraphWindow().setUserActionEnabled(true);
                    throw throwable;
                }
            }
            this.getGraphWindow().setUserActionEnabled(true);
            return;
        }
        Object var6_7 = null;
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getGraphWindow().setUserActionEnabled(true);
    }

    public void onReset() {
        for (int i = 0; i < this.numberOfTabs; ++i) {
            if (this.tabs[i].getGraph() == null) continue;
            this.tabs[i].onReset();
        }
        this.deactivateButtons();
    }

    public void onDefaults() {
        for (int i = 0; i < this.numberOfTabs; ++i) {
            this.tabs[i].setChanged(true);
            this.tabs[i].onDefaults();
        }
        this.activateButtons();
    }

    public void activateButtons() {
        this.applyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        if (this.graphWindow != null) {
            if (this.layoutProxy != null) {
                this.layoutButton.setEnabled(true);
            }
            this.defaultsButton.setEnabled(true);
        }
    }

    public void deactivateButtons() {
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        if (this.graphWindow == null || this.layoutProxy == null) {
            this.layoutButton.setEnabled(false);
        }
        if (this.graphWindow == null) {
            this.defaultsButton.setEnabled(false);
        }
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.graphWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, (EventListener)this, 0x1400000L);
        tSEEventManager.addSelectionChangeListener((Object)tSEGraphManager, (EventListener)this, 1L);
        tSEEventManager.addServiceInputChangeListener((Object)tSEGraphManager, (EventListener)this);
    }

    public void unregisterListeners() {
        if (this.graphWindow != null) {
            TSEEventManager tSEEventManager = (TSEEventManager)this.graphWindow.getGraphManager().getEventManager();
            tSEEventManager.removeListener((EventListener)this);
        }
    }

    public void drawingChanged(TSDrawingChangeEvent tSDrawingChangeEvent) {
        if (tSDrawingChangeEvent.getType() == 0x1000000L) {
            for (int i = 0; i < this.getNumberOfTabs(); ++i) {
                this.tabs[i].onLayout();
            }
        } else {
            this.onReset();
        }
    }

    public void selectionChanged(TSESelectionChangeEvent tSESelectionChangeEvent) {
        this.onNewGraph();
    }

    public void serviceInputChanged(TSServiceInputChangeEvent tSServiceInputChangeEvent) {
        if (tSServiceInputChangeEvent.isGroupEvent()) {
            Iterator iterator = ((TSGroupEventData)tSServiceInputChangeEvent.getData()).getDataList().iterator();
            while (iterator.hasNext()) {
                this.serviceInputChanged((TSServiceInputChangeEventData)((Object)iterator.next()));
            }
        } else {
            this.serviceInputChanged((TSServiceInputChangeEventData)tSServiceInputChangeEvent.getData());
        }
    }

    public void serviceInputChanged(TSServiceInputChangeEventData tSServiceInputChangeEventData) {
        if (tSServiceInputChangeEventData.getType() == 1L && tSServiceInputChangeEventData.getOptionContext() == this.getGraph()) {
            if (tSServiceInputChangeEventData.getOptionName().equals("layout:all:graph:layoutStyle")) {
                this.selectCorrectTab();
            } else {
                this.onReset();
            }
        }
    }

    public void onNewGraph() {
        TSEGraph tSEGraph = this.getGraph();
        for (int i = 0; i < this.getNumberOfTabs(); ++i) {
            this.tabs[i].setChanged(true);
            this.tabs[i].setGraph(tSEGraph);
        }
        this.onReset();
        this.selectCorrectTab();
        this.deactivateButtons();
    }

    public void onGlobalOptionChanged(String string, Object object) {
        TSETabComponent[] tSETabComponentArray = this.getTabs();
        for (int i = 0; i < this.getNumberOfTabs(); ++i) {
            TSETabComponent tSETabComponent = tSETabComponentArray[i];
            tSETabComponent.onGlobalOptionChanged(string, object);
        }
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public void setGraphWindow(TSEGraphWindow tSEGraphWindow, TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData) {
        if (this.getGraphWindow() != null) {
            this.unregisterListeners();
        }
        this.graphWindow = tSEGraphWindow;
        this.inputData = tSEAllOptionsServiceInputData;
        TSETabComponent[] tSETabComponentArray = this.getTabs();
        for (int i = 0; i < tSETabComponentArray.length; ++i) {
            tSETabComponentArray[i].setServiceInputData(tSEAllOptionsServiceInputData);
        }
        JPanel jPanel = (JPanel)this.getContentPane();
        if (this.getGraphWindow() != null) {
            jPanel.add(this.tabbedPane);
            jPanel.revalidate();
            jPanel.repaint();
            this.registerListeners();
            this.onNewGraph();
        } else {
            this.onNewGraph();
            this.deactivateButtons();
            jPanel.remove(this.tabbedPane);
            jPanel.revalidate();
            jPanel.repaint();
        }
    }

    public TSEGraph getGraph() {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphManager().selectedGraph();
        }
        return null;
    }

    public int getNumberOfTabs() {
        return this.numberOfTabs;
    }

    public void setNumberOfTabs(int n) {
        this.numberOfTabs = n;
    }

    public TSETabComponent[] getTabs() {
        return this.tabs;
    }

    public void setTabs(TSETabComponent[] tSETabComponentArray) {
        this.tabs = tSETabComponentArray;
    }

    public void setImageLoaderClass(Class clazz) {
        this.loaderClass = clazz;
    }

    public Class getImageLoaderClass() {
        return this.loaderClass;
    }

    public JButton getOKButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.selectCorrectTab();
        }
        super.setVisible(bl);
    }

    public void registerCallBackListener(TSDialogCallBackListener tSDialogCallBackListener) {
        this.callBackListener = tSDialogCallBackListener;
    }

    public Object callBack(Object object) {
        Object object2 = null;
        if (this.callBackListener != null) {
            object2 = this.callBackListener.uponCallBack(object);
        }
        return object2;
    }

    protected String[] getTabNames() {
        return new String[0];
    }

    protected static int getShowAllPagesConstant() {
        return 0;
    }
}

