/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.jlayout;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.dialog.TSUnsignedDoubleField;
import com.tomsawyer.editor.service.layout.TSEInteractiveLayoutInputTailor;
import com.tomsawyer.editor.service.layout.properties.TSETabComponent;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.layout.jlayout.TSOrthogonalLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.es;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TSEOrthogonalTab
extends TSETabComponent {
    static final String ASPECT_RATIO_AUTOMATIC = "AUTOMATIC";
    static final String ASPECT_RATIO_CUSTOM = "CUSTOM";
    static final String ASPECT_RATIO_DISABLED = "DISABLED";
    protected TSUnsignedDoubleField horizontalSpacingBetweenNodesField;
    protected TSUnsignedDoubleField verticalSpacingBetweenNodesField;
    protected TSUnsignedDoubleField horizontalSpacingBetweenEdgesField;
    protected TSUnsignedDoubleField verticalSpacingBetweenEdgesField;
    protected JRadioButton qualityDraftRadioButton;
    protected JRadioButton qualityDefaultRadioButton;
    protected JRadioButton qualityProofRadioButton;
    protected JRadioButton aspectRatioAutomaticRadioButton;
    protected JRadioButton aspectRatioCustomRadioButton;
    protected JRadioButton aspectRatioDisabledRadioButton;
    protected TSUnsignedDoubleField aspectRatioCustomField;
    protected JCheckBox fixNodeSizesCheckBox;

    public TSEOrthogonalTab(TSEGraph tSEGraph, TSServiceInputData tSServiceInputData, JDialog jDialog) {
        super(tSEGraph, tSServiceInputData, jDialog);
    }

    protected void init() {
        super.init();
        this.layoutHelper = new es();
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        JPanel jPanel3 = this.makeHorizontalSpacingPanel();
        JPanel jPanel4 = this.makeVerticalSpacingPanel();
        JPanel jPanel5 = this.makeLayoutQualityPanel();
        JPanel jPanel6 = this.makeAspectRatioPanel();
        JPanel jPanel7 = this.makeMiscPanel();
        jPanel.add(jPanel3);
        jPanel.add(this.createVerticalRigidArea(6));
        jPanel.add(jPanel4);
        Vector<JPanel> vector = new Vector<JPanel>();
        vector.add(jPanel3);
        vector.add(jPanel4);
        this.normalizeComponentDimensions(vector, true, false);
        jPanel2.add(jPanel5);
        jPanel2.add(this.createVerticalRigidArea(6));
        jPanel2.add(jPanel6);
        jPanel2.add(this.createVerticalRigidArea(6));
        jPanel2.add(jPanel7);
        Vector<JPanel> vector2 = new Vector<JPanel>();
        vector2.add(jPanel5);
        vector2.add(jPanel6);
        jPanel2.add(jPanel7);
        this.normalizeComponentDimensions(vector2, true, false);
        this.add(jPanel);
        this.add(this.createHorizontalRigidArea(6));
        this.add(jPanel2);
        this.createEmptyBorder(this, 5, 5, 5, 5);
    }

    protected JPanel makeHorizontalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.horizontalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.horizontalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.horizontalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.horizontalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Horizontal_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeVerticalSpacingPanel() {
        JPanel jPanel = this.createBoxLayoutPanel(true);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = this.createBoxLayoutPanel(false);
        JPanel jPanel3 = this.createBoxLayoutPanel(false);
        jPanel2.setAlignmentY(0.0f);
        jPanel3.setAlignmentY(0.0f);
        JLabel jLabel = this.createLabel("Spacing_Between_Nodes:");
        JLabel jLabel2 = this.createLabel("Spacing_Between_Edges:");
        this.verticalSpacingBetweenNodesField = this.createDoubleField(4, 0.0, 9999.0);
        this.verticalSpacingBetweenEdgesField = this.createDoubleField(4, 0.0, 9999.0);
        jPanel2.add(jLabel);
        jPanel2.add(this.createVerticalRigidArea(9));
        jPanel2.add(jLabel2);
        jPanel3.add((Component)this.verticalSpacingBetweenNodesField);
        jPanel3.add(this.createVerticalRigidArea(5));
        jPanel3.add((Component)this.verticalSpacingBetweenEdgesField);
        jPanel.add(jPanel2);
        jPanel.add(this.createHorizontalRigidArea(20));
        jPanel.add(jPanel3);
        this.createCompoundBorder(jPanel, "Vertical_Spacing", 0, 6, 5, 6);
        return jPanel;
    }

    protected JPanel makeLayoutQualityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.qualityDraftRadioButton = this.createRadioButton("Draft");
        this.qualityDefaultRadioButton = this.createRadioButton("Default");
        this.qualityProofRadioButton = this.createRadioButton("Proof");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.qualityDraftRadioButton);
        buttonGroup.add(this.qualityDefaultRadioButton);
        buttonGroup.add(this.qualityProofRadioButton);
        jPanel.add(this.qualityDraftRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityDefaultRadioButton);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(this.qualityProofRadioButton);
        this.createCompoundBorder(jPanel, "Layout_Quality", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeAspectRatioPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        this.aspectRatioAutomaticRadioButton = this.createRadioButton("Automatic", ASPECT_RATIO_AUTOMATIC);
        this.aspectRatioCustomRadioButton = this.createRadioButton("Custom:", ASPECT_RATIO_CUSTOM);
        this.aspectRatioDisabledRadioButton = this.createRadioButton("Disabled", ASPECT_RATIO_DISABLED);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.aspectRatioAutomaticRadioButton);
        buttonGroup.add(this.aspectRatioCustomRadioButton);
        buttonGroup.add(this.aspectRatioDisabledRadioButton);
        this.aspectRatioCustomField = this.createDoubleField(4, 1.0E-8, 9999.0);
        jPanel2.add(this.aspectRatioAutomaticRadioButton);
        jPanel3.add(this.aspectRatioCustomRadioButton);
        jPanel3.add(this.createHorizontalRigidArea(20));
        jPanel3.add((Component)this.aspectRatioCustomField);
        jPanel4.add(this.aspectRatioDisabledRadioButton);
        jPanel.add(jPanel2);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel3);
        jPanel.add(this.createVerticalRigidArea(5));
        jPanel.add(jPanel4);
        this.createCompoundBorder(jPanel, "Aspect_Ratio", 0, 6, 5, 5);
        return jPanel;
    }

    protected JPanel makeMiscPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentY(0.0f);
        this.fixNodeSizesCheckBox = this.createCheckbox("Fix_Node_Sizes");
        jPanel.add(this.fixNodeSizesCheckBox);
        this.createEmptyBorder(jPanel, 3, 2, 0, 0);
        return jPanel;
    }

    public void setValues(TSServiceInputData tSServiceInputData) {
        TSOrthogonalLayoutInputTailor tSOrthogonalLayoutInputTailor = new TSOrthogonalLayoutInputTailor(tSServiceInputData, (TSDGraph)this.getGraph());
        this.horizontalSpacingBetweenNodesField.setText(String.valueOf(tSOrthogonalLayoutInputTailor.getHorizontalSpacingBetweenNodes()));
        this.verticalSpacingBetweenNodesField.setText(String.valueOf(tSOrthogonalLayoutInputTailor.getVerticalSpacingBetweenNodes()));
        this.verticalSpacingBetweenEdgesField.setText(String.valueOf(tSOrthogonalLayoutInputTailor.getVerticalSpacingBetweenEdges()));
        this.horizontalSpacingBetweenEdgesField.setText(String.valueOf(tSOrthogonalLayoutInputTailor.getHorizontalSpacingBetweenEdges()));
        int n = tSOrthogonalLayoutInputTailor.getQuality();
        if (n == 0) {
            this.qualityDraftRadioButton.setSelected(true);
        } else if (n == 1) {
            this.qualityDefaultRadioButton.setSelected(true);
        } else {
            this.qualityProofRadioButton.setSelected(true);
        }
        TSEInteractiveLayoutInputTailor tSEInteractiveLayoutInputTailor = new TSEInteractiveLayoutInputTailor(tSServiceInputData, this.getGraph());
        if (!tSEInteractiveLayoutInputTailor.isOrthogonalAspectRatioSet()) {
            if (tSOrthogonalLayoutInputTailor.getAspectRatio() != 0.0) {
                this.aspectRatioCustomRadioButton.setSelected(true);
                this.onAspectRatioCustom();
            } else {
                this.aspectRatioDisabledRadioButton.setSelected(true);
                this.onAspectRatioDisabled();
            }
        } else if (tSEInteractiveLayoutInputTailor.getOrthogonalAspectRatio() == 2) {
            this.aspectRatioCustomRadioButton.setSelected(true);
            this.onAspectRatioCustom();
        } else if (tSEInteractiveLayoutInputTailor.getOrthogonalAspectRatio() == 1) {
            this.aspectRatioAutomaticRadioButton.setSelected(true);
            this.onAspectRatioAutomatic();
        } else {
            this.aspectRatioDisabledRadioButton.setSelected(true);
            this.onAspectRatioDisabled();
        }
        if (tSOrthogonalLayoutInputTailor.getAspectRatio() != 0.0) {
            this.aspectRatioCustomField.setText(String.valueOf(tSOrthogonalLayoutInputTailor.getAspectRatio()));
        } else {
            this.aspectRatioCustomField.setText("1.0");
        }
        this.fixNodeSizesCheckBox.setSelected(tSOrthogonalLayoutInputTailor.getKeepNodeSizes());
    }

    protected void onAspectRatioAutomatic() {
        this.disable((JComponent)this.aspectRatioCustomField);
    }

    protected void onAspectRatioCustom() {
        this.enable((JComponent)this.aspectRatioCustomField);
    }

    protected void onAspectRatioDisabled() {
        this.disable((JComponent)this.aspectRatioCustomField);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ASPECT_RATIO_AUTOMATIC)) {
            this.onAspectRatioAutomatic();
        } else if (string.equals(ASPECT_RATIO_CUSTOM)) {
            this.onAspectRatioCustom();
        } else if (string.equals(ASPECT_RATIO_DISABLED)) {
            this.onAspectRatioDisabled();
        }
        this.activateButtons();
    }

    public void onApply() {
        super.onApply();
        this.processDoubleField("layout:orthogonal:graph:horizontalSpacingBetweenNodes", this.horizontalSpacingBetweenNodesField);
        this.processDoubleField("layout:orthogonal:graph:verticalSpacingBetweenNodes", this.verticalSpacingBetweenNodesField);
        this.processDoubleField("layout:orthogonal:graph:verticalSpacingBetweenEdges", this.verticalSpacingBetweenEdgesField);
        this.processDoubleField("layout:orthogonal:graph:horizontalSpacingBetweenEdges", this.horizontalSpacingBetweenEdgesField);
        int n = this.qualityDraftRadioButton.isSelected() ? 0 : (this.qualityDefaultRadioButton.isSelected() ? 1 : 2);
        this.processChoices("layout:orthogonal:graph:quality", n);
        TSEInteractiveLayoutInputTailor tSEInteractiveLayoutInputTailor = new TSEInteractiveLayoutInputTailor(this.getServiceInputData(), this.getGraph());
        if (this.aspectRatioAutomaticRadioButton.isSelected()) {
            tSEInteractiveLayoutInputTailor.setOrthogonalAspectRatioAsAutomatic();
        } else if (this.aspectRatioCustomRadioButton.isSelected()) {
            tSEInteractiveLayoutInputTailor.setOrthogonalAspectRatioAsCustom();
            this.processDoubleField("layout:orthogonal:graph:aspectRatio", this.aspectRatioCustomField);
        } else {
            tSEInteractiveLayoutInputTailor.setOrthogonalAspectRatioAsDisabled();
        }
        this.processCheckbox("layout:orthogonal:graph:keepNodeSizes", this.fixNodeSizesCheckBox);
    }

    public int getLayoutStyle() {
        return 2;
    }
}

