/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor.service.layout.constraints;

import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.service.layout.constraints.TSEBaseLayoutConstraintsDialog;
import com.tomsawyer.editor.service.layout.constraints.TSELayoutConstraintTreeNode;
import com.tomsawyer.editor.service.layout.constraints.TSEListTreeNode;
import com.tomsawyer.service.layout.TSLayoutConstraint;
import javax.swing.JPopupMenu;

public abstract class TSEObjectTreeNode
extends TSELayoutConstraintTreeNode {
    TSEObject object;
    TSEListTreeNode parent;
    public static final String REMOVE = "Remove";

    public TSEObjectTreeNode(TSLayoutConstraint tSLayoutConstraint, TSEObject tSEObject, TSEBaseLayoutConstraintsDialog tSEBaseLayoutConstraintsDialog) {
        super(tSLayoutConstraint, tSEBaseLayoutConstraintsDialog);
        this.object = tSEObject;
        Object object = tSEObject.getTag();
        if (object != null) {
            this.setUserObject(object);
        } else {
            this.setUserObject(this.getDefaultName());
        }
        this.toolTip = this.createToolTip();
    }

    public void onSelect() {
        this.dialog.resetToolBar();
        this.dialog.addToToolbar(this.dialog.getRemoveButton());
        this.dialog.highlightSelectedObjects();
        if (this.dialog.supportMultipleStyles()) {
            this.dialog.stylesDialog.a(this.getConstraint());
        }
        this.dialog.getToolBar().revalidate();
        this.dialog.getToolBar().repaint();
    }

    public JPopupMenu getPopupMenu() {
        return this.dialog.getGraphObjectMenu();
    }

    public boolean isLeaf() {
        return true;
    }

    public TSEObject getObject() {
        return this.object;
    }

    public abstract String getDefaultName();

    void setParentNode(TSEListTreeNode tSEListTreeNode) {
        this.parent = tSEListTreeNode;
    }

    public TSEListTreeNode getParentNode() {
        return this.parent;
    }

    protected String createToolTip() {
        if (this.dialog.isShowingToolTips()) {
            return this.dialog.translateText("This_object_belongs_to") + " " + this.constraint.getName();
        }
        return null;
    }
}

