/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsfret.navigation.ClassMemberPanelUI;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private ClassMemberPanelUI ui;
    private volatile boolean canceled;

    public ElementScanningTask(ClassMemberPanelUI classMemberPanelUI) {
        this.ui = classMemberPanelUI;
    }

    public void cancel() {
        this.canceled = true;
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.canceled = false;
        final ArrayList<? extends StructureItem> arrayList = new ArrayList<StructureItem>();
        StructureItem structureItem = new StructureItem(){

            public String getName() {
                return null;
            }

            public String getHtml() {
                return null;
            }

            public ElementHandle getElementHandle() {
                throw new UnsupportedOperationException("Not supported on the Root Node.");
            }

            public ElementKind getKind() {
                return ElementKind.OTHER;
            }

            public Set<Modifier> getModifiers() {
                return Collections.emptySet();
            }

            public boolean isLeaf() {
                return false;
            }

            public List<? extends StructureItem> getNestedItems() {
                return arrayList;
            }

            public long getPosition() {
                return 0L;
            }

            public long getEndPosition() {
                return Long.MAX_VALUE;
            }

            public ImageIcon getCustomIcon() {
                return null;
            }

            public String getSortText() {
                return null;
            }
        };
        Set<String> set = compilationInfo.getEmbeddedMimeTypes();
        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
        ArrayList<String> arrayList2 = new ArrayList<String>(set);
        Collections.sort(arrayList2);
        ArrayList<MimetypeRootNode> arrayList3 = new ArrayList<MimetypeRootNode>();
        int n = 0;
        for (String object : set) {
            Language language = languageRegistry.getLanguageByMimeType(object);
            StructureScanner structureScanner = language.getStructure();
            if (structureScanner == null) continue;
            List list = structureScanner.scan((org.netbeans.modules.gsf.api.CompilationInfo)compilationInfo, (HtmlFormatter)new NavigatorFormatter());
            if (list.size() > 0) {
                ++n;
            }
            arrayList3.add(new MimetypeRootNode(language, list));
        }
        if (n > 1) {
            for (MimetypeRootNode mimetypeRootNode : arrayList3) {
                arrayList.add(mimetypeRootNode);
            }
        } else {
            for (MimetypeRootNode mimetypeRootNode : arrayList3) {
                arrayList.addAll(mimetypeRootNode.getNestedItems());
            }
        }
        if (!this.canceled) {
            this.ui.refresh(structureItem, compilationInfo.getFileObject());
        }
    }

    private class NavigatorFormatter
    extends GsfHtmlFormatter {
        private NavigatorFormatter() {
        }

        public void name(ElementKind elementKind, boolean bl) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MimetypeRootNode
    implements StructureItem {
        private static final String CSS_MIMETYPE = "text/x-css";
        private static final String CSS_SORT_TEXT = "2";
        private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
        private static final String JAVASCRIPT_SORT_TEXT = "1";
        private static final String HTML_MIMETYPE = "text/html";
        private static final String HTML_SORT_TEXT = "3";
        private static final String OTHER_SORT_TEXT = "4";
        private Language language;
        private List<? extends StructureItem> items;
        long from;
        long to;

        private MimetypeRootNode(Language language, List<? extends StructureItem> list) {
            this.language = language;
            this.items = list;
            this.from = list.size() > 0 ? list.get(0).getPosition() : 0L;
            this.to = list.size() > 0 ? list.get(list.size() - 1).getEndPosition() : 0L;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MimetypeRootNode)) {
                return false;
            }
            MimetypeRootNode mimetypeRootNode = (MimetypeRootNode)object;
            return this.language.equals(mimetypeRootNode.language);
        }

        public int hashCode() {
            int n = 3;
            n = 97 * n + (this.language != null ? this.language.hashCode() : 0);
            return n;
        }

        public String getName() {
            return this.language.getDisplayName();
        }

        public String getSortText() {
            if (this.language.getMimeType().equals(CSS_MIMETYPE)) {
                return CSS_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(JAVASCRIPT_MIMETYPE)) {
                return JAVASCRIPT_SORT_TEXT;
            }
            if (this.language.getMimeType().equals(HTML_MIMETYPE)) {
                return HTML_SORT_TEXT;
            }
            return OTHER_SORT_TEXT + this.getName();
        }

        public String getHtml() {
            return this.getName();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return false;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.items;
        }

        public long getPosition() {
            return this.from;
        }

        public long getEndPosition() {
            return this.to;
        }

        public ImageIcon getCustomIcon() {
            String string = this.language.getIconBase();
            return string == null ? null : new ImageIcon(Utilities.loadImage((String)string));
        }
    }
}

