/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyVetoException;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsfret.navigation.ClassMemberFilters;
import org.netbeans.modules.gsfret.navigation.ElementNode;
import org.netbeans.modules.gsfret.navigation.ElementScanningTask;
import org.netbeans.modules.gsfret.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.gsfret.navigation.actions.SortActionSupport;
import org.netbeans.modules.gsfret.navigation.base.FiltersManager;
import org.netbeans.modules.gsfret.navigation.base.TapPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private ClassMemberFilters filters;
    private Action[] actions;
    private static final Rectangle ZERO = new Rectangle(0, 0, 1, 1);

    public ClassMemberPanelUI(Language language) {
        String string;
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String string2 = Utilities.keyToString((KeyStroke)keyStroke);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)string2));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        this.filtersPanel.add(this.filters.getComponent());
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        boolean bl = true;
        if (language != null && ((string = language.getMimeType()).equals("text/html") || string.equals("text/x-css") || string.equals("text/x-jsp") || string.equals("application/x-httpd-eruby"))) {
            bl = false;
            this.filters.disableFiltering = true;
        }
        if (bl) {
            this.add((Component)this.filtersPanel, "South");
        }
        this.manager.setRootContext(ElementNode.getWaitNode());
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return bl;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
            }
        });
    }

    public void selectElementNode(int n) {
        ElementNode elementNode = this.getRootNode();
        if (elementNode == null) {
            return;
        }
        ElementNode elementNode2 = elementNode.getNodeForOffset(n);
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1 || nodeArray[0] != elementNode2) {
            try {
                this.manager.setSelectedNodes(new Node[]{elementNode2 == null ? this.getRootNode() : elementNode2});
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    public void refresh(final StructureItem structureItem, final FileObject fileObject) {
        final ElementNode elementNode = this.getRootNode();
        if (elementNode != null && elementNode.getFileObject().equals(fileObject)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    elementNode.updateRecursively(structureItem);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(structureItem, ClassMemberPanelUI.this, fileObject));
                    boolean bl = ClassMemberPanelUI.this.elementView.getScrollOnExpand();
                    ClassMemberPanelUI.this.elementView.setScrollOnExpand(false);
                    ClassMemberPanelUI.this.elementView.expandAll();
                    ClassMemberPanelUI.this.elementView.setScrollOnExpand(bl);
                }
            });
        }
    }

    public void sort() {
        this.getRootNode().refreshRecursively();
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node node) {
        this.elementView.expandNode(node);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getFileObject();
    }

    public void filterStateChanged(ChangeEvent changeEvent) {
        ElementNode elementNode = this.getRootNode();
        if (elementNode != null) {
            elementNode.refreshRecursively();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node node = this.manager.getRootContext();
        if (node instanceof ElementNode) {
            return (ElementNode)node;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView myBeanTreeView = new MyBeanTreeView();
        return myBeanTreeView;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean bl) {
            this.tree.setScrollsOnExpand(bl);
        }
    }
}

