/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.hints.infrastructure;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.support.CaretAwareSourceTaskFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsTask
extends ScanningCancellableTask<CompilationInfo> {
    static HintsProvider getHintsProvider(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getHintsProvider() == null) continue;
            return language.getHintsProvider();
        }
        return null;
    }

    @Override
    public void run(CompilationInfo compilationInfo) throws Exception {
        this.resume();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return;
        }
        int n = CaretAwareSourceTaskFactory.getLastPosition(compilationInfo.getFileObject());
        if (n == -1) {
            return;
        }
        HintsProvider hintsProvider = SuggestionsTask.getHintsProvider(document, n);
        if (hintsProvider == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        hintsProvider.computeSuggestions((org.netbeans.modules.gsf.api.CompilationInfo)compilationInfo, arrayList, n);
        if (this.isCancelled()) {
            return;
        }
        HintsController.setErrors((FileObject)compilationInfo.getFileObject(), (String)SuggestionsTask.class.getName(), arrayList);
    }
}

