/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.SemanticAnalyzer;
import org.netbeans.modules.gsfret.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.gsfret.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.gsfret.editor.semantic.Utilities;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticHighlighter
extends ScanningCancellableTask<CompilationInfo> {
    private FileObject file;

    SemanticHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), iOException);
            return null;
        }
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot get document!");
            return;
        }
        Set<Highlight> set = this.process(compilationInfo, document);
        if (this.isCancelled()) {
            return;
        }
        Highlighter.getDefault().setHighlights(this.file, "semantic", set);
        OccurrencesMarkProvider.get(document).setSematic(set);
    }

    Set<Highlight> process(CompilationInfo compilationInfo, Document document) {
        if (this.isCancelled()) {
            return Collections.emptySet();
        }
        long l = System.currentTimeMillis();
        HashSet<Highlight> hashSet = new HashSet<Highlight>();
        Set<String> set = compilationInfo.getEmbeddedMimeTypes();
        LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
        for (String string : set) {
            SemanticAnalyzer semanticAnalyzer;
            Language language = languageRegistry.getLanguageByMimeType(string);
            if (language == null || (semanticAnalyzer = language.getSemanticAnalyzer()) == null) continue;
            try {
                semanticAnalyzer.run((Object)compilationInfo);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            if (this.isCancelled()) {
                semanticAnalyzer.cancel();
                return Collections.emptySet();
            }
            Map map = semanticAnalyzer.getHighlights();
            if (map == null) continue;
            for (OffsetRange offsetRange : map.keySet()) {
                if (this.isCancelled()) {
                    return hashSet;
                }
                ColoringAttributes coloringAttributes = (ColoringAttributes)map.get(offsetRange);
                if (coloringAttributes == null) continue;
                List<ColoringAttributes> list = Collections.singletonList(coloringAttributes);
                Highlight highlight = Utilities.createHighlight(language, document, offsetRange.getStart(), offsetRange.getEnd(), list, null);
                if (highlight == null) continue;
                hashSet.add(highlight);
            }
        }
        return hashSet;
    }
}

