/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsfret.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.gsfret.editor.semantic.MethodExitDetector;
import org.netbeans.modules.gsfret.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.gsfret.editor.semantic.Utilities;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;
    private MethodExitDetector exitDetector;

    MarkOccurencesHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public Document getDocument() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.file);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return null;
            }
            return editorCookie.getDocument();
        }
        catch (IOException iOException) {
            Logger.global.log(Level.INFO, "SemanticHighlighter: Cannot find DataObject for file: " + FileUtil.getFileDisplayName((FileObject)this.file), iOException);
            return null;
        }
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        Document document = this.getDocument();
        if (document == null) {
            Logger.global.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
            return;
        }
        long l = System.currentTimeMillis();
        int n = MarkOccurrencesHighlighterFactory.getLastPosition(this.file);
        if (this.isCancelled()) {
            return;
        }
        Set<Highlight> set = this.processImpl(compilationInfo, document, n);
        if (this.isCancelled()) {
            return;
        }
        Highlighter.getDefault().setHighlights(this.file, "occurrences", set);
        OccurrencesMarkProvider.get(document).setOccurrences(set);
    }

    private boolean isIn(int n, int[] nArray) {
        return nArray[0] <= n && n <= nArray[1];
    }

    Set<Highlight> processImpl(CompilationInfo compilationInfo, Document document, int n) {
        HashSet<Highlight> hashSet = null;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)document, n);
        Language language = null;
        for (Language language2 : list) {
            if (language2.getOccurrencesFinder() == null) continue;
            language = language2;
            break;
        }
        if (language != null) {
            Language language2;
            OccurrencesFinder occurrencesFinder = language.getOccurrencesFinder();
            assert (occurrencesFinder != null);
            occurrencesFinder.setCaretPosition(n);
            language2 = occurrencesFinder;
            if (language2 != null) {
                Map map;
                try {
                    language2.run((Object)compilationInfo);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                if (this.isCancelled()) {
                    language2.cancel();
                }
                if ((map = language2.getOccurrences()) != null) {
                    for (OffsetRange offsetRange : map.keySet()) {
                        if (this.isCancelled()) {
                            return Collections.EMPTY_SET;
                        }
                        ColoringAttributes coloringAttributes = (ColoringAttributes)map.get(offsetRange);
                        List<ColoringAttributes> list2 = Collections.singletonList(coloringAttributes);
                        Highlight highlight = Utilities.createHighlight(language, document, offsetRange.getStart(), offsetRange.getEnd(), list2, null);
                        if (highlight == null) continue;
                        if (hashSet == null) {
                            hashSet = new HashSet<Highlight>();
                        }
                        hashSet.add(highlight);
                    }
                }
            }
        }
        if (hashSet != null) {
            return hashSet;
        }
        return Collections.emptySet();
    }

    public final synchronized void cancel() {
        this.canceled = true;
        if (this.exitDetector != null) {
            // empty if block
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }
}

