/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.hyperlink;

import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Completable;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.gsfret.editor.hyperlink.DeclarationPopup;
import org.netbeans.modules.gsfret.editor.hyperlink.PopupUtil;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoToSupport {
    static final boolean IM_FEELING_LUCKY = Boolean.getBoolean("gsf.im_feeling_lucky");

    private GoToSupport() {
    }

    public static String getGoToElementTooltip(Document document, int n) {
        return GoToSupport.perform(document, n, true);
    }

    public static String performGoTo(Document document, int n) {
        return GoToSupport.perform(document, n, false);
    }

    private static String perform(final Document document, final int n, final boolean bl) {
        if (SourceUtils.isScanInProgress()) {
            if (!bl) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GsfCompletionProvider.class, (String)"scanning-in-progress"));
                Toolkit.getDefaultToolkit().beep();
            }
            return null;
        }
        if (bl && PopupUtil.isPopupShowing()) {
            return null;
        }
        try {
            FileObject fileObject = GoToSupport.getFileObject(document);
            if (fileObject == null) {
                return null;
            }
            Source source = Source.forFileObject(fileObject);
            final String[] stringArray = new String[1];
            source.runUserActionTask(new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    Language language;
                    if (compilationController.toPhase(Phase.RESOLVED).compareTo(Phase.RESOLVED) < 0) {
                        return;
                    }
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)document, n);
                    Language language2 = null;
                    DeclarationFinder declarationFinder = list.iterator();
                    while (declarationFinder.hasNext()) {
                        language = declarationFinder.next();
                        if (language.getDeclarationFinder() == null) continue;
                        language2 = language;
                        break;
                    }
                    if (language2 != null && (declarationFinder = language2.getDeclarationFinder()) != null) {
                        GoToSupport.getIdentifierSpan(document, n);
                        language = declarationFinder.findDeclaration((CompilationInfo)compilationController, n);
                        if (bl) {
                            String string;
                            ElementHandle elementHandle;
                            Completable completable = language2.getCompletionProvider();
                            if (language != DeclarationFinder.DeclarationLocation.NONE && completable != null && (elementHandle = language.getElement()) != null && (string = completable.document((CompilationInfo)compilationController, elementHandle)) != null) {
                                stringArray[0] = "<html><body>" + string;
                            }
                            return;
                        }
                        if (language != DeclarationFinder.DeclarationLocation.NONE) {
                            URL uRL = language.getUrl();
                            String string = language.getInvalidMessage();
                            if (uRL != null) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                            } else {
                                if (string != null) {
                                    StatusDisplayer.getDefault().setStatusText(string);
                                    Toolkit.getDefaultToolkit().beep();
                                    return;
                                }
                                if (!IM_FEELING_LUCKY && language.getAlternativeLocations().size() > 0 && !PopupUtil.isPopupShowing() && GoToSupport.chooseAlternatives(document, n, language.getAlternativeLocations())) {
                                    return;
                                }
                                UiUtils.open(language.getFileObject(), language.getOffset());
                                String string2 = "Description not yet implemented";
                                stringArray[0] = "<html><body>" + string2;
                            }
                            return;
                        }
                    }
                    Toolkit.getDefaultToolkit().beep();
                    stringArray[0] = null;
                }
            }, true);
            return stringArray[0];
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    private static JTextComponent findEditor(Document document) {
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent.getDocument() == document) {
            return jTextComponent;
        }
        List list = EditorRegistry.componentList();
        for (JTextComponent jTextComponent2 : list) {
            if (jTextComponent.getDocument() != document) continue;
            return jTextComponent;
        }
        return null;
    }

    private static boolean chooseAlternatives(Document document, int n, List<DeclarationFinder.AlternativeLocation> list) {
        Object object;
        Collections.sort(list);
        int n2 = 30;
        String string = "";
        GsfHtmlFormatter gsfHtmlFormatter = new GsfHtmlFormatter();
        int n3 = 0;
        ArrayList<DeclarationFinder.AlternativeLocation> arrayList = new ArrayList<DeclarationFinder.AlternativeLocation>(list.size());
        for (Object object2 : list) {
            object = object2.getDisplayHtml((HtmlFormatter)gsfHtmlFormatter);
            if (((String)object).equals(string)) continue;
            arrayList.add((DeclarationFinder.AlternativeLocation)object2);
            string = object;
            if (++n3 != n2) continue;
            break;
        }
        if ((list = arrayList).size() <= 1) {
            return false;
        }
        JTextComponent jTextComponent = GoToSupport.findEditor(document);
        if (jTextComponent != null) {
            try {
                Object object2;
                object2 = jTextComponent.modelToView(n);
                object = new Point(object2.x, object2.y + object2.height);
                SwingUtilities.convertPointToScreen((Point)object, jTextComponent);
                String string2 = NbBundle.getMessage(GoToSupport.class, (String)"ChooseDecl");
                PopupUtil.showPopup(new DeclarationPopup(string2, list), string2, ((Point)object).x, ((Point)object).y, true, 0);
                return true;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return false;
    }

    private static FileObject getFileObject(Document document) {
        DataObject dataObject = (DataObject)document.getProperty("stream");
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        return GoToSupport.getIdentifierSpan(document, n);
    }

    public static int[] getIdentifierSpan(Document document, int n) {
        Language language3;
        FileObject fileObject = GoToSupport.getFileObject(document);
        if (fileObject == null) {
            return null;
        }
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)document, n);
        Language language2 = null;
        for (Language language3 : list) {
            if (language3.getDeclarationFinder() == null) continue;
            language2 = language3;
            break;
        }
        if (language2 == null) {
            return null;
        }
        DeclarationFinder declarationFinder = language2.getDeclarationFinder();
        assert (declarationFinder != null);
        language3 = declarationFinder.getReferenceSpan(document, n);
        if (language3 != OffsetRange.NONE) {
            return new int[]{language3.getStart(), language3.getEnd()};
        }
        return null;
    }
}

