/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GsfCompletionItem
implements CompletionItem {
    static CompletionProposal tipProposal;
    protected CompilationInfo info;
    protected static int SMART_TYPE;
    public static final String COLOR_END = "</font>";
    public static final String STRIKE = "<s>";
    public static final String STRIKE_END = "</s>";
    public static final String BOLD = "<b>";
    public static final String BOLD_END = "</b>";
    protected int substitutionOffset;
    private static final int PUBLIC_LEVEL = 3;
    private static final int PROTECTED_LEVEL = 2;
    private static final int PACKAGE_LEVEL = 1;
    private static final int PRIVATE_LEVEL = 0;

    public static final GsfCompletionItem createItem(CompletionProposal completionProposal, CompilationInfo compilationInfo) {
        return new DelegatedItem(compilationInfo, completionProposal);
    }

    private GsfCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (this.getInsertPrefix().length() == 0) {
                return;
            }
            Completion.get().hideAll();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            switch (keyEvent.getKeyChar()) {
                case '\n': 
                case '(': 
                case ',': 
                case '.': 
                case ';': {
                    Completion.get().hideAll();
                }
            }
        }
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        this.defaultAction(jTextComponent);
        return true;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    protected abstract ImageIcon getIcon();

    protected String getLeftHtmlText() {
        return null;
    }

    protected String getRightHtmlText() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string2 = ((Object)this.getInsertPrefix()).toString();
        if (string2 != null) {
            int n3 = -2;
            baseDocument.atomicLock();
            try {
                String string3 = baseDocument.getText(n, n2);
                if (string2.equals(string3)) {
                    if (n3 > -1) {
                        baseDocument.insertString(n3, ";", null);
                    }
                    return;
                }
                Position position = baseDocument.createPosition(n);
                Position position2 = n3 > -1 ? baseDocument.createPosition(n3) : null;
                baseDocument.remove(n, n2);
                baseDocument.insertString(position.getOffset(), string2, null);
                if (position2 != null) {
                    baseDocument.insertString(position2.getOffset(), ";", null);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    private static String truncateRhs(String string, int n) {
        if (string != null) {
            int n2 = 80 - n;
            if (n2 < 10) {
                n2 = 10;
            }
            if (string != null && string.length() > n2) {
                string = string.substring(0, n2 - 3) + "<b>&gt;</b>";
            }
        }
        return string;
    }

    private static int getProtectionLevel(Set<Modifier> set) {
        if (set.contains(Modifier.PUBLIC)) {
            return 3;
        }
        if (set.contains(Modifier.PROTECTED)) {
            return 2;
        }
        if (set.contains(Modifier.PRIVATE)) {
            return 0;
        }
        return 1;
    }

    static {
        SMART_TYPE = 1000;
    }

    private static class DelegatedItem
    extends GsfCompletionItem {
        private CompletionProposal item;
        private static ImageIcon[][] icon = new ImageIcon[2][4];

        private DelegatedItem(CompilationInfo compilationInfo, CompletionProposal completionProposal) {
            super(completionProposal.getAnchorOffset());
            this.item = completionProposal;
            this.info = compilationInfo;
        }

        public int getSortPriority() {
            switch (this.item.getKind()) {
                case ERROR: {
                    return -5000;
                }
                case DB: {
                    return this.item.isSmart() ? 155 - SMART_TYPE : 155;
                }
                case PARAMETER: {
                    return this.item.isSmart() ? 105 - SMART_TYPE : 105;
                }
                case CALL: {
                    return this.item.isSmart() ? 110 - SMART_TYPE : 110;
                }
                case CONSTRUCTOR: {
                    return this.item.isSmart() ? 400 - SMART_TYPE : 400;
                }
                case PACKAGE: 
                case MODULE: {
                    return this.item.isSmart() ? 900 - SMART_TYPE : 900;
                }
                case CLASS: {
                    return this.item.isSmart() ? 800 - SMART_TYPE : 800;
                }
                case ATTRIBUTE: 
                case RULE: {
                    return this.item.isSmart() ? 482 - SMART_TYPE : 482;
                }
                case TAG: {
                    return this.item.isSmart() ? 480 - SMART_TYPE : 480;
                }
                case PROPERTY: 
                case METHOD: {
                    return this.item.isSmart() ? 500 - SMART_TYPE : 500;
                }
                case FIELD: {
                    return this.item.isSmart() ? 300 - SMART_TYPE : 300;
                }
                case CONSTANT: 
                case GLOBAL: 
                case VARIABLE: {
                    return this.item.isSmart() ? 200 - SMART_TYPE : 200;
                }
                case KEYWORD: {
                    return this.item.isSmart() ? 600 - SMART_TYPE : 600;
                }
            }
            return this.item.isSmart() ? 999 - SMART_TYPE : 999;
        }

        public boolean instantSubstitution(JTextComponent jTextComponent) {
            return false;
        }

        public CharSequence getSortText() {
            return this.item.getSortText();
        }

        public CharSequence getInsertPrefix() {
            return this.item.getInsertPrefix();
        }

        protected String getLeftHtmlText() {
            return this.item.getLhsHtml();
        }

        public String toString() {
            return this.item.getName();
        }

        protected String getRightHtmlText() {
            String string = this.item.getRhsHtml();
            String string2 = this.item.getLhsHtml();
            boolean bl = false;
            int n = 0;
            int n2 = string2.length();
            for (int i = 0; i < n2; ++i) {
                char c = string2.charAt(i);
                if (bl) {
                    if (c != '>') continue;
                    bl = false;
                    continue;
                }
                if (c == '<') {
                    bl = true;
                    continue;
                }
                ++n;
            }
            return GsfCompletionItem.truncateRhs(string, n);
        }

        public CompletionTask createDocumentationTask() {
            ElementHandle elementHandle = this.item.getElement();
            if (elementHandle != null) {
                return GsfCompletionProvider.createDocTask(elementHandle, this.info);
            }
            return null;
        }

        protected ImageIcon getIcon() {
            ImageIcon imageIcon = this.item.getIcon();
            if (imageIcon != null) {
                return imageIcon;
            }
            ImageIcon imageIcon2 = Icons.getElementIcon(this.item.getKind(), this.item.getModifiers());
            return imageIcon2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
            String string2 = this.item.getCustomInsertTemplate();
            if (string2 != null) {
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
                if (codeTemplateManager != null) {
                    baseDocument.atomicLock();
                    try {
                        baseDocument.remove(n, n2);
                        jTextComponent.getCaret().setDot(n);
                    }
                    catch (BadLocationException badLocationException) {
                    }
                    finally {
                        baseDocument.atomicUnlock();
                    }
                    codeTemplateManager.createTemporary(string2).insert(jTextComponent);
                    Completion.get().showToolTip();
                }
                return;
            }
            List list = this.item.getInsertParams();
            if (list == null || list.size() == 0) {
                super.substituteText(jTextComponent, n, n2, string);
                return;
            }
            super.substituteText(jTextComponent, n, n2, string);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            CodeTemplateManager codeTemplateManager = CodeTemplateManager.get((Document)baseDocument);
            if (codeTemplateManager != null) {
                StringBuilder stringBuilder = new StringBuilder();
                String[] stringArray = this.item.getParamListDelimiters();
                assert (stringArray.length == 2);
                stringBuilder.append(stringArray[0]);
                int n3 = 1;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    stringBuilder.append("${");
                    stringBuilder.append("gsf-cc-");
                    stringBuilder.append(Integer.toString(n3++));
                    stringBuilder.append(" default=\"");
                    stringBuilder.append(string3);
                    stringBuilder.append("\"");
                    stringBuilder.append("}");
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[1]);
                stringBuilder.append("${cursor}");
                codeTemplateManager.createTemporary(stringBuilder.toString()).insert(jTextComponent);
                Completion.get().showToolTip();
            }
        }
    }
}

