/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;

public class GsfCompletionDoc
implements CompletionDocumentation {
    private String content = null;
    private URL docURL = null;
    private AbstractAction goToSource = null;
    private ElementHandle elementHandle;
    private Language language;
    private CompilationController controller;

    private GsfCompletionDoc(final CompilationController compilationController, final ElementHandle elementHandle, URL uRL) {
        Object object;
        this.controller = compilationController;
        this.language = compilationController.getLanguage();
        if (elementHandle != null && elementHandle.getMimeType() != null && (object = LanguageRegistry.getInstance().getLanguageByMimeType(elementHandle.getMimeType())) != null && object.getParser() != null) {
            this.language = object;
        }
        object = this.language.getCompletionProvider();
        this.elementHandle = elementHandle;
        if (elementHandle != null) {
            this.goToSource = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Completion.get().hideAll();
                    UiUtils.open(compilationController.getSource(), elementHandle);
                }
            };
            this.docURL = uRL != null ? uRL : null;
        }
        this.content = object.document((CompilationInfo)compilationController, elementHandle);
        if (this.content == null) {
            Completion.get().hideDocumentation();
        }
    }

    public static final GsfCompletionDoc create(CompilationController compilationController, ElementHandle elementHandle) {
        return new GsfCompletionDoc(compilationController, elementHandle, null);
    }

    public String getText() {
        return this.content;
    }

    public URL getURL() {
        return this.docURL;
    }

    public CompletionDocumentation resolveLink(String string) {
        ElementHandle elementHandle;
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.matches("[a-z]+://.*")) {
            try {
                URL uRL = new URL(string);
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
        if ((elementHandle = this.language.getCompletionProvider().resolveLink(string, this.elementHandle)) != null) {
            return new GsfCompletionDoc(this.controller, elementHandle, null);
        }
        return null;
    }

    public Action getGotoSourceAction() {
        return this.goToSource;
    }
}

