/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.HintsProvider;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class GsfTaskProvider
extends PushTaskScanner {
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private static final String TASKLIST_ERROR = "nb-tasklist-error";
    private static final String TASKLIST_WARNING = "nb-tasklist-warning";
    private static final String TASKLIST_ERROR_HINT = "nb-tasklist-errorhint";
    private static final String TASKLIST_WARNING_HINT = "nb-tasklist-warninghint";
    private static final Set<RequestProcessor.Task> TASKS = new HashSet<RequestProcessor.Task>();
    private static boolean clearing;
    private static final RequestProcessor WORKER;
    private static GsfTaskProvider INSTANCE;

    public GsfTaskProvider() {
        this(LanguageRegistry.getInstance().getLanguagesDisplayName());
        INSTANCE = this;
    }

    private GsfTaskProvider(String string) {
        super(NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasks", (Object)string), NbBundle.getMessage(GsfTaskProvider.class, (String)"GsfTasksDesc", (Object)string), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setScope(TaskScanningScope taskScanningScope, PushTaskScanner.Callback callback) {
        GsfTaskProvider.cancelAllCurrent();
        Iterator iterator = TASKS;
        synchronized (iterator) {
            this.scope = taskScanningScope;
            this.callback = callback;
        }
        if (taskScanningScope == null || callback == null) {
            return;
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(FileObject.class)) {
            GsfTaskProvider.enqueue(new Work(fileObject, callback));
        }
        for (FileObject fileObject : taskScanningScope.getLookup().lookupAll(Project.class)) {
            for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)fileObject).getSourceGroups("generic")) {
                GsfTaskProvider.enqueue(new Work(sourceGroup.getRootFolder(), callback));
            }
        }
    }

    public static void refresh(FileObject fileObject) {
        if (INSTANCE != null) {
            INSTANCE.refreshImpl(fileObject);
        }
    }

    private synchronized void refreshImpl(FileObject fileObject) {
        if (this.scope == null || this.callback == null) {
            return;
        }
        if (!this.scope.isInScope(fileObject)) {
            if (!fileObject.isFolder()) {
                return;
            }
            for (FileObject fileObject2 : this.scope.getLookup().lookupAll(FileObject.class)) {
                if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2)) continue;
                GsfTaskProvider.enqueue(new Work(fileObject2, this.callback));
            }
            return;
        }
        GsfTaskProvider.enqueue(new Work(fileObject, this.callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enqueue(Work work) {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                GsfTaskProvider.INSTANCE.callback.started();
            }
            RequestProcessor.Task task = WORKER.post((Runnable)work);
            TASKS.add(task);
            task.addTaskListener(new TaskListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void taskFinished(org.openide.util.Task task) {
                    Set set = TASKS;
                    synchronized (set) {
                        if (!clearing) {
                            TASKS.remove(task);
                            if (INSTANCE != null && TASKS.size() == 0 && INSTANCE.callback != null) {
                                INSTANCE.callback.finished();
                            }
                        }
                    }
                }
            });
            if (task.isFinished()) {
                TASKS.remove(task);
                if (INSTANCE != null && TASKS.size() == 0 && GsfTaskProvider.INSTANCE.callback != null) {
                    GsfTaskProvider.INSTANCE.callback.finished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelAllCurrent() {
        Set<RequestProcessor.Task> set = TASKS;
        synchronized (set) {
            clearing = true;
            try {
                for (RequestProcessor.Task task : TASKS) {
                    task.cancel();
                }
                TASKS.clear();
            }
            finally {
                clearing = false;
            }
        }
    }

    private static String severityToTaskListString(org.netbeans.spi.editor.hints.Severity severity) {
        return severity == org.netbeans.spi.editor.hints.Severity.ERROR ? TASKLIST_ERROR_HINT : TASKLIST_WARNING_HINT;
    }

    static {
        WORKER = new RequestProcessor("GSF Task Provider");
    }

    private static final class Work
    implements Runnable {
        private FileObject fileOrRoot;
        private PushTaskScanner.Callback callback;

        public Work(FileObject fileObject, PushTaskScanner.Callback callback) {
            this.fileOrRoot = fileObject;
            this.callback = callback;
        }

        public FileObject getFileOrRoot() {
            return this.fileOrRoot;
        }

        public PushTaskScanner.Callback getCallback() {
            return this.callback;
        }

        public void run() {
            FileObject fileObject = this.getFileOrRoot();
            this.refreshFile(fileObject);
        }

        private void refreshFile(final FileObject fileObject) {
            Object object;
            if (fileObject.isFolder()) {
                if (fileObject.getName().equals("vendor") && fileObject.getParent().getFileObject("nbproject") != null) {
                    return;
                }
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.refreshFile(fileObject2);
                }
                return;
            }
            final LanguageRegistry languageRegistry = LanguageRegistry.getInstance();
            List<Language> list = languageRegistry.getApplicableLanguages(fileObject.getMIMEType());
            boolean bl = false;
            for (Language object22 : list) {
                object = object22.getHintsProvider();
                if (object == null) continue;
                bl = true;
            }
            if (!bl) {
                return;
            }
            final ArrayList arrayList = new ArrayList();
            Source source = Source.forFileObject(fileObject);
            if (source == null) {
                return;
            }
            object = new ArrayList();
            CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>((List)object){
                final /* synthetic */ List val$tasks;
                {
                    this.val$tasks = list2;
                }

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    UiUtils.getDocument(compilationController.getFileObject(), true);
                    compilationController.toPhase(Phase.RESOLVED);
                    for (String string : compilationController.getEmbeddedMimeTypes()) {
                        Collection<? extends ParserResult> collection = compilationController.getEmbeddedResults(string);
                        for (ParserResult parserResult : collection) {
                            Language language = languageRegistry.getLanguageByMimeType(string);
                            HintsProvider hintsProvider = language.getHintsProvider();
                            if (hintsProvider == null) continue;
                            List list = hintsProvider.computeErrors((CompilationInfo)compilationController, arrayList);
                            hintsProvider.computeHints((CompilationInfo)compilationController, arrayList);
                            for (Error error : list) {
                                try {
                                    int n;
                                    int n2 = error.getStartPosition();
                                    if (parserResult.getTranslatedSource() != null) {
                                        n = parserResult.getTranslatedSource().getLexicalOffset(n2);
                                        if (n == -1) {
                                            continue;
                                        }
                                    } else {
                                        n = n2;
                                    }
                                    int n3 = NbDocument.findLineNumber((StyledDocument)((StyledDocument)compilationController.getDocument()), (int)n) + 1;
                                    Task task = Task.create((FileObject)fileObject, (String)(error.getSeverity() == Severity.ERROR ? GsfTaskProvider.TASKLIST_ERROR : GsfTaskProvider.TASKLIST_WARNING), (String)error.getDisplayName(), (int)n3);
                                    this.val$tasks.add(task);
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                        }
                    }
                }
            };
            try {
                source.runUserActionTask(cancellableTask, true);
            }
            catch (IOException iterator) {
                Exceptions.printStackTrace((Throwable)iterator);
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ErrorDescription errorDescription = (ErrorDescription)iterator.next();
                try {
                    Task iOException = Task.create((FileObject)fileObject, (String)GsfTaskProvider.severityToTaskListString(errorDescription.getSeverity()), (String)errorDescription.getDescription(), (int)(errorDescription.getRange().getBegin().getLine() + 1));
                    object.add(iOException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.callback.setTasks(fileObject, (List)object);
        }
    }
}

