/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.gsf.GsfEditorKitFactory;
import org.openide.util.NbBundle;

public abstract class AbstractCamelCasePosition
extends BaseAction {
    private Action originalAction;

    public AbstractCamelCasePosition(String string, Action action) {
        super(string, 2);
        Object object;
        if (action != null && (object = action.getValue("Name")) instanceof String) {
            this.putValue("Name", object);
            this.originalAction = action;
        }
        if ((object = this.getShortDescription()) != null) {
            this.putValue("ShortDescription", object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent == null) return;
        if (this.originalAction != null && !this.isUsingCamelCase()) {
            if (this.originalAction instanceof BaseAction) {
                ((BaseAction)this.originalAction).actionPerformed(actionEvent, jTextComponent);
                return;
            } else {
                this.originalAction.actionPerformed(actionEvent);
            }
            return;
        } else {
            BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
            if (baseDocument != null) {
                baseDocument.atomicLock();
                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                try {
                    int n = this.newOffset(jTextComponent);
                    if (n == -1) return;
                    this.moveToNewOffset(jTextComponent, n);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                finally {
                    DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                    baseDocument.atomicUnlock();
                }
            } else {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    protected abstract int newOffset(JTextComponent var1) throws BadLocationException;

    protected abstract void moveToNewOffset(JTextComponent var1, int var2) throws BadLocationException;

    public String getShortDescription() {
        String string;
        String string2 = (String)this.getValue("Name");
        if (string2 == null) {
            return null;
        }
        try {
            string = NbBundle.getBundle(GsfEditorKitFactory.class).getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            string = string2;
        }
        return string;
    }

    private boolean isUsingCamelCase() {
        return !Boolean.getBoolean("no-ruby-camel-case-style-navigation");
    }
}

