/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard.steps;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.screen.NullWizardScreen;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.NullWizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStepVisitor;

public class ProxyWizardStep
implements WizardStep {
    private ConditionalFunctor condition;
    private WizardContext context;
    private WizardStep nullStep;
    private WizardStep proxiedStep;

    public ProxyWizardStep(WizardContext wizardContext, String string) {
        this(wizardContext, string, new TrueConditionalFunctor());
    }

    public ProxyWizardStep(WizardContext wizardContext, String string, ConditionalFunctor conditionalFunctor) {
        this.proxiedStep = this.nullStep = new NullWizardStep(string);
        this.context = wizardContext;
        this.condition = conditionalFunctor;
    }

    public WizardScreen getAttachedScreen() {
        if (this.canHandle()) {
            return this.proxiedStep.getAttachedScreen();
        }
        return new NullWizardScreen();
    }

    public boolean isBegin() {
        return !this.canHandle() || this.proxiedStep.isBegin();
    }

    public void setCurrent() {
        if (this.canHandle()) {
            this.proxiedStep.setCurrent();
        }
    }

    public boolean isCurrent() {
        return this.canHandle() && this.proxiedStep.isCurrent();
    }

    public boolean isEnd() {
        return !this.canHandle() || this.proxiedStep.isEnd();
    }

    public void setFirst() {
        if (this.canHandle()) {
            this.proxiedStep.setFirst();
        }
    }

    public boolean isFirst() {
        return this.canHandle() && this.proxiedStep.isFirst();
    }

    public void setLast() {
        if (this.canHandle()) {
            this.proxiedStep.setLast();
        }
    }

    public boolean isLast() {
        return this.canHandle() && this.proxiedStep.isLast();
    }

    public void setNext() {
        if (this.canHandle()) {
            this.proxiedStep.setNext();
        }
    }

    public void setPrevious() {
        if (this.canHandle()) {
            this.proxiedStep.setPrevious();
        }
    }

    public int getStepIndex() {
        if (this.canHandle()) {
            return this.proxiedStep.getStepIndex();
        }
        return 0;
    }

    public String getTitle() {
        if (this.canHandle()) {
            return this.proxiedStep.getTitle();
        }
        return "";
    }

    public void setWizardContext(WizardContext wizardContext) {
        this.context = wizardContext;
        this.proxiedStep.setWizardContext(wizardContext);
    }

    public void setWizardStep(WizardStep wizardStep) {
        this.proxiedStep = wizardStep;
        this.proxiedStep.setWizardContext(this.context);
    }

    public void accept(WizardStepVisitor wizardStepVisitor, WizardContext wizardContext, int n) {
        if (this.canHandle()) {
            wizardStepVisitor.visit(this.proxiedStep, wizardContext, n);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.proxiedStep.addChangeListener(changeListener);
    }

    public boolean canBack() {
        return this.canHandle() && this.proxiedStep.canBack();
    }

    public boolean canFinish() {
        return this.canHandle() && this.proxiedStep.canFinish();
    }

    public boolean canHandle() {
        return this.condition.evaluate(this.context) && this.proxiedStep.canHandle();
    }

    public boolean canNext() {
        return this.canHandle() && this.proxiedStep.canNext();
    }

    public boolean onCancel() {
        return this.proxiedStep.onCancel();
    }

    public void onFinish() {
        this.proxiedStep.onFinish();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.proxiedStep.removeChangeListener(changeListener);
    }

    public void reset() {
        this.proxiedStep = this.nullStep;
    }
}

