/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.websphere6.dd.beans.DDXmiConstants;
import org.netbeans.modules.j2ee.websphere6.dd.beans.EjbBindingsType;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.WSMultiViewDataObject;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ui.CMPConnectionFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ui.ReferenceTablePanel;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ui.ReferencesTableModel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.openide.util.NbBundle;

public class WSEjbBindingsPanel
extends SectionInnerPanel
implements ItemListener,
DDXmiConstants {
    EjbBindingsType ejbBinding;
    WSMultiViewDataObject dObj;
    private static String[] Types = new String[]{NbBundle.getMessage(WSEjbBindingsPanel.class, (String)"LBL_TypeSession"), NbBundle.getMessage(WSEjbBindingsPanel.class, (String)"LBL_TypeEntity"), NbBundle.getMessage(WSEjbBindingsPanel.class, (String)"LBL_TypeContainerManagedEntity"), NbBundle.getMessage(WSEjbBindingsPanel.class, (String)"LBL_TypeMessageDriven")};
    private JTextField cmpConnectionFactoryNameField;
    private JTextField cmpConnectionFactoryJndiNameField;
    private JCheckBox cmpConnectionFactoryCheckBox;
    private JComboBox cmpConnectionFactoryAuthType;
    private static final String FACTORY_NAME = "CMP Connection Factory Name";
    private static final String FACTORY_JNDI_NAME = "CMP Connection Factory JNDI Name";
    private JComboBox beanTypeComboBox;
    private JPanel cmpConnectionFactoryPanel;
    private JTextField hrefField;
    private JTextField idField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JTextField jndiNameField;
    private JLabel typeLabel;

    public WSEjbBindingsPanel(SectionView sectionView, WSMultiViewDataObject wSMultiViewDataObject, EjbBindingsType ejbBindingsType) {
        super(sectionView);
        this.dObj = wSMultiViewDataObject;
        this.ejbBinding = ejbBindingsType;
        this.initComponents();
        this.bindCmpConnectionFactoryComponents();
        this.initCmpConnectionFactoryComponents();
        this.idField.setText(ejbBindingsType.getXmiId());
        this.jndiNameField.setText(ejbBindingsType.getJndiName());
        this.hrefField.setText(ejbBindingsType.getHref());
        this.addModifier(this.hrefField);
        this.addModifier(this.jndiNameField);
        this.addModifier(this.idField);
        this.beanTypeComboBox.setModel(new DefaultComboBoxModel<String>(Types));
        String string = ejbBindingsType.getXmiType();
        if (string != null) {
            if (string.equals("ejb:Session")) {
                this.beanTypeComboBox.setSelectedIndex(0);
            } else if (string.equals("ejb:Entity")) {
                this.beanTypeComboBox.setSelectedIndex(1);
            } else if (string.equals("ejb:ContainerManagedEntity")) {
                this.beanTypeComboBox.setSelectedIndex(2);
            } else if (string.equals("ejb:MessageDriven")) {
                this.beanTypeComboBox.setSelectedIndex(3);
            } else {
                this.beanTypeComboBox.setSelectedIndex(-1);
            }
        } else {
            this.beanTypeComboBox.setSelectedIndex(-1);
        }
        this.beanTypeComboBox.addItemListener(this);
        this.getSectionView().getErrorPanel().clearError();
        ReferencesTableModel referencesTableModel = new ReferencesTableModel(wSMultiViewDataObject.getModelSynchronizer());
        referencesTableModel.setHrefType("EjbJar");
        ReferenceTablePanel referenceTablePanel = new ReferenceTablePanel(wSMultiViewDataObject, referencesTableModel);
        referenceTablePanel.setModel(ejbBindingsType, ejbBindingsType.getReferences());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)((Object)referenceTablePanel), gridBagConstraints);
    }

    private void bindCmpConnectionFactoryComponents() {
        CMPConnectionFactory cMPConnectionFactory = (CMPConnectionFactory)this.cmpConnectionFactoryPanel;
        this.cmpConnectionFactoryNameField = cMPConnectionFactory.getNameField();
        this.cmpConnectionFactoryJndiNameField = cMPConnectionFactory.getJndiNameField();
        this.cmpConnectionFactoryCheckBox = cMPConnectionFactory.getFactoryCheckBox();
        this.cmpConnectionFactoryAuthType = cMPConnectionFactory.getAuthTypeComboBox();
        cMPConnectionFactory.setComponentsBackground(SectionVisualTheme.getSectionActiveBackgroundColor());
        cMPConnectionFactory.setEnabledComponents();
    }

    private void initCmpConnectionFactoryComponents() {
        this.addModifier(this.cmpConnectionFactoryNameField);
        this.addModifier(this.cmpConnectionFactoryJndiNameField);
        this.addValidatee(this.cmpConnectionFactoryNameField);
        this.addValidatee(this.cmpConnectionFactoryJndiNameField);
        boolean bl = this.ejbBinding.getCmpConnectionFactory() != null;
        this.cmpConnectionFactoryCheckBox.setSelected(bl);
        if (bl) {
            this.cmpConnectionFactoryNameField.setText(this.ejbBinding.getCmpConnectionFactoryXmiId());
            this.cmpConnectionFactoryJndiNameField.setText(this.ejbBinding.getCmpConnectionFactoryJndiName());
            this.cmpConnectionFactoryAuthType.setSelectedItem(this.ejbBinding.getCmpConnectionFactoryResAuth());
        }
        this.cmpConnectionFactoryCheckBox.addItemListener(this);
        this.cmpConnectionFactoryAuthType.addItemListener(this);
        ((CMPConnectionFactory)this.cmpConnectionFactoryPanel).setEnabledComponents();
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent == this.idField) {
            this.ejbBinding.setXmiId((String)object);
        } else if (jComponent == this.jndiNameField) {
            this.ejbBinding.setJndiName((String)object);
        } else if (jComponent == this.hrefField) {
            this.ejbBinding.setHref((String)object);
        } else if (jComponent == this.cmpConnectionFactoryNameField) {
            this.ejbBinding.setCmpConnectionFactoryXmiId((String)object);
        } else if (jComponent == this.cmpConnectionFactoryJndiNameField) {
            this.ejbBinding.setCmpConnectionFactoryJndiName((String)object);
        }
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
        String string2;
        if (jTextComponent == this.idField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "ID", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.jndiNameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "JNDI Name", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.hrefField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, "Bean Name", (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.cmpConnectionFactoryNameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, FACTORY_NAME, (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
        if (jTextComponent == this.cmpConnectionFactoryJndiNameField) {
            string2 = string;
            if (string2.length() == 0) {
                this.getSectionView().getErrorPanel().setError(new Error(2, FACTORY_JNDI_NAME, (JComponent)jTextComponent));
                return;
            }
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
        if (this.idField == jTextComponent) {
            this.idField.setText(this.ejbBinding.getXmiId());
        }
        if (this.jndiNameField == jTextComponent) {
            this.jndiNameField.setText(this.ejbBinding.getJndiName());
        }
        if (this.hrefField == jTextComponent) {
            this.hrefField.setText(this.ejbBinding.getHref());
        }
        if (this.cmpConnectionFactoryNameField == jTextComponent) {
            this.cmpConnectionFactoryNameField.setText(this.ejbBinding.getCmpConnectionFactoryXmiId());
        }
        if (this.cmpConnectionFactoryJndiNameField == jTextComponent) {
            this.cmpConnectionFactoryNameField.setText(this.ejbBinding.getCmpConnectionFactoryJndiName());
        }
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        if ("ID".equals(string)) {
            return this.idField;
        }
        if ("JNDI Name".equals(string)) {
            return this.jndiNameField;
        }
        if ("Bean Name".equals(string)) {
            return this.hrefField;
        }
        if (FACTORY_NAME.equals(string)) {
            return this.cmpConnectionFactoryNameField;
        }
        if (FACTORY_JNDI_NAME.equals(string)) {
            return this.cmpConnectionFactoryJndiNameField;
        }
        return null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dObj.setChangedFromUI(true);
        String string = (String)this.beanTypeComboBox.getSelectedItem();
        if (string != null) {
            if (string.equals(Types[0])) {
                this.ejbBinding.setXmiType("ejb:Session");
            } else if (string.equals(Types[1])) {
                this.ejbBinding.setXmiType("ejb:Entity");
            } else if (string.equals(Types[2])) {
                this.ejbBinding.setXmiType("ejb:ContainerManagedEntity");
            } else if (string.equals(Types[3])) {
                this.ejbBinding.setXmiType("ejb:MessageDriven");
            } else {
                this.ejbBinding.setXmiType(null);
            }
        }
        this.changeCmpConnectionFactoryState();
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void changeCmpConnectionFactoryState() {
        if (this.cmpConnectionFactoryCheckBox.isSelected()) {
            this.ejbBinding.setCmpConnectionFactory("");
            this.ejbBinding.setCmpConnectionFactoryXmiId(this.cmpConnectionFactoryNameField.getText());
            this.ejbBinding.setCmpConnectionFactoryResAuth(this.cmpConnectionFactoryAuthType.getSelectedItem().toString());
        } else {
            this.ejbBinding.setCmpConnectionFactory(null);
        }
        ((CMPConnectionFactory)this.cmpConnectionFactoryPanel).setEnabledComponents();
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.idField = new JTextField();
        this.jndiNameField = new JTextField();
        this.hrefField = new JTextField();
        this.typeLabel = new JLabel();
        this.beanTypeComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.cmpConnectionFactoryPanel = new CMPConnectionFactory();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel1.setText("Id:");
        this.jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_JndiName"));
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_BeanName"));
        this.typeLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_BeanType"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel4.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/websphere6/dd/loaders/ui/Bundle").getString("LBL_ReferenceBindings"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.cmpConnectionFactoryPanel, -1, 463, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.typeLabel).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel1)).add(16, 16, 16).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.idField, -1, 389, Short.MAX_VALUE).add((Component)this.hrefField, -1, 389, Short.MAX_VALUE).add((Component)this.jndiNameField, -1, 389, Short.MAX_VALUE).add((Component)this.beanTypeComboBox, -2, 156, -2)))).addContainerGap()).add(2, (Component)this.jSeparator1, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.jLabel4).addContainerGap(370, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, 463, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.idField, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jndiNameField, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.hrefField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.typeLabel).add((Component)this.beanTypeComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.cmpConnectionFactoryPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jPanel1, -1, 14, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

