/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbext;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.websphere6.dd.beans.EjbExtensionsType;
import org.netbeans.modules.j2ee.websphere6.dd.beans.WSEjbExt;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbext.PanelFactory;
import org.netbeans.modules.j2ee.websphere6.dd.loaders.ejbext.WSEjbExtDataObject;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WSEjbExtToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(WSEjbExtToolBarMVElement.class.getName());
    private ToolBarDesignEditor comp;
    private SectionView view;
    private WSEjbExtDataObject dObj;
    private PanelFactory factory;
    private RequestProcessor.Task repaintingTask;
    private boolean needInit = true;
    private Action addExtensionAction;
    private Action removeExtensionAction;
    private static final long serialVersionUID = 76737428339792L;
    private static final String EJBEXT_MV_ID = "ejbext_multiview_design";

    public WSEjbExtToolBarMVElement(WSEjbExtDataObject wSEjbExtDataObject) {
        super((XmlMultiViewDataObject)wSEjbExtDataObject);
        this.dObj = wSEjbExtDataObject;
        this.comp = new ToolBarDesignEditor();
        this.factory = new PanelFactory(this.comp, wSEjbExtDataObject);
        this.addExtensionAction = new AddExtensionAction(NbBundle.getMessage(WSEjbExtToolBarMVElement.class, (String)"LBL_addEjbExtension"));
        this.removeExtensionAction = new RemoveExtensionAction(NbBundle.getMessage(WSEjbExtToolBarMVElement.class, (String)"LBL_removeEjbExtension"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WSEjbExtToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    private void repaintView() {
        this.view = new WSEjbExtView(this.dObj);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        }
        this.view.checkValidity();
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public WSEjbExtView getEjbExtView() {
        return (WSEjbExtView)this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.needInit) {
            this.repaintView();
            this.needInit = false;
        }
        this.comp.setContentView((PanelView)this.view);
        try {
            this.view.openPanel((Object)this.dObj.getEjbExt());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        this.view.checkValidity();
    }

    public void componentOpened() {
        super.componentOpened();
        try {
            this.dObj.getEjbExt().addPropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void componentClosed() {
        super.componentClosed();
        try {
            this.dObj.getEjbExt().removePropertyChangeListener(this);
        }
        catch (IOException iOException) {
            Object var1_2 = null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!this.dObj.isChangedFromUI() && (string = propertyChangeEvent.getPropertyName()).indexOf("EjbJarExt") > 0) {
            if (EJBEXT_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    public Error validateView() {
        return null;
    }

    public static class ExtensionNode
    extends AbstractNode {
        ExtensionNode() {
            super(Children.LEAF);
            this.setDisplayName("Ejb Extension #");
        }
    }

    public static class WSEjbExtNode
    extends AbstractNode {
        WSEjbExtNode(WSEjbExt wSEjbExt) {
            super(Children.LEAF);
            this.setDisplayName("Extended Deployment Information");
        }
    }

    private class RemoveExtensionAction
    extends AbstractAction {
        RemoveExtensionAction(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            SectionPanel sectionPanel = ((SectionPanel.HeaderButton)actionEvent.getSource()).getSectionPanel();
            EjbExtensionsType ejbExtensionsType = (EjbExtensionsType)sectionPanel.getKey();
            try {
                WSEjbExtToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSEjbExtToolBarMVElement.this.dObj.getEjbExt().removeEjbExtensions(ejbExtensionsType);
                sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                sectionPanel.getSectionView().updateUI();
                sectionPanel.updateUI();
                WSEjbExtToolBarMVElement.this.dObj.modelUpdatedFromUI();
            }
            catch (IOException iOException) {
            }
            finally {
                WSEjbExtToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
        }
    }

    private class AddExtensionAction
    extends AbstractAction {
        AddExtensionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                WSEjbExtToolBarMVElement.this.dObj.setChangedFromUI(true);
                long l = System.currentTimeMillis();
                WSEjbExt wSEjbExt = WSEjbExtToolBarMVElement.this.dObj.getEjbExt();
                int n = wSEjbExt.sizeEjbExtensions() + 1;
                EjbExtensionsType ejbExtensionsType = new EjbExtensionsType();
                ejbExtensionsType.setEnterpriseBean("");
                ejbExtensionsType.setXmiName("Extension_" + l);
                ejbExtensionsType.setXmiId("Extension_" + l);
                ejbExtensionsType.setHref("");
                wSEjbExt.addEjbExtensions(ejbExtensionsType);
                ExtensionNode extensionNode = new ExtensionNode();
                WSEjbExtToolBarMVElement.this.view.getRoot().getChildren().add(new Node[]{extensionNode});
                extensionNode.setDisplayName(extensionNode.getDisplayName() + n);
                WSEjbExtToolBarMVElement.this.dObj.setChangedFromUI(true);
                WSEjbExtToolBarMVElement.this.dObj.modelUpdatedFromUI();
                SectionPanel sectionPanel = new SectionPanel(WSEjbExtToolBarMVElement.this.view, (Node)extensionNode, (Object)ejbExtensionsType);
                sectionPanel.setHeaderActions(new Action[]{WSEjbExtToolBarMVElement.this.removeExtensionAction});
                ((WSEjbExtView)WSEjbExtToolBarMVElement.this.view).getEjbExtensionsContainer().addSection((NodeSectionPanel)sectionPanel, true);
                WSEjbExtToolBarMVElement.this.dObj.setChangedFromUI(false);
            }
            catch (IOException iOException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private class WSEjbExtView
    extends SectionView {
        private SectionContainer extensionsCont;
        private WSEjbExt ejbext;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WSEjbExtView(WSEjbExtDataObject wSEjbExtDataObject) {
            super((InnerPanelFactory)WSEjbExtToolBarMVElement.this.factory);
            Children.Array array = new Children.Array();
            AbstractNode abstractNode = new AbstractNode((Children)array);
            try {
                this.ejbext = wSEjbExtDataObject.getEjbExt();
                array.add(new Node[]{this.createEjbExtAttrNode(), this.createEjbExtensionsNode()});
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
                abstractNode.setDisplayName("Invalid EjbExt");
            }
            finally {
                this.setRoot((Node)abstractNode);
            }
        }

        public SectionContainer getEjbExtensionsContainer() {
            return this.extensionsCont;
        }

        private Node createEjbExtAttrNode() {
            WSEjbExtNode wSEjbExtNode = new WSEjbExtNode(this.ejbext);
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, (Node)wSEjbExtNode, (Object)this.ejbext));
            return wSEjbExtNode;
        }

        private Node createEjbExtensionsNode() {
            EjbExtensionsType[] ejbExtensionsTypeArray = this.ejbext.getEjbExtensions();
            Children.Array array = new Children.Array();
            Node[] nodeArray = null;
            if (ejbExtensionsTypeArray != null && ejbExtensionsTypeArray.length > 0) {
                nodeArray = new Node[ejbExtensionsTypeArray.length];
                for (int i = 0; i < ejbExtensionsTypeArray.length; ++i) {
                    nodeArray[i] = new ExtensionNode();
                    nodeArray[i].setDisplayName("Ejb Extension #" + (i + 1));
                }
                array.add(nodeArray);
            }
            SectionContainerNode sectionContainerNode = new SectionContainerNode((Children)array);
            sectionContainerNode.setDisplayName("Ejb Extensions");
            this.extensionsCont = new SectionContainer((SectionView)this, (Node)sectionContainerNode, "Ejb Extension");
            this.extensionsCont.setHeaderActions(new Action[]{WSEjbExtToolBarMVElement.this.addExtensionAction});
            if (ejbExtensionsTypeArray != null) {
                SectionPanel[] sectionPanelArray = new SectionPanel[ejbExtensionsTypeArray.length];
                for (int i = 0; i < ejbExtensionsTypeArray.length; ++i) {
                    sectionPanelArray[i] = new SectionPanel((SectionView)this, nodeArray[i], (Object)ejbExtensionsTypeArray[i]);
                    sectionPanelArray[i].setHeaderActions(new Action[]{WSEjbExtToolBarMVElement.this.removeExtensionAction});
                    this.extensionsCont.addSection((NodeSectionPanel)sectionPanelArray[i]);
                }
            }
            this.addSection((NodeSectionPanel)this.extensionsCont);
            return sectionContainerNode;
        }
    }
}

