/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.websphere6.SafeDeploymentManager;
import org.netbeans.modules.j2ee.websphere6.WSClassLoader;
import org.netbeans.modules.j2ee.websphere6.WSURIManager;
import org.netbeans.modules.j2ee.websphere6.WSVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;

public class WSDeploymentManager
implements DeploymentManager {
    private static final Logger LOGGER = Logger.getLogger(WSDeploymentManager.class.getName());
    private final WSVersion wsVersion;
    private WSClassLoader loader;
    private DeploymentFactory factory;
    private DeploymentManager dm;
    private InstanceProperties instanceProperties;
    private String uri;
    private String username;
    private String password;
    private boolean isConnected;

    public WSDeploymentManager(String string, String string2, String string3, WSVersion wSVersion) {
        assert (wSVersion != null) : "Version must not be null";
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "WSDeploymentManager(" + string + ", " + string2 + ", " + string3 + ")");
        }
        this.uri = string;
        this.username = string2;
        this.password = string3;
        this.wsVersion = wSVersion;
    }

    public WSDeploymentManager(String string, WSVersion wSVersion) {
        this(string, null, null, wSVersion);
    }

    public WSVersion getVersion() {
        return this.wsVersion;
    }

    private void parseUri() {
        String[] stringArray = WSURIManager.getUrlWithoutPrefix(this.uri).split(":");
        this.getInstanceProperties().setProperty("host", stringArray[0]);
        this.getInstanceProperties().setProperty("port", stringArray[1]);
    }

    public String getURI() {
        return this.uri;
    }

    public String getHost() {
        return this.getInstanceProperties().getProperty("host");
    }

    public String getPassword() {
        return this.getInstanceProperties().getProperty("password");
    }

    public String getUsername() {
        return this.getInstanceProperties().getProperty("username");
    }

    public String getPort() {
        return this.getInstanceProperties().getProperty("port");
    }

    public String getAdminPort() {
        return this.getInstanceProperties().getProperty("adminPort");
    }

    public String getDefaultHostPort() {
        return this.getInstanceProperties().getProperty("defaultHostPort");
    }

    public String getServerRoot() {
        return this.getInstanceProperties() != null ? this.getInstanceProperties().getProperty("serverRoot") : "";
    }

    public String getDomainRoot() {
        return this.getInstanceProperties() != null ? this.getInstanceProperties().getProperty("domainRoot") : "";
    }

    public String getLogFilePath() {
        return this.getDomainRoot() + File.separator + "logs" + File.separator + this.getInstanceProperties().getProperty("serverName") + File.separator + "SystemOut.log";
    }

    public boolean isLocal() {
        return this.getInstanceProperties() != null ? Boolean.parseBoolean(this.getInstanceProperties().getProperty("isLocal")) : false;
    }

    public void setServerRoot(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("serverRoot", string);
        }
    }

    public void setDomainRoot(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("domainRoot", string);
        }
    }

    public void setHost(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("host", string);
        }
    }

    public void setPort(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("port", string);
        }
    }

    public void setAdminPort(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("adminPort", string);
        }
    }

    public void setDefaultHostPort(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("defaultHostPort", string);
        }
    }

    public void setPassword(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("password", string);
        }
    }

    public void setUsername(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("username", string);
        }
    }

    public void setServerName(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("serverName", string);
        }
    }

    public void setConfigXmlPath(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("configXmlPath", string);
        }
    }

    public void setIsLocal(String string) {
        if (this.getInstanceProperties() != null) {
            this.getInstanceProperties().setProperty("isLocal", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeploymentFactory() {
        LOGGER.log(Level.FINEST, "loadDeploymentFactory()");
        if (this.factory == null) {
            String string = this.getServerRoot();
            String string2 = this.getDomainRoot();
            this.loader = WSClassLoader.getInstance(string, string2);
            this.loader.updateLoader();
            try {
                this.factory = (DeploymentFactory)this.loader.loadClass("com.ibm.ws.management.application.j2ee.deploy.spi.factories.DeploymentFactoryImpl").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.FINE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.SEVERE, null, illegalAccessException);
            }
            finally {
                this.loader.restoreLoader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeploymentManager() {
        LOGGER.log(Level.FINEST, "updateDeploymentManager()");
        this.loadDeploymentFactory();
        this.loader.updateLoader();
        try {
            if (this.dm != null) {
                this.dm.release();
            }
            if (this.factory != null) {
                this.dm = new SafeDeploymentManager(this.factory.getDeploymentManager(WSURIManager.getRealDeploymentUrl(this.uri), this.username, this.password));
                this.isConnected = true;
            }
        }
        catch (DeploymentManagerCreationException deploymentManagerCreationException) {
            LOGGER.log(Level.FINE, null, deploymentManagerCreationException);
            try {
                this.isConnected = false;
                this.dm = new SafeDeploymentManager(this.factory.getDisconnectedDeploymentManager(WSURIManager.getRealDeploymentUrl(this.uri)));
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException2) {
                LOGGER.log(Level.SEVERE, null, deploymentManagerCreationException2);
            }
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    public InstanceProperties getInstanceProperties() {
        LOGGER.log(Level.FINEST, "getInstanceProperties()");
        if (this.instanceProperties == null) {
            this.instanceProperties = InstanceProperties.getInstanceProperties((String)this.uri);
            if (this.instanceProperties != null) {
                this.parseUri();
            }
        }
        return this.instanceProperties;
    }

    public boolean getIsConnected() {
        return this.isConnected;
    }

    public String getServerTitleMessage() {
        String string = "[" + this.getInstanceProperties().getProperty("serverName") + ", " + this.getInstanceProperties().getProperty("host") + ":" + this.getInstanceProperties().getProperty("port") + "]";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, File file, File file2) throws IllegalStateException {
        Object object;
        boolean bl;
        File file3;
        String string;
        block32: {
            Object object2;
            Object object3;
            String string2;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "distribute(" + Arrays.toString(targetArray) + ", " + file + ", " + file2 + ")");
            }
            this.updateDeploymentManager();
            if (!this.isConnected) {
                throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
            }
            this.loader.updateLoader();
            string = null;
            file3 = file;
            bl = false;
            if (file.exists() && file.getName().endsWith(".war") && file2 != null && file2.exists()) {
                object = null;
                try {
                    string2 = file.getCanonicalPath();
                    object3 = string2.substring(0, string2.length() - 4) + ".ear";
                    object = new JarOutputStream((OutputStream)new FileOutputStream((String)object3), new Manifest());
                    object2 = new ZipEntry("META-INF/application.xml");
                    ((JarOutputStream)object).putNextEntry((ZipEntry)object2);
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    try {
                        FileUtil.copy((InputStream)fileInputStream, (OutputStream)object);
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                    ((ZipOutputStream)object).closeEntry();
                    object2 = new ZipEntry("META-INF/was.webmodule");
                    ((JarOutputStream)object).putNextEntry((ZipEntry)object2);
                    ((FilterOutputStream)object).write("META-INF/was.webmodule".getBytes("UTF-8"));
                    ((ZipOutputStream)object).closeEntry();
                    object2 = new ZipEntry(file.getName());
                    ((JarOutputStream)object).putNextEntry((ZipEntry)object2);
                    FileInputStream fileInputStream2 = new FileInputStream(file);
                    try {
                        FileUtil.copy((InputStream)fileInputStream2, (OutputStream)object);
                    }
                    finally {
                        ((InputStream)fileInputStream2).close();
                    }
                    ((ZipOutputStream)object).closeEntry();
                    file3 = new File((String)object3);
                    bl = true;
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
                finally {
                    try {
                        if (object != null) {
                            ((ZipOutputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            if (file3.exists() && file3.getPath().endsWith(".ear")) {
                try {
                    object = new JarFileSystem();
                    object.setJarFile(file3);
                    string2 = object.getRoot().getFileObject("META-INF/application.xml");
                    if (string2 == null) break block32;
                    object3 = DDProvider.getDefault().getDDRoot((FileObject)string2);
                    object2 = object3.getModule();
                    for (int i = 0; i < ((Module[])object2).length; ++i) {
                        if (object2[i].getWeb() == null) continue;
                        string = object2[i].getWeb().getContextRoot();
                        break;
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.INFO, null, iOException);
                }
                catch (PropertyVetoException propertyVetoException) {
                    LOGGER.log(Level.INFO, null, propertyVetoException);
                }
            }
        }
        try {
            object = new WSProgressObject(this.dm.distribute(targetArray, file3, null), this.loader, string, this.getFullUrl(string), bl);
            return object;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "redeploy(" + Arrays.toString(targetModuleIDArray) + ", " + inputStream + ", " + inputStream2 + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.redeploy(targetModuleIDArray, inputStream, inputStream2);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetArray, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "distribute(" + Arrays.toString(targetArray) + ", " + inputStream + ", " + inputStream2 + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.distribute(targetArray, inputStream, inputStream2);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    public ProgressObject distribute(Target[] targetArray, ModuleType moduleType, InputStream inputStream, InputStream inputStream2) throws IllegalStateException {
        return this.distribute(targetArray, inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "undeploy(" + Arrays.toString(targetModuleIDArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.undeploy(targetModuleIDArray);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject stop(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "stop(" + Arrays.toString(targetModuleIDArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.stop(targetModuleIDArray);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject start(TargetModuleID[] targetModuleIDArray) throws IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "start(" + Arrays.toString(targetModuleIDArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.start(targetModuleIDArray);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getAvailableModules(" + moduleType + ", " + Arrays.toString(targetArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.dm.getAvailableModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getNonRunningModules(" + moduleType + ", " + Arrays.toString(targetArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.dm.getNonRunningModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetArray) throws TargetException, IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getRunningModules(" + moduleType + ", " + Arrays.toString(targetArray) + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            TargetModuleID[] targetModuleIDArray;
            TargetModuleID[] targetModuleIDArray2 = targetModuleIDArray = this.dm.getRunningModules(moduleType, targetArray);
            return targetModuleIDArray2;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject redeploy(TargetModuleID[] targetModuleIDArray, File file, File file2) throws UnsupportedOperationException, IllegalStateException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "redeploy(" + Arrays.toString(targetModuleIDArray) + ", " + file + ", " + file2 + ")");
        }
        this.updateDeploymentManager();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        this.loader.updateLoader();
        try {
            ProgressObject progressObject = this.dm.redeploy(targetModuleIDArray, file, file2);
            return progressObject;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    public void release() {
        LOGGER.log(Level.FINEST, "release()");
        if (this.dm != null) {
            this.dm.release();
            this.dm = null;
        }
    }

    public boolean isRedeploySupported() {
        LOGGER.log(Level.FINEST, "isRedeploySupported()");
        this.updateDeploymentManager();
        return this.dm.isRedeploySupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Target[] getTargets() throws IllegalStateException {
        LOGGER.log(Level.FINEST, "getTargets()");
        this.updateDeploymentManager();
        this.loader.updateLoader();
        if (!this.isConnected) {
            throw new IllegalStateException(NbBundle.getMessage(WSDeploymentManager.class, (String)"ERR_illegalState"));
        }
        try {
            Target[] targetArray = this.dm.getTargets();
            return targetArray;
        }
        finally {
            this.loader.restoreLoader();
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject deployableObject) throws InvalidModuleException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public boolean isLocaleSupported(Locale locale) {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType dConfigBeanVersionType) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType dConfigBeanVersionType) {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException("This method should never be called");
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException("This method should never be called");
    }

    private String getFullUrl(String string) {
        String string2 = this.getDefaultHostPort();
        String string3 = this.getHost();
        if (this.uri.indexOf("deployer:WebSphere:") != -1 || this.uri.indexOf("deployer:WebSphere61:") != -1) {
            string3 = WSURIManager.getUrlWithoutPrefix(this.uri).split(":")[0];
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("http://").append(string3).append(":").append(string2);
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static class WSTargetModuleID
    implements TargetModuleID {
        private final TargetModuleID delegate;

        public WSTargetModuleID(TargetModuleID targetModuleID) {
            this.delegate = targetModuleID;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String getWebURL() {
            return this.delegate.getWebURL();
        }

        public void setWebURL(String string) {
            try {
                Method method = this.delegate.getClass().getMethod("setWebURL", String.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public Target getTarget() {
            return this.delegate.getTarget();
        }

        public void setTarget(Target target) {
            try {
                Method method = this.delegate.getClass().getMethod("setTarget", Target.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, target);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public TargetModuleID getParentTargetModuleID() {
            return this.delegate.getParentTargetModuleID();
        }

        public void setParentTargetModuleID(TargetModuleID targetModuleID) {
            try {
                Method method = this.delegate.getClass().getMethod("setParentTargetModuleID", TargetModuleID.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, targetModuleID);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public String getModuleID() {
            return this.delegate.getModuleID();
        }

        public TargetModuleID[] getChildTargetModuleID() {
            return this.delegate.getChildTargetModuleID();
        }

        public void setChildTargetModuleID(TargetModuleID[] targetModuleIDArray) {
            try {
                Method method = this.delegate.getClass().getMethod("setChildTargetModuleID", TargetModuleID[].class);
                if (method != null) {
                    method.invoke((Object)this.delegate, new Object[]{targetModuleIDArray});
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public void setObjectName(ObjectName objectName) {
            try {
                Method method = this.delegate.getClass().getMethod("setObjectName", ObjectName.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, objectName);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public void setModuleID(String string) {
            try {
                Method method = this.delegate.getClass().getMethod("setModuleID", String.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public void setModuleType(String string) {
            try {
                Method method = this.delegate.getClass().getMethod("setModuleType", String.class);
                if (method != null) {
                    method.invoke((Object)this.delegate, string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public void setStartable(boolean bl) {
            try {
                Method method = this.delegate.getClass().getMethod("setStartable", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)this.delegate, true);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOGGER.log(Level.INFO, null, noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.INFO, null, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.log(Level.INFO, null, invocationTargetException);
            }
        }

        public TargetModuleID getDelegate() {
            return this.delegate;
        }
    }

    private static class WSProgressObject
    implements ProgressObject {
        private final ProgressObject delegate;
        private final WSClassLoader loader;
        private final String webUrl;
        private final String fullUrl;
        private final boolean web;

        public WSProgressObject(ProgressObject progressObject, WSClassLoader wSClassLoader, String string, String string2, boolean bl) {
            this.delegate = progressObject;
            this.loader = wSClassLoader;
            this.webUrl = string;
            this.fullUrl = string2;
            this.web = bl;
        }

        public void stop() throws OperationUnsupportedException {
            this.delegate.stop();
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.delegate.removeProgressListener(progressListener);
        }

        public boolean isStopSupported() {
            return this.delegate.isStopSupported();
        }

        public boolean isCancelSupported() {
            return this.delegate.isCancelSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TargetModuleID[] getResultTargetModuleIDs() {
            WSTargetModuleID wSTargetModuleID;
            TargetModuleID[] targetModuleIDArray = this.delegate.getResultTargetModuleIDs();
            if (this.webUrl != null && targetModuleIDArray != null && targetModuleIDArray.length == 1 && targetModuleIDArray[0].getChildTargetModuleID() == null && targetModuleIDArray[0].getModuleID().contains("type=Application")) {
                try {
                    this.loader.updateLoader();
                    wSTargetModuleID = new WSTargetModuleID((TargetModuleID)this.loader.loadClass("com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl").newInstance());
                    wSTargetModuleID.setTarget(targetModuleIDArray[0].getTarget());
                    wSTargetModuleID.setParentTargetModuleID(targetModuleIDArray[0]);
                    String string = "WebSphere:name=" + this.webUrl.substring(1) + ",type=WebModule";
                    wSTargetModuleID.setObjectName(new ObjectName(string + ",*"));
                    wSTargetModuleID.setModuleID(string);
                    wSTargetModuleID.setModuleType("WebModule");
                    wSTargetModuleID.setStartable(true);
                    wSTargetModuleID.setWebURL(this.fullUrl);
                    new WSTargetModuleID(targetModuleIDArray[0]).setChildTargetModuleID(new TargetModuleID[]{wSTargetModuleID.getDelegate()});
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOGGER.log(Level.INFO, null, classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    LOGGER.log(Level.INFO, null, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOGGER.log(Level.INFO, null, illegalAccessException);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    LOGGER.log(Level.INFO, null, malformedObjectNameException);
                }
                finally {
                    this.loader.restoreLoader();
                }
            }
            if (targetModuleIDArray[0].getModuleID().contains("type=WebModule") || targetModuleIDArray[0].getModuleID().contains("type=Application") && this.web) {
                try {
                    wSTargetModuleID = new WSTargetModuleID(targetModuleIDArray[0]);
                    wSTargetModuleID.setModuleID(wSTargetModuleID.getModuleID().replaceAll("type=Application", "type=WebModule"));
                    wSTargetModuleID.setWebURL(this.fullUrl);
                    wSTargetModuleID.setModuleType("WebModule");
                }
                finally {
                    this.loader.updateLoader();
                }
            }
            return targetModuleIDArray;
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.delegate.getDeploymentStatus();
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return this.delegate.getClientConfiguration(targetModuleID);
        }

        public void cancel() throws OperationUnsupportedException {
            this.delegate.cancel();
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.delegate.addProgressListener(progressListener);
        }
    }
}

